/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.data.Category;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.utils.tools.IToolFunction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FunctionalGroup
implements IChildProvidable,
IToolFunction {
    public static final String NAME_PREFIX_FOR_ADDING = "PeriphsFunc_";
    public static final String NAME_DEFAULT = "BOARD_InitPeripherals";
    public static final String NAME_RESERVED = "BOARD_InitBootPeripherals";
    private static final Logger LOGGER = LogManager.getLogger(FunctionalGroup.class);
    private String name = "BOARD_InitPeripherals";
    private String description = "";
    private final Map<String, ComponentInstanceConfig> instances = new LinkedHashMap<String, ComponentInstanceConfig>();
    private final StoragePeriphsFuncGroup storageFuncGroup;
    protected final ChildContext childContext;
    protected final ExpressionContext expressionContext;
    protected final IMcu mcu;
    private boolean calledFromDefaultInit;
    private String idPrefix = "";
    private String selectedCoreId = "";

    public FunctionalGroup(ChildContext parentContext, IMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild(this);
        this.childContext.setFunctionalGroup(this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.storageFuncGroup = new StoragePeriphsFuncGroup();
        this.updateStorage();
    }

    public FunctionalGroup(ChildContext parentContext, StoragePeriphsFuncGroup storageFuncGroup, IMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild(this);
        this.childContext.setFunctionalGroup(this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.storageFuncGroup = storageFuncGroup;
        this.name = storageFuncGroup.getName();
        this.calledFromDefaultInit = storageFuncGroup.isCalledFromInit();
        this.description = storageFuncGroup.getDescription();
        this.idPrefix = storageFuncGroup.getId_prefix();
        String funcGrSelCore = storageFuncGroup.getSelectedCore();
        ProcessorCore coreFromStorage = this.mcu.getCore(funcGrSelCore);
        if (coreFromStorage != null) {
            this.selectedCoreId = coreFromStorage.getID();
        } else {
            String selectedCore = parentContext.getProfile().getActiveCoreId();
            if (funcGrSelCore.isEmpty() && !selectedCore.isEmpty()) {
                this.setCore(selectedCore);
            } else {
                this.setMasterCoreAsUsed();
            }
        }
        storageFuncGroup.getInstances().forEach(x -> {
            ComponentConfig componentConfig = this.childContext.getProfile().getComponent(x.getType());
            if (componentConfig != null) {
                ChildContext componentCtx = componentConfig.getChildContext();
                this.instances.put(x.getName(), new ComponentInstanceConfig(componentConfig.getComponent(), this, (StoragePeriphsComponentInstance)x, componentCtx, mcu));
            } else {
                LOGGER.severe("[DATA] Component with id not found: " + x.getType());
            }
        });
        this.updateStorage();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.storageFuncGroup.setName(name);
    }

    @Override
    public @NonNull String getIdForTooltip() {
        return this.getName();
    }

    public Map<String, ComponentInstanceConfig> getInstances() {
        return CollectionsUtils.unmodifiableMap(this.instances);
    }

    public Collection<ComponentInstanceConfig> getInstancesOfType(String type) {
        return (Collection)this.instances.values().stream().filter(x -> type.equals(x.getComponent().getId())).collect(CollectorsUtils.toList());
    }

    public Collection<ComponentInstanceConfig> getInstancesOfCategory(String category) {
        return (Collection)this.instances.values().stream().filter(x -> category.equals(x.getComponent().getCategory())).collect(CollectorsUtils.toList());
    }

    public Collection<ComponentInstanceConfig> getInstancesWithoutMatchingCategory(Collection<Category> categories) {
        return (Collection)this.instances.values().stream().filter(cic -> categories.stream().noneMatch(cat -> cat.getId().equals(cic.getComponent().getCategory()))).collect(CollectorsUtils.toList());
    }

    public void addInstance(ComponentInstanceConfig componentConfig) {
        this.instances.put(componentConfig.getName(), componentConfig);
        this.updateStorage();
    }

    public @Nullable ComponentInstanceConfig getComponentInstance(String type, String instanceName) {
        ComponentInstanceConfig instance = this.instances.get(instanceName);
        if (instance != null && !type.equals(instance.getType())) {
            LOGGER.severe("Component instance with name " + instanceName + " does not match the required type: " + type);
            return null;
        }
        return instance;
    }

    public void setConfiguredComponents(Map<String, ComponentInstanceConfig> configuredComponents) {
        this.instances.clear();
        this.instances.putAll(configuredComponents);
        this.updateStorage();
    }

    public @Nullable ComponentInstanceConfig getInstance(String instanceName) {
        return this.instances.get(instanceName);
    }

    public void renameInstance(String oldName, String newName) {
        ComponentInstanceConfig instance = this.instances.get(oldName);
        if (instance != null) {
            instance.setName(newName);
            this.instances.remove(oldName);
            if (this.instances.put(newName, instance) != null) {
                String message = MessageFormat.format("Component with ID {0}, of type {1} and name {2} was renamed to {3}, which caused a name conflict", instance.getId(), instance.getComponent().getId(), oldName, newName);
                LOGGER.warning(message);
                this.updateStorage();
            }
        }
    }

    public boolean removeInstance(String instanceName) {
        boolean result = this.instances.remove(instanceName) != null;
        this.updateStorage();
        return result;
    }

    public boolean removeAllInstances(String type) {
        boolean result = this.instances.values().removeIf(x -> x.getComponent().getId().equals(type));
        if (result) {
            this.updateStorage();
        }
        return result;
    }

    private void updateStorage() {
        this.storageFuncGroup.setName(this.name);
        this.storageFuncGroup.setCalledFromInit(this.calledFromDefaultInit);
        this.storageFuncGroup.setDescription(this.description);
        this.storageFuncGroup.setId_prefix(this.idPrefix);
        this.storageFuncGroup.setSelectedCore(this.selectedCoreId);
        this.storageFuncGroup.getInstances().clear();
        this.instances.values().forEach(x -> {
            boolean bl = this.storageFuncGroup.getInstances().add(x.getStorageComponent());
        });
    }

    public StoragePeriphsFuncGroup getStorageFuncGroup() {
        return this.storageFuncGroup;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative(this, id);
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        return this.getInstance(childName);
    }

    @Override
    public List<? extends IChild> getChildren() {
        ArrayList<ComponentInstanceConfig> children = new ArrayList<ComponentInstanceConfig>(this.instances.values());
        return children;
    }

    @Override
    public @NonNull String getUiName() {
        return this.name;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.storageFuncGroup.setDescription(description);
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    @Override
    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public String getCore() {
        return this.selectedCoreId;
    }

    public void setCore(String newCore) {
        this.selectedCoreId = newCore;
        this.storageFuncGroup.setSelectedCore(newCore);
    }

    public boolean isRemovable() {
        return this.childContext.getProfile().getFunctionalGroups().size() > 1;
    }

    public boolean isCalledFromDefaultInit() {
        return this.calledFromDefaultInit;
    }

    public void setCalledFromDefaultInit(boolean calledFromDefaultInit) {
        this.calledFromDefaultInit = calledFromDefaultInit;
        this.storageFuncGroup.setCalledFromInit(calledFromDefaultInit);
    }

    public boolean canBeCalledFromDefaultInit() {
        return true;
    }

    @Override
    public @Nullable String getWarning() {
        return IChildProvidable.super.getWarning();
    }

    @Override
    public @Nullable String getError() {
        return IChildProvidable.super.getError();
    }

    @Override
    public String @Nullable [] getOwnProblems(Level level) {
        if (level.equals((Object)Level.WARNING)) {
            String activeCoreId = this.getChildContext().getProfile().getActiveCoreId();
            String funcGroupCoreId = this.getCore();
            if (!UtilsText.isEmpty((String)activeCoreId) && !activeCoreId.equals(funcGroupCoreId)) {
                return new String[]{MessageFormat.format(UtilsText.safeString((String)Messages.get().FunctionalGroup_DifferentSelectedCore), UtilsText.safeString((String)this.mcu.getCoreUiName(funcGroupCoreId)), UtilsText.safeString((String)this.mcu.getCoreUiName(activeCoreId)))};
            }
        }
        return null;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
        this.storageFuncGroup.setId_prefix(idPrefix);
    }

    public boolean isPeripheralUsed(String peripheralName) {
        for (ComponentInstanceConfig component : this.instances.values()) {
            if (component == null || !component.isPeripheralUsed(peripheralName)) continue;
            return true;
        }
        return false;
    }

    public void setMasterCoreAsUsed() {
        this.setCore(FunctionalGroup.getMasterCore(this.getMcu()));
    }

    public boolean setCoreFrom(ICommonConfig commonConfig) {
        ProcessorCore coreFromMcu;
        ProcessorCore coreFromCommonConfig = commonConfig.getSelectedCore();
        if (coreFromCommonConfig != null && (coreFromMcu = this.mcu.getCore(coreFromCommonConfig.getID())) != null) {
            this.setCore(coreFromMcu.getID());
            return true;
        }
        return false;
    }

    public static final String getMasterCore(IMcu mcuWithCores) {
        return mcuWithCores.getMasterCore();
    }

    public List<String> getListOfFinalInstanceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ComponentInstanceConfig instance : this.getInstances().values()) {
            result.add(this.createIdentifier(instance.getId()));
        }
        return result;
    }

    public String createIdentifier(String id) {
        return String.valueOf(this.getIdPrefix().toUpperCase()) + "_" + this.getCore() + "_" + id.toUpperCase();
    }

    @Override
    public void updateStorageAvailability() {
        this.instances.values().forEach(c -> c.updateStorageAvailability());
    }

    public @NonNull String getSettingsSummary() {
        ProcessorCore coreFromStorage;
        ArrayList<String> summary = new ArrayList<String>();
        if (this.mcu.getCores().size() > 1 && (coreFromStorage = this.mcu.getCore(this.storageFuncGroup.getSelectedCore())) != null) {
            summary.add(UtilsText.format((String)Messages.get().FunctionalGroup_selectedCore, (Object[])new Object[]{coreFromStorage.getName()}));
        }
        Integer componentsConfiguredCount = this.instances.size();
        summary.add(UtilsText.format((String)Messages.get().FunctionalGroup_componentsConfiguredCount, (Object[])new Object[]{componentsConfiguredCount}));
        return UtilsText.join(summary, (String)"<br/>");
    }
}

