/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IExpressionPrintable;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.frequency.AbstractUnit;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.ComparatorHelpers;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.time.TimeCalculator;
import com.nxp.swtools.common.utils.time.TimePeriod;
import com.nxp.swtools.common.utils.time.TimeUnit;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.expert.clock.modules.ClockSignal;
import com.nxp.swtools.expert.clock.modules.InputSignal;
import com.nxp.swtools.expert.clock.modules.NoSignal;
import com.nxp.swtools.expert.clock.modules.PeripheralComponent;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentInput;
import com.nxp.swtools.expert.clock.modules.PeripheralSignal;
import com.nxp.swtools.expert.clock.modules.PinSignal;
import com.nxp.swtools.expert.clock.modules.PinsToolReference;
import com.nxp.swtools.periphs.model.config.ArrayConfig;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.CastableValue;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.PeripheralExpressionException;
import com.nxp.swtools.periphs.model.config.PinsSignalsProvider;
import com.nxp.swtools.periphs.model.config.ScalarConfig;
import com.nxp.swtools.periphs.model.config.ScalarUtils;
import com.nxp.swtools.periphs.model.config.SetConfig;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ArraySetting;
import com.nxp.swtools.periphs.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.periphs.model.data.setting.FloatSetting;
import com.nxp.swtools.periphs.model.data.setting.IAvailable;
import com.nxp.swtools.periphs.model.data.setting.IEnabled;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.IUIName;
import com.nxp.swtools.periphs.model.data.setting.IntegerSetting;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.pins.RoutableSignal;
import com.nxp.swtools.provider.configuration.dependencies.pins.RoutedPin;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.eclipse.core.runtime.Platform;

public class ExpressionFunctions {
    private static final Logger LOGGER = LogManager.getLogger(ExpressionFunctions.class);
    private static final String TYPE_NO_SIGNAL = "NOT_CONNECTED";
    private static final String TYPE_INPUT_SIGNAL = "INPUT_SIGNAL";
    private static final String TYPE_PIN_SIGNAL = "PIN_SIGNAL";
    private static final String TYPE_PERIPHERAL_SIGNAL = "PERIPHERAL_SIGNAL";
    private static final String PIN_SIGNAL_PROVIDER = "pinSignalProvider";
    private static final String SCRIPT_CONTEXT_ATTRIBUTE = "child";
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    public static long PAD_LEVEL_SIZE = 2L;
    private final FunctionInvocation function;
    final IContext argContext;
    private final ChildContext childContext;
    private final IMcu mcu;

    public ExpressionFunctions(FunctionInvocation function, IContext argContext, ChildContext childContext, IMcu mcu) {
        this.function = function;
        this.argContext = argContext;
        this.childContext = childContext;
        this.mcu = mcu;
    }

    private IValue throwUnknownFunctionForArgument(int index) {
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(index).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return this.throwWarning(description);
    }

    private IValue throwWarning(String description) {
        PeripheralExpressionException exception = this.createException(description);
        exception.setSeverity(Level.WARNING);
        throw exception;
    }

    private IValue throwSevere(String description) {
        PeripheralExpressionException exception = this.createException(description);
        exception.setSeverity(Level.SEVERE);
        throw exception;
    }

    private PeripheralExpressionException createException(String description) {
        PeripheralExpressionException exception = new PeripheralExpressionException(description, ExpressionFunctions.class);
        exception.addChildContext(this.childContext);
        exception.setFunction(this.function);
        throw exception;
    }

    public IValue featureDefined(String feature) {
        FunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        String peripheral = ExpressionFunctions.getPeripheral(this.childContext);
        return Value.valueOf((boolean)this.mcu.hasFeature(feature, core, peripheral));
    }

    public IValue getFeature(String feature) {
        String peripheral;
        FunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
        String core = functionalGroup == null ? null : functionalGroup.getCore();
        String featureValue = this.mcu.getFeature(feature, core, peripheral = ExpressionFunctions.getPeripheral(this.childContext));
        if (featureValue == null) {
            String description = MessageFormat.format("Feature {0} not defined for the part number {1}, core {2} and peripheral {3}", feature, this.mcu.getPartNumber(), core, peripheral);
            return this.throwWarning(description);
        }
        Expression expression = Expression.tryCreate((String)featureValue);
        if (expression == null) {
            String description = MessageFormat.format("Expression with code: {0} cannot be parsed.", featureValue);
            return this.throwWarning(description);
        }
        return new CastableValue(expression.resolve(this.argContext).getValue());
    }

    public IValue hasOption(IChild settingConfig, String optionName) {
        return Value.valueOf((boolean)settingConfig.isOptionSet(optionName));
    }

    public IValue getOptionValue(IChild node, String name) {
        if (!node.isOptionSet(name)) {
            String description = MessageFormat.format("Option: {0} does not exist in child with id: {1}", name, node.getId());
            return this.throwSevere(description);
        }
        Object optionValue = node.getOptionValue(name);
        if (optionValue == null) {
            String description = MessageFormat.format("Value of option: {0} is not set in child with id: {1}", name, node.getId());
            return this.throwSevere(description);
        }
        return Value.valueOf((Object)optionValue);
    }

    public IValue value(Object node) {
        if (node instanceof IChild) {
            IChild child = (IChild)node;
            if (SWToolsProperties.isVerificationOn() && !child.isAvailable()) {
                LOGGER.warning("Asking for value of: " + child.getId() + " which is currently unavailable");
            }
            return Value.valueOf((Object)child.getValue());
        }
        if (node instanceof SetSetting.Item) {
            return Value.valueOf((String)((SetSetting.Item)node).getValue());
        }
        String description = MessageFormat.format("Cannot obtain value of a: {0}", node);
        return this.throwWarning(description);
    }

    public IValue getDescription(IChild node) {
        return Value.valueOf((String)UtilsText.safeString((String)node.getDescription()));
    }

    public IValue getLabel(Object node) {
        if (node instanceof IUIName) {
            return Value.valueOf((String)((IUIName)node).getUIName(this.argContext));
        }
        if (node instanceof IChild) {
            return Value.valueOf((String)((IChild)node).getUiName());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getValueDescription(IChild node) {
        return Value.valueOf((String)UtilsText.safeString((String)node.getValueDescription()));
    }

    public IValue getID(Object node) {
        if (node instanceof IID) {
            return Value.valueOf((String)((IID)node).getId());
        }
        if (node instanceof IChild) {
            return Value.valueOf((String)((IChild)node).getName());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getPeripheral(IChild child) {
        if (child instanceof ComponentInstanceConfig) {
            return Value.valueOf((String)UtilsText.safeString((String)ExpressionFunctions.getPeripheral(((ComponentInstanceConfig)child).getChildContext())));
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue getMode(IChild child) {
        return Value.valueOf((String)ExpressionFunctions.getModeId(child.getChildContext()));
    }

    public IValue getFnGroupName(IChild child) {
        if (child instanceof FunctionalGroup) {
            @Nullable FunctionalGroup functionalGroup = child.getChildContext().getFunctionalGroup();
            if (functionalGroup == null) {
                String description = MessageFormat.format("Given child with id: {0} has no functional group", child.getId());
                return this.throwWarning(description);
            }
            return Value.valueOf((String)functionalGroup.getName());
        }
        return Value.valueOf((String)ExpressionFunctions.getFunctionalGroupName(child.getChildContext()));
    }

    public IValue getFnGroupPrefix(IChild child) {
        return Value.valueOf((String)ExpressionFunctions.getFnGroupPrefixHelper(child));
    }

    public IValue isCalledFromDefaultInit(IChild child) {
        return Value.valueOf((boolean)ExpressionFunctions.isFnGroupDefaultInitHelper(child));
    }

    public IValue getType(IChild child) {
        return Value.valueOf((String)UtilsText.safeString((String)child.getTypeName()));
    }

    public IValue isAvailable(Object node) {
        if (node instanceof IAvailable) {
            return Value.valueOf((boolean)((IAvailable)node).isAvailable(this.argContext));
        }
        if (node instanceof IChild) {
            return Value.valueOf((boolean)((IChild)node).isAvailable());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue isEnabled(Object node) {
        if (node instanceof IEnabled) {
            return Value.valueOf((boolean)((IEnabled)node).isEnabled(this.argContext));
        }
        if (node instanceof IChild) {
            return Value.valueOf((boolean)((IChild)node).isEnabled());
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue isCIdentifier(String name) {
        return Value.valueOf((boolean)ExpressionFunctions.isCIdentifierHelper(name));
    }

    public IValue toLowerCase(String text) {
        return Value.valueOf((String)UtilsText.safeString((String)text.toLowerCase()));
    }

    public IValue toUpperCase(String text) {
        return Value.valueOf((String)UtilsText.safeString((String)text.toUpperCase()));
    }

    public IValue getCValue(IChild child) {
        if (child instanceof ScalarConfig) {
            ScalarConfig scalarConfig = (ScalarConfig)child;
            switch (scalarConfig.getType()) {
                case STRING: 
                case INFO: {
                    return Value.valueOf((String)("\"" + scalarConfig.getValue() + "\""));
                }
                case BOOL: {
                    return Value.valueOf((boolean)((Boolean)scalarConfig.getValue()));
                }
                case FLOAT: 
                case ENUM: {
                    return Value.valueOf((String)scalarConfig.getValueName());
                }
                case INTEGER: {
                    int radix = ScalarUtils.detectIntegerBase(scalarConfig.getStringValue().trim());
                    if (radix == 2) {
                        radix = 16;
                    }
                    return this.toString(Value.valueOf((Object)scalarConfig.getValue()).getBigInteger(), radix);
                }
            }
        } else if (child instanceof SetConfig) {
            return Value.valueOf((String)((String)((SetConfig)child).getChildren().stream().filter(x -> x.isAvailable()).filter(x -> x.getBoolValue()).map(x -> x.getItem().getId()).collect(CollectorsUtils.joining((CharSequence)" | "))));
        }
        return this.throwUnknownFunctionForArgument(0);
    }

    public IValue leftPadding(String argument, long level) {
        return Value.valueOf((String)ExpressionFunctions.padLeft(ExpressionFunctions.trimLeft(argument), level));
    }

    public IValue getResource(String tableId, String definitionId) {
        ISettingConfig setting = this.mcu.getAvailableResourceTables().getResource(tableId, definitionId);
        if (setting == null) {
            String description = MessageFormat.format("Could not retrieve resource setting for arguments `{0}` and `{1}` of the function: {2}", tableId, definitionId, this.function.getName());
            return this.throwWarning(description);
        }
        return Value.valueOf((Object)setting);
    }

    public IValue getResource(String tableId, String definitionId, String component) {
        ConfigurationComponentTypeId configurationComponentTypeId = this.childContext.getProfile().getActiveComponents().getComponentTypeIdByType(component);
        String typeId = configurationComponentTypeId != null ? configurationComponentTypeId.getTypeId() : component;
        ISettingConfig setting = this.mcu.getAvailableResourceTables().getResource(tableId, definitionId, typeId);
        if (setting == null) {
            String description = MessageFormat.format("Could not retrieve resource setting for arguments `{0}` and `{1}` of the function: {2}", tableId, definitionId, this.function.getName());
            return this.throwWarning(description);
        }
        return Value.valueOf((Object)setting);
    }

    public IValue getPeripheralSignals(String peripheral) {
        ConfigSetConfig configSetConfig = this.childContext.getConfigSetConfig();
        PinsSignalsProvider pinsSignalsProvider = configSetConfig != null ? CacheHelper.getValueCaching(configSetConfig, PIN_SIGNAL_PROVIDER + peripheral, () -> ExpressionFunctions.getPinsSignalProvider(peripheral)) : ExpressionFunctions.getPinsSignalProvider(peripheral);
        if (pinsSignalsProvider == null) {
            LOGGER.warning("Cannot resolve query: getPeripheralSignals(" + peripheral + ")");
            return Value.valueOf((boolean)false);
        }
        return Value.valueOf(pinsSignalsProvider.createItemsFromSignals());
    }

    public IValue toInt(String text) {
        BigInteger result;
        try {
            result = ScalarUtils.parseInteger(text);
        }
        catch (NumberFormatException numberFormatException) {
            BigRational parsedValue = BigRational.tryParse((String)text);
            if (parsedValue == null) {
                String description = MessageFormat.format("Could not parse integer value of argument: {0} of the function: {1}", text, this.function.getName());
                return this.throwWarning(description);
            }
            result = parsedValue.toBigIntegerRounded(false);
        }
        return ExpressionFunctions.getBestFittingTypeOfValue(result);
    }

    private static IValue getBestFittingTypeOfValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
            return Value.valueOf((long)bigInteger.longValue());
        }
        return Value.valueOf((BigInteger)bigInteger);
    }

    public IValue toInt(BigRational rational) {
        long result = rational.toBigIntegerRounded(false).longValue();
        return Value.valueOf((long)result);
    }

    public IValue toString(Object node) {
        return Value.valueOf((String)UtilsText.safeString((String)node.toString()));
    }

    public IValue toString(BigInteger integer, int radix) {
        String result = integer.toString(radix);
        switch (radix) {
            case 2: {
                result = "0b" + result;
                break;
            }
            case 8: {
                result = "0" + result;
                break;
            }
            case 10: {
                break;
            }
            case 16: {
                result = "0x" + result.toUpperCase();
                break;
            }
            default: {
                String description = MessageFormat.format("Unsupported value of radix argument: {0} of the function: {1}", String.valueOf(radix), this.function.getName());
                return this.throwWarning(description);
            }
        }
        return Value.valueOf((String)result);
    }

    public IValue round(BigRational result) {
        return Value.valueOf((BigRational)new BigRational(result.toBigIntegerRounded(true)));
    }

    public IValue extractSignalId(String pinSignalId) {
        String[] signalSplit = pinSignalId.split("\\.");
        if (signalSplit.length < 2) {
            LOGGER.warning("Unable to extract signal ID from: " + pinSignalId);
            return Value.valueOf((String)pinSignalId);
        }
        return Value.valueOf((String)UtilsText.safeString((String)signalSplit[signalSplit.length - 2]));
    }

    public IValue extractChannelId(String pinSignalId) {
        String[] signalSplit = pinSignalId.split("\\.", -1);
        if (signalSplit.length < 2) {
            LOGGER.warning("Unable to extract channel ID from: " + pinSignalId);
            return Value.valueOf((String)pinSignalId);
        }
        return Value.valueOf((String)UtilsText.safeString((String)signalSplit[signalSplit.length - 1]));
    }

    public IValue regexSubstr(String text, String regExp, int groupIndex) {
        Pattern regExpPattern = Pattern.compile(regExp);
        Matcher regExpMatcher = regExpPattern.matcher(text);
        regExpMatcher.find();
        String substr = regExpMatcher.group(groupIndex);
        return Value.valueOf((String)UtilsText.safeString((String)substr));
    }

    public IValue regexMatch(String text, String regex) {
        return Value.valueOf((boolean)text.matches(regex));
    }

    public IValue contains(String text, String searchFor) {
        return Value.valueOf((boolean)text.contains(searchFor));
    }

    public IValue getParent(Object node) {
        String description = MessageFormat.format("Could not get parent of argument: {0} of the function: {1}", this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function), this.function.getName());
        if (!(node instanceof IChild)) {
            return this.throwWarning(description);
        }
        IChildProvidable parent = ((IChild)node).getChildContext().getParent();
        if (parent == null) {
            return this.throwWarning(description);
        }
        return Value.valueOf((Object)parent);
    }

    public IValue queryFeature(String resType, String resId, String featureName) {
        boolean result = false;
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
            Collection results = queryEngine.query(configuration, resType, resId, featureName);
            result = CollectionsUtils.getInstancesOf(results.stream().map(IDependencyQueryResult::getValue), Boolean.class).anyMatch(Boolean::booleanValue);
        } else {
            LOGGER.warning("Cannot resolve query due to inactive workbench: (" + resType + ", " + resId + ", " + featureName + ")");
        }
        return Value.valueOf((boolean)result);
    }

    public IValue queryFeatureAdvanced(String resType, String resId, String featureName, boolean defaultGroupOnly, @Nullable String functionalGroup) {
        ArrayList result = "";
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
            Collection results = queryEngine.query(configuration, resType, resId, featureName);
            boolean singleResult = false;
            Stream<Object> stream = results.stream();
            if (functionalGroup != null) {
                stream = stream.filter(r -> r.getConfiguration().getConfigurationName().equals(functionalGroup));
                singleResult = true;
            }
            if (defaultGroupOnly) {
                stream = stream.filter(r -> r.getConfiguration().isCalledFromInit());
                singleResult = true;
            }
            Stream<Object> valuesStream = CollectionsUtils.getInstancesOf(stream.map(IDependencyQueryResult::getValue), Object.class);
            valuesStream = valuesStream.map(v -> {
                ArrayList value = v;
                if (value instanceof Double) {
                    value = new BigRational(new BigDecimal((Double)((Object)value)));
                } else if (value instanceof Frequency) {
                    value = ExpressionFunctions.toHertzFloat((Frequency)value);
                } else if (value instanceof Set) {
                    value = new ArrayList((Set)((Object)value));
                }
                return value;
            });
            if (singleResult) {
                Object first = CollectionsUtils.nullableOptionalGet(valuesStream.findFirst());
                if (first != null) {
                    result = first;
                }
            } else {
                result = new ArrayList(valuesStream.collect(Collectors.toList()));
            }
        } else {
            LOGGER.warning("Cannot resolve query due to inactive workbench: (" + resType + ", " + resId + ", " + featureName + ")");
        }
        return Value.valueOf((Object)result);
    }

    public IValue enumItemsOf(Object enumItems) {
        if (enumItems instanceof ScalarConfig) {
            return Value.valueOf(((ScalarConfig)enumItems).getEnumItems());
        }
        String description = "Could not create enum from argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
        return this.throwWarning(description);
    }

    public IValue addItemToList(List<SetSetting.Item> list, String id, String name, String value, IResolvable expression) {
        if (expression.resolve(this.argContext).getBoolean()) {
            list.add(new SetSetting.Item(id, name, null, value, null, "", ""));
        }
        return Value.valueOf(list);
    }

    public IValue getSetting(Object node, String id) {
        String description = "Could not get setting of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " with ID: " + this.function.getArgument(1).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
        if (!(node instanceof IChild)) {
            return this.throwWarning(description);
        }
        IChild found = ChildProviderHelper.getChild(((IChild)node).getChildContext(), id);
        if (found == null) {
            return this.throwWarning(description);
        }
        return Value.valueOf((Object)found);
    }

    public IValue getCoreId(IChild node) {
        FunctionalGroup functionalGroup = node.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            String description = "Given IChild node " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " has no functional group assigned";
            return this.throwWarning(description);
        }
        return Value.valueOf((String)UtilsText.safeString((String)functionalGroup.getCore()));
    }

    public IValue getPeriphInstanceIndex(String name) {
        String type = this.mcu.getPeripheralType(name);
        long index = 0L;
        IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = this.mcu.getRegistersDb().getPeripherals();
        int n = iRegParentPeripheralAPIArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRegParentPeripheralAPI api = iRegParentPeripheralAPIArray[n2];
            if (api.getName().equals(name)) {
                return Value.valueOf((long)index);
            }
            if (Objects.equals(api.getAlias("type"), type)) {
                ++index;
            }
            ++n2;
        }
        return Value.valueOf((long)-1L);
    }

    public IValue getPeripheralType(String name) {
        String type = this.mcu.getPeripheralType(name);
        if (type == null) {
            String description = "Could not get peripheral type of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return this.throwWarning(description);
        }
        return Value.valueOf((String)type);
    }

    public IValue allDifferent(List<?> array) {
        HashSet set = new HashSet(array);
        return Value.valueOf((set.size() == array.size() ? 1 : 0) != 0);
    }

    public IValue isPeripheralUsed(IChild node, String name) {
        FunctionalGroup functionalGroup = node.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            String description = "The function: " + this.function.getName() + " needs child of functional group as an argument." + " Given node(" + node + ") doesn't have functional group!";
            return this.throwWarning(description);
        }
        return Value.valueOf((boolean)functionalGroup.isPeripheralUsed(name));
    }

    public IValue arrayToEnumItems(List<@NonNull ?> array, IFunction filterExpr, IFunction idSelectExpr, IFunction labelSelectExpr, IFunction valueSelectExpr) {
        ArrayList<SetSetting.Item> enumItems = new ArrayList<SetSetting.Item>();
        for (Object item : array) {
            if (!filterExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            enumItems.add(new SetSetting.Item(idSelectExpr.invokeOn(this.argContext, new Object[]{item}).getString(), labelSelectExpr.invokeOn(this.argContext, new Object[]{item}).getString(), null, valueSelectExpr.invokeOn(this.argContext, new Object[]{item}).getString(), null, "", ""));
        }
        if (enumItems.size() == 0) {
            LOGGER.warning("No enum item was created from argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName());
        }
        return Value.valueOf(enumItems);
    }

    public IValue allMatch(List<@NonNull ?> array, IFunction condExpr) {
        boolean result = true;
        for (Object item : array) {
            result &= condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean();
        }
        return Value.valueOf((boolean)result);
    }

    public IValue anyMatch(List<@NonNull ?> array, IFunction condExpr) {
        for (Object item : array) {
            if (!condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            return Value.valueOf((boolean)true);
        }
        return Value.valueOf((boolean)false);
    }

    public IValue noneMatch(List<@NonNull ?> array, IFunction condExpr) {
        return Value.valueOf((!this.anyMatch(array, condExpr).getBoolean() ? 1 : 0) != 0);
    }

    public IValue filter(List<@NonNull ?> array, IFunction condExpr, boolean recursive) {
        ArrayList newArray = new ArrayList();
        for (Object item : array) {
            List<?> subArray;
            if (condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) {
                newArray.add(item);
            }
            if (!recursive || (subArray = ExpressionFunctions.listAdapter(item)) == null) continue;
            List newSubArray = (List)this.filter(subArray, condExpr, true).getValue();
            newArray.addAll(newSubArray);
        }
        return Value.valueOf(newArray);
    }

    public IValue findFirst(List<@NonNull ?> array, IFunction condExpr) {
        for (Object item : array) {
            if (!condExpr.invokeOn(this.argContext, new Object[]{item}).getBoolean()) continue;
            return Value.valueOf(item);
        }
        String description = "Could not find element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
        return this.throwWarning(description);
    }

    public IValue get(List<?> array, long index) {
        if ((long)array.size() <= index) {
            String description = "Could not get element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return this.throwWarning(description);
        }
        Object obj = array.get((int)index);
        assert (obj != null);
        return Value.valueOf(obj);
    }

    public IValue getFirst(List<?> array) {
        if (array.isEmpty()) {
            String description = "Could not get element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return this.throwWarning(description);
        }
        Object obj = array.get(0);
        assert (obj != null);
        return Value.valueOf(obj);
    }

    public IValue getLast(List<?> array) {
        if (array.isEmpty()) {
            String description = "Could not get element of argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " of the function: " + this.function.getName();
            return this.throwWarning(description);
        }
        Object obj = array.get(array.size() - 1);
        assert (obj != null);
        return Value.valueOf(obj);
    }

    public IValue map(List<@NonNull ?> array, IFunction funcExpr) {
        ArrayList<Object> newArray = new ArrayList<Object>();
        for (Object item : array) {
            newArray.add(funcExpr.invokeOn(this.argContext, new Object[]{item}).getValue());
        }
        return Value.valueOf(newArray);
    }

    public IValue flatMap(List<@NonNull ?> array, IFunction funcExpr) {
        ArrayList newArray = new ArrayList();
        for (Object item : array) {
            List<@NonNull ?> value = ExpressionFunctions.listAdapter(funcExpr.invokeOn(this.argContext, new Object[]{item}).getValue());
            newArray.addAll(value);
        }
        return Value.valueOf(newArray);
    }

    public IValue reduce(List<@NonNull ?> array, Object identity, IFunction funcExpr) {
        Object reducedValue = identity;
        for (Object item : array) {
            reducedValue = funcExpr.invokeOn(this.argContext, new Object[]{reducedValue, item}).getValue();
        }
        return Value.valueOf((Object)reducedValue);
    }

    public IValue searchInArray(List<?> array, IFunction condExpr) {
        int i = 0;
        while (i < array.size()) {
            if (condExpr.invokeOn(this.argContext, new Object[]{array.get(i)}).getBoolean()) {
                return Value.valueOf((long)i);
            }
            ++i;
        }
        return Value.valueOf((long)-1L);
    }

    public IValue countOccurrences(List<?> array, IFunction condExpr, boolean recursive) {
        Object value = this.filter(array, condExpr, recursive).getValue();
        if (value instanceof List) {
            return Value.valueOf((long)((List)value).size());
        }
        return Value.valueOf((long)0L);
    }

    public IValue size(List<?> array) {
        return Value.valueOf((long)array.size());
    }

    public IValue size(String string) {
        return Value.valueOf((long)string.length());
    }

    public IValue toArray(Object ... values) {
        return Value.valueOf(new ArrayList<Object>(Arrays.asList(values)));
    }

    public IValue merge(List<?> ... arrays) {
        ArrayList newList = new ArrayList();
        List<?>[] listArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            List<?> array = listArray[n2];
            newList.addAll(array);
            ++n2;
        }
        return Value.valueOf(newList);
    }

    public IValue createArray() {
        return Value.valueOf(new ArrayList());
    }

    public IValue createArray(BigInteger firstValue, BigInteger stepValue, BigInteger stepCount) {
        if (stepCount.compareTo(BigInteger.ZERO) < 0) {
            String description = "Number of array value increments cannot be negative. Argument value: " + stepCount + " used for the function: " + this.function.getName();
            return this.throwWarning(description);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Value nextValue = Value.valueOf((BigInteger)firstValue);
        Value increment = Value.valueOf((BigInteger)stepValue);
        long i = 0L;
        while (i <= stepCount.longValue()) {
            result.add(nextValue.getValue());
            nextValue = (Value)nextValue.add((IValue)increment);
            ++i;
        }
        return Value.valueOf(result);
    }

    public IValue isCoreMaster(String coreId) {
        String masterCoreId = this.childContext.getProfile().getMcu().getMasterCore();
        return Value.valueOf((boolean)masterCoreId.equals(coreId));
    }

    public IValue getEnumItemId(IChild node) {
        if (node instanceof ScalarConfig && ((ScalarConfig)node).getType() == ScalarConfig.Type.ENUM) {
            return Value.valueOf((String)this.getEnumItemId((ScalarConfig)node));
        }
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return this.throwWarning(description);
    }

    public IValue getEnumItemLabel(IChild node) {
        if (node instanceof ScalarConfig && ((ScalarConfig)node).getType() == ScalarConfig.Type.ENUM) {
            return Value.valueOf((String)this.getEnumItemLabel((ScalarConfig)node));
        }
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return this.throwWarning(description);
    }

    public IValue getEnumItemValue(IChild node) {
        if (node instanceof ScalarConfig && ((ScalarConfig)node).getType() == ScalarConfig.Type.ENUM) {
            return Value.valueOf((String)this.getEnumItemValue((ScalarConfig)node));
        }
        String description = "Function does not accept argument: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return this.throwWarning(description);
    }

    public IValue getSetItemValue(IChild node) {
        if (node instanceof SetConfig.SetPresence) {
            return Value.valueOf((String)((SetConfig.SetPresence)node).getItem().getValue());
        }
        String description = "Function: " + this.function.getName() + " undefined for: " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function);
        return this.throwWarning(description);
    }

    public IValue findDuplicates(List<@NonNull ?> array, IFunction keyExpr) {
        ArrayList duplicates = new ArrayList();
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (Object item : array) {
            Object key = keyExpr.invokeOn(this.argContext, new Object[]{item}).getValue();
            List values = map.getOrDefault(key, new ArrayList());
            values.add(item);
            map.put(key, values);
        }
        for (List dupes : map.values()) {
            if (dupes.size() <= 1) continue;
            duplicates.addAll(dupes);
        }
        return Value.valueOf(duplicates);
    }

    public IValue formatMessage(String message, Object ... parameters) {
        return Value.valueOf((String)UtilsText.safeString((String)MessageFormat.format(message, parameters)));
    }

    public IValue replaceText(String original, String textToReplace, String replacement) {
        return Value.valueOf((String)UtilsText.safeString((String)original.replaceAll(Pattern.quote(textToReplace), Matcher.quoteReplacement(replacement))));
    }

    public boolean paramExists(String paramName) {
        String setting = "$param." + paramName;
        try {
            this.argContext.getSettingValue(setting);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IValue join(List<?> list, String delimiter) {
        return Value.valueOf((String)UtilsText.join(list, (String)delimiter));
    }

    public IValue nodeExists(@Nullable IChild node, String id) {
        return Value.valueOf((ChildProviderHelper.getChild(node == null ? this.childContext : node.getChildContext(), id) != null ? 1 : 0) != 0);
    }

    public IValue frequencyToString(BigRational frequencyInHertz) {
        Frequency frequency = Frequency.parseRational((BigRational)frequencyInHertz);
        return Value.valueOf((String)ExpressionFunctions.frequencyToString(frequency));
    }

    public IValue timeToString(BigRational timeInMicroSeconds) {
        TimePeriod time = new TimePeriod(timeInMicroSeconds, TimeUnit.MICRO_SECOND);
        time = TimeCalculator.normalize((TimePeriod)time);
        return Value.valueOf((String)time.toString());
    }

    public IValue getPeripherals(String type) {
        return Value.valueOf(this.mcu.getPeripherals(type));
    }

    public IValue getPeripheralClock(String peripheral, String clockRole) {
        String result = this.getClockFrequenciesFromClocks(peripheral, clockRole);
        if (result == null) {
            result = this.getClockFrequencyStringFromPeripheralSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = this.getPeripheralSignalNameFromPinSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = this.getDescriptionFromNoSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = "";
            LOGGER.severe("No signal defined for peripheral: " + peripheral + " and clock role: " + clockRole);
        }
        return Value.valueOf((String)result);
    }

    public IValue getPeripheralClockDescription(String peripheral, String clockRole) {
        PeripheralComponentInput signal;
        String result = "";
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (signal = peripheralComponent.findSignal(clockRole)) != null) {
            result = signal.getDescription();
        }
        return Value.valueOf((String)result);
    }

    public IValue getPeripheralClockType(String peripheral, String clockRole) {
        String result = TYPE_NO_SIGNAL;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            PeripheralComponentInput signal = peripheralComponent.findSignal(clockRole);
            if (signal instanceof InputSignal) {
                result = TYPE_INPUT_SIGNAL;
            } else if (signal instanceof PeripheralSignal) {
                result = TYPE_PERIPHERAL_SIGNAL;
            } else if (signal instanceof PinSignal) {
                result = TYPE_PIN_SIGNAL;
            }
        }
        return Value.valueOf((String)result);
    }

    public IValue getPeripheralClockFrequency(String peripheral, String clockRole, String functionalGroup) {
        Frequency result = this.getClockFrequencyFromClocks(peripheral, clockRole, functionalGroup);
        if (result == null) {
            result = this.getClockFrequencyFromPeripheralSignal(peripheral, clockRole);
        }
        if (result == null) {
            result = Frequency.ZERO;
            if (this.getPeripheralSignalNameFromPinSignal(peripheral, clockRole) == null && this.getDescriptionFromNoSignal(peripheral, clockRole) == null) {
                LOGGER.severe("No signal defined for peripheral: " + peripheral + " and clock role: " + clockRole);
            }
        }
        return Value.valueOf((long)ExpressionFunctions.toHertz(result));
    }

    public IValue peripheralClockExists(String peripheral, String clockRole) {
        boolean result = false;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            result = peripheralComponent.findSignal(clockRole) != null;
        }
        return Value.valueOf((boolean)result);
    }

    public IValue getClockFunctionalGroups() {
        LinkedList namesWithFinalOrder = new LinkedList();
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
            Collection queryResults = queryEngine.query(configuration, "Tool", "Clocks", "funcGroupNames");
            Set namesSet = (Set)CollectionsUtils.nullableOptionalGet(CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()), Set.class).filter(set -> set.iterator().hasNext() && set.iterator().next() instanceof String).findFirst());
            List names = new ArrayList();
            if (namesSet != null) {
                names = (List)CollectionsUtils.getInstancesOf((Collection)namesSet, String.class).collect(CollectorsUtils.toList());
            }
            List initFGNames = new ArrayList();
            queryResults = queryEngine.query(configuration, "Tool", "Clocks", "initGroupNames");
            namesSet = (Set)CollectionsUtils.nullableOptionalGet(CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()), Set.class).filter(set -> set.iterator().hasNext() && set.iterator().next() instanceof String).findFirst());
            if (namesSet != null) {
                initFGNames = (List)CollectionsUtils.getInstancesOf((Collection)namesSet, String.class).collect(CollectorsUtils.toList());
            }
            namesWithFinalOrder.addAll(initFGNames);
            names.removeAll(initFGNames);
            namesWithFinalOrder.addAll(names);
        }
        return Value.valueOf(namesWithFinalOrder);
    }

    public IValue hasPeripheralClockSignal(String peripheral, String clockRole) {
        return Value.valueOf((this.getPeripheralClockSignalName(peripheral, clockRole) != null ? 1 : 0) != 0);
    }

    public IValue getPeripheralClockSignal(String peripheral, String clockRole) {
        String result = this.getPeripheralClockSignalName(peripheral, clockRole);
        if (result == null) {
            String description = "No signal defined for peripheral: " + peripheral + " and clock role: " + clockRole;
            return this.throwWarning(description);
        }
        return Value.valueOf((String)result);
    }

    public IValue getSettingByKey(ArrayConfig array, String key) {
        ISettingConfig result = array.getSettingByKey(key, this.argContext);
        if (result == null) {
            String description = "Key: " + key + " does not exist in array with id:" + array.getId();
            return this.throwWarning(description);
        }
        return Value.valueOf((Object)result);
    }

    public IValue settingWithKeyExists(ArrayConfig array, String key) {
        return Value.valueOf((boolean)array.settingWithKeyExists(key, this.argContext));
    }

    public IValue getSettingKey(ISettingConfig setting) {
        ArrayConfig array;
        IChildProvidable parent = setting.getChildContext().getParent();
        ArrayConfig arrayConfig = array = parent == null || !(parent instanceof ArrayConfig) ? null : (ArrayConfig)parent;
        if (array == null || !array.getChildren().contains(setting)) {
            String description = "Setting: " + setting + " is not a part of the array: " + array;
            return this.throwWarning(description);
        }
        return Value.valueOf((String)UtilsText.safeString((String)array.getSettingKey(setting, this.argContext)));
    }

    public IValue toHertz(String input) {
        return ExpressionFunctions.getBestFittingTypeOfValue(this.toHertzFloat(input).getBigInteger());
    }

    public IValue toHertzFloat(String input) {
        if (!input.toLowerCase().endsWith("hz")) {
            input = String.valueOf(input) + "Hz";
        }
        Frequency frequency = Frequency.parseNonNull((String)input);
        return Value.valueOf((BigRational)ExpressionFunctions.toHertzFloat(frequency));
    }

    public IValue isPeripheralAvailable(String peripheralName, String coreId) {
        return Value.valueOf((boolean)this.mcu.isPeripheralAvailableForCore(coreId, peripheralName));
    }

    public IValue getFreq(String value, String desiredUnits, @Nullable String defaultUnits) {
        return ExpressionFunctions.getBestFittingTypeOfValue(this.getFreqFloat(value, desiredUnits, defaultUnits).getBigInteger());
    }

    public IValue getFreqFloat(String value, String desiredUnits, @Nullable String defaultUnits) {
        Frequency frequency = ExpressionFunctions.getFrequencyObject(value, defaultUnits == null ? UtilsText.safeString((String)FrequencyUnit.HERTZ.toString()) : defaultUnits);
        FrequencyUnit desiredUnitObject = FrequencyUnit.parse((String)desiredUnits);
        if (desiredUnitObject == null) {
            String description = "The desired units: `" + desiredUnits + "` are not valid";
            return this.throwWarning(description);
        }
        frequency = FrequencyCalculator.toUnit((Frequency)frequency, (FrequencyUnit)desiredUnitObject);
        return Value.valueOf((BigRational)frequency.getValue());
    }

    public IValue getTime(String value, String desiredUnits, @Nullable String defaultUnits) {
        return ExpressionFunctions.getBestFittingTypeOfValue(this.getTimeFloat(value, desiredUnits, defaultUnits).getBigInteger());
    }

    public IValue getTimeFloat(String value, String desiredUnits, @Nullable String defaultUnits) {
        TimePeriod timePeriod;
        String defaultUnitNonNull = defaultUnits == null ? TimeUnit.MICRO_SECOND.toString() : defaultUnits;
        try {
            Frequency frequency = ExpressionFunctions.getFrequencyObject(value, defaultUnitNonNull);
            frequency = FrequencyCalculator.toUnit((Frequency)frequency, (FrequencyUnit)FrequencyUnit.HERTZ);
            BigRational rational = frequency.getValue().swap();
            timePeriod = new TimePeriod(rational, TimeUnit.SECOND);
        }
        catch (Exception exception) {
            timePeriod = TimePeriod.parse((String)AbstractUnit.prepareForParsing((String)value, (String)defaultUnitNonNull));
        }
        if (timePeriod == null) {
            String description = "Time period is not valid in function " + this.function.getName();
            return this.throwWarning(description);
        }
        TimeUnit wantedUnitObject = TimeUnit.parse((String)desiredUnits);
        if (wantedUnitObject == null) {
            String description = "The desired units are not valid in function " + this.function.getName();
            return this.throwWarning(description);
        }
        timePeriod = TimeCalculator.toUnit((TimePeriod)timePeriod, (TimeUnit)wantedUnitObject);
        return Value.valueOf((BigRational)timePeriod.getValue());
    }

    public IValue isFreq(String value) {
        return Value.valueOf((boolean)Frequency.isFrequency((String)value));
    }

    public IValue isTime(String value) {
        return Value.valueOf((boolean)TimePeriod.isTime((String)value));
    }

    public IValue getSubType(IChild config) {
        String type = "";
        if (!(config instanceof ISettingConfig)) {
            String description = "Function getSubType cannot work with " + config.getTypeName();
            return this.throwWarning(description);
        }
        ISetting setting = ((ISettingConfig)config).getModelData();
        if (setting instanceof ArraySetting) {
            type = ((ArraySetting)setting).getReferenceID();
        }
        if (setting instanceof IntegerSetting) {
            type = ((IntegerSetting)setting).getType().toString();
        }
        if (setting instanceof FloatSetting) {
            type = ((FloatSetting)setting).getType().toString();
        }
        return Value.valueOf((String)type);
    }

    public IValue getComponentInstances(IChild node, String componentTypeId) {
        FunctionalGroup functionalGroup = node.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            String description = "Given IChild node " + this.function.getArgument(0).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)this.function) + " has no functional group assigned";
            return this.throwWarning(description);
        }
        return Value.valueOf(functionalGroup.getInstancesOfType(componentTypeId));
    }

    public IValue getSdkBasePointer(IChild node) {
        String peripheralName = ExpressionFunctions.getPeripheral(node.getChildContext());
        if (peripheralName == null) {
            LOGGER.warning("Trying to get sdk base pointer on Setting with id: \"" + node.getId() + "\". Peripheral for component instance config is not defined");
            return Value.valueOf((String)"");
        }
        IRegParentPeripheralAPI peripheral = this.mcu.getRegistersDb().getPeripheral(peripheralName);
        if (peripheral == null) {
            LOGGER.warning("Trying to get sdk base pointer on Setting with id: \"" + node.getId() + "\". Peripheral with name \"" + peripheralName + "\" was not found in register DB");
            return Value.valueOf((String)"");
        }
        String alias = peripheral.getAlias("sdk_base_pointer");
        if (alias == null) {
            LOGGER.warning("Trying to get sdk base pointer on Setting with id: \"" + node.getId() + "\". Peripheral with name \"" + peripheralName + "\" does not have alias defined");
            return Value.valueOf((String)peripheralName);
        }
        return Value.valueOf((String)alias);
    }

    private static Frequency getFrequencyObject(String value, String defaultUnit) {
        String valueWithUnit = AbstractUnit.prepareForParsing((String)value, (String)defaultUnit);
        Frequency frequency = AbstractUnit.parseIntoFrequency((String)valueWithUnit);
        if (frequency == null) {
            String description = "Frequency: `" + value + "` cannot be parsed";
            throw new PeripheralExpressionException(description, ExpressionFunctions.class);
        }
        return frequency;
    }

    public static String getFnGroupPrefixHelper(IChild node) {
        FunctionalGroup funcGroup = node.getChildContext().getFunctionalGroup();
        return funcGroup == null ? "" : funcGroup.getIdPrefix();
    }

    public static boolean isFnGroupDefaultInitHelper(IChild node) {
        FunctionalGroup funcGroup = node.getChildContext().getFunctionalGroup();
        return funcGroup == null ? false : funcGroup.isCalledFromDefaultInit();
    }

    @Deprecated
    public static boolean isCalledFromDefaultInit(FunctionalGroup functionalGroup) {
        return functionalGroup.isCalledFromDefaultInit();
    }

    public static @Nullable List<?> listAdapter(Object object) {
        if (object instanceof List) {
            return (List)object;
        }
        if (object instanceof IChildProvidable) {
            return ((IChildProvidable)object).getChildren();
        }
        return null;
    }

    public static List<?> listAdapter(FunctionInvocation function, int argIndex, IContext argContext) throws PeripheralExpressionException {
        Object object = function.getArgument(argIndex).resolve(argContext).getValue();
        List<?> result = ExpressionFunctions.listAdapter(object);
        if (result == null) {
            String description = "Could not create a list from argument: " + function.getArgument(argIndex).formatOutput(FormatOptions.DEFAULT, (IExpressionPrintable)function) + " of the function: " + function.getName();
            throw new PeripheralExpressionException(description, ExpressionFunctions.class);
        }
        return result;
    }

    public static @Nullable String getPeripheral(ChildContext childContext) {
        ComponentInstanceConfig componentInstance = childContext.getComponentInstanceConfig();
        return componentInstance == null ? null : componentInstance.getPeripheral();
    }

    public static String getModeId(ChildContext childContext) {
        ComponentInstanceConfig componentInstanceConfig = childContext.getComponentInstanceConfig();
        String modeId = componentInstanceConfig == null ? null : componentInstanceConfig.getMode().getId();
        return UtilsText.safeString((String)modeId);
    }

    public static String getFunctionalGroupName(ChildContext childContext) {
        FunctionalGroup funcGroup = childContext.getFunctionalGroup();
        return funcGroup == null ? "" : funcGroup.getName();
    }

    private static String trimLeft(String s) {
        return LTRIM.matcher(s).replaceAll("");
    }

    private static String padLeft(String s, long level) {
        assert (0L != PAD_LEVEL_SIZE);
        long totalLen = Math.addExact((long)s.length(), Math.multiplyExact(PAD_LEVEL_SIZE, level));
        if (0L == totalLen) {
            return s;
        }
        return UtilsText.safeString((String)String.format("%1$" + totalLen + "s", s));
    }

    private static @Nullable PinsSignalsProvider getPinsSignalProvider(String peripheral) {
        if (Platform.isRunning()) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            List<RoutableSignal> routableSignals = ExpressionFunctions.getRoutableSignals(configuration, peripheral);
            HashMap<String, List<RoutedPin>> routedPins = ExpressionFunctions.getRoutedPins(configuration, routableSignals);
            PinsSignalsProvider pinsSignalsProvider = new PinsSignalsProvider(routableSignals, routedPins);
            return pinsSignalsProvider;
        }
        return null;
    }

    private static HashMap<String, List<RoutedPin>> getRoutedPins(ISharedConfiguration configuration, List<RoutableSignal> routableSignals) {
        HashMap<String, List<RoutedPin>> routedPins = new HashMap<String, List<RoutedPin>>();
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        for (RoutableSignal routableSignal : routableSignals) {
            String resourceId = String.valueOf(routableSignal.getPeripheral()) + "." + routableSignal.getId();
            Collection queryResults = queryEngine.query(configuration, "PinSignal", resourceId, "routedToPins");
            LinkedHashSet routedPinsForSignal = CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()).filter(y -> y instanceof List).map(y -> (List)y).flatMap(z -> z.stream()), RoutedPin.class).filter(s -> s.getSignal().equals(resourceId)).collect(Collectors.toCollection(LinkedHashSet::new));
            routedPins.put(routableSignal.getId(), new ArrayList(routedPinsForSignal));
        }
        return routedPins;
    }

    private static List<RoutableSignal> getRoutableSignals(ISharedConfiguration configuration, String peripheral) {
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        Collection queryResults = queryEngine.query(configuration, "Peripheral", peripheral, "routableSignals");
        List routableSignals = (List)CollectionsUtils.getInstancesOf(queryResults.stream().map(x -> x.getValue()).filter(y -> y instanceof List).map(y -> (List)y).flatMap(z -> z.stream()), RoutableSignal.class).filter(s -> s.getPeripheral().equals(peripheral)).collect(CollectorsUtils.toList());
        return routableSignals;
    }

    private static boolean isCIdentifierHelper(String s) {
        return s.matches("[A-Za-z_][0-9A-Za-z_]*");
    }

    public String getEnumItemId(ScalarConfig enumConfig) {
        SetSetting.Item item = this.getSelectedEnumItem(enumConfig);
        if (item != null) {
            return item.getId();
        }
        return "";
    }

    public String getEnumItemLabel(ScalarConfig enumConfig) {
        SetSetting.Item item = this.getSelectedEnumItem(enumConfig);
        if (item != null) {
            return item.getUIName(this.argContext);
        }
        return "";
    }

    public String getEnumItemValue(ScalarConfig enumConfig) {
        SetSetting.Item item = this.getSelectedEnumItem(enumConfig);
        if (item != null) {
            return item.getValue();
        }
        return "";
    }

    public IValue sort(List<?> array, IFunction comparatorExpr) {
        ArrayList newArray = new ArrayList(array);
        class SortComparator
        implements Comparator<Object> {
            private final /* synthetic */ IFunction val$comparatorExpr;

            SortComparator(IFunction iFunction) {
                this.val$comparatorExpr = iFunction;
            }

            @Override
            public int compare(Object a, Object b) {
                return (int)this.val$comparatorExpr.invokeOn(ExpressionFunctions.this.argContext, new Object[]{a, b}).getLong();
            }
        }
        newArray.sort(new SortComparator(comparatorExpr));
        return Value.valueOf(newArray);
    }

    public IValue stringCompare(String first, String second) {
        int difference = ComparatorHelpers.compareSignalNames((String)first, (String)second);
        return Value.valueOf((long)difference);
    }

    private @Nullable SetSetting.Item getSelectedEnumItem(ScalarConfig enumConfig) {
        DynamicEnumSetting dynamicEnumSetting;
        if (enumConfig.getType() != ScalarConfig.Type.ENUM) {
            String description = MessageFormat.format("Invalid input type: {0} for this function", new Object[]{enumConfig.getType()});
            this.throwWarning(description);
        }
        String itemName = (String)enumConfig.getValue();
        if (enumConfig.setting instanceof DynamicEnumSetting && (dynamicEnumSetting = (DynamicEnumSetting)enumConfig.setting).getCustomValueSupport() != null && (itemName = enumConfig.getStringValue()).startsWith("custom:")) {
            itemName = "custom";
        }
        String itemId = itemName;
        SetSetting.Item item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(enumConfig.getEnumItems().stream().filter(x -> x.getId().equals(itemId)).findFirst());
        return item;
    }

    private static String frequencyToString(Frequency frequency) {
        String result = "Inactive";
        if (Frequency.ZERO.compareTo(frequency) < 0) {
            result = frequency.toString();
        }
        return result;
    }

    private @Nullable Frequency getClockFrequencyFromClocks(String peripheral, String clockRole, String functionalGroup) {
        InputSignal inputSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (inputSignal = peripheralComponent.findInputSignal(clockRole)) != null) {
            String clockSignalId = inputSignal.getSignal();
            return ExpressionFunctions.getClockFrequenciesFromClocks(clockSignalId).get(functionalGroup);
        }
        return null;
    }

    private static Map<String, Frequency> getClockFrequenciesFromClocks(String clockSignalId) {
        LinkedHashMap<String, Frequency> result = new LinkedHashMap<String, Frequency>();
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        Collection queryResults = queryEngine.query(configuration, "ClockOutput", clockSignalId, "frequency");
        for (IDependencyQueryResult queryResult : queryResults) {
            Object resultValue = queryResult.getValue();
            if (!(resultValue instanceof Frequency)) continue;
            String configurationName = queryResult.getConfiguration().getConfigurationName();
            result.put(configurationName, (Frequency)resultValue);
        }
        return result;
    }

    private @Nullable Frequency getClockFrequencyFromPeripheralSignal(String peripheral, String clockRole) {
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            PeripheralSignal peripheralSignal = peripheralComponent.findPeripheralSignal(clockRole);
            if (peripheralSignal != null) {
                return Frequency.parse((String)peripheralSignal.getFrequency());
            }
            return Frequency.ZERO;
        }
        return null;
    }

    private @Nullable String getClockFrequenciesFromClocks(String peripheral, String clockRole) {
        InputSignal inputSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (inputSignal = peripheralComponent.findInputSignal(clockRole)) != null) {
            String frequenciesString;
            String clockSignalId = inputSignal.getSignal();
            ClockSignal clockSignal = this.mcu.getClockConsumers().findClockSignalById(clockSignalId);
            String clockSignalName = clockSignalId;
            if (clockSignal != null) {
                clockSignalName = clockSignal.getName();
            }
            String result = (frequenciesString = ExpressionFunctions.getClockFrequenciesFromClocks(clockSignalId).entrySet().stream().map(x -> MessageFormat.format("{0}: {1}", x.getKey(), ExpressionFunctions.frequencyToString((Frequency)x.getValue()))).collect(Collectors.joining(", "))).isEmpty() ? clockSignalName : String.valueOf(clockSignalName) + " - " + frequenciesString;
            return result;
        }
        return null;
    }

    private @Nullable String getClockFrequencyStringFromPeripheralSignal(String peripheral, String clockRole) {
        PeripheralSignal peripheralSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (peripheralSignal = peripheralComponent.findPeripheralSignal(clockRole)) != null) {
            String frequency = peripheralSignal.getFrequency();
            return String.valueOf(peripheralSignal.getDescription()) + (frequency.isEmpty() ? "" : " - " + frequency);
        }
        return null;
    }

    private @Nullable String getPeripheralSignalNameFromPinSignal(String peripheral, String clockRole) {
        PinSignal pinSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (pinSignal = peripheralComponent.findPinSignal(clockRole)) != null) {
            PinsToolReference pinsRef = pinSignal.getPinsRef();
            return ExpressionFunctions.createPinSignal(pinsRef.getSignalID(), pinsRef.getChannelID());
        }
        return null;
    }

    private @Nullable String getDescriptionFromNoSignal(String peripheral, String clockRole) {
        NoSignal noSignal;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null && (noSignal = peripheralComponent.findNoSignal(clockRole)) != null) {
            return String.valueOf(noSignal.getDescription()) + " - not connected";
        }
        return null;
    }

    private @Nullable String getPeripheralClockSignalName(String peripheral, String clockRole) {
        String result = null;
        PeripheralComponent peripheralComponent = this.mcu.getClockConsumers().findPeriphComponentById(peripheral);
        if (peripheralComponent != null) {
            PeripheralComponentInput signal = peripheralComponent.findSignal(clockRole);
            if (signal instanceof InputSignal) {
                result = ((InputSignal)signal).getSignal();
            } else if (signal instanceof PinSignal) {
                PinSignal pinSignal = (PinSignal)signal;
                result = ExpressionFunctions.createPinSignal(pinSignal.getSignal(), pinSignal.getChannel());
            }
        }
        return result;
    }

    private static String createPinSignal(String signal, String channel) {
        return String.valueOf(signal) + (channel.isEmpty() ? "" : "." + channel);
    }

    private static long toHertz(Frequency frequency) {
        BigDecimal bigDecimal = ExpressionFunctions.toHertzFloat(frequency).toBigDecimal();
        return bigDecimal.longValue();
    }

    private static BigRational toHertzFloat(Frequency frequency) {
        Frequency hertz = FrequencyCalculator.toHertz((Frequency)frequency);
        return hertz.getValue();
    }

    public IValue execScript(IChild child, String scriptPath) {
        File scriptFile = new File(scriptPath);
        Object result = null;
        if (!scriptFile.isAbsolute()) {
            ComponentConfig componentConfig = child.getChildContext().getComponentConfig();
            if (componentConfig != null) {
                Path currentComponentPath = componentConfig.getConfigCompTypeId().getFileLocation();
                scriptFile = currentComponentPath.resolve(scriptPath).normalize().toFile();
            } else {
                String description = "Can't resolve path to javascript in " + this.function.getName();
                return this.throwWarning(description);
            }
        }
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute(SCRIPT_CONTEXT_ATTRIBUTE, child, 100);
        try {
            result = JavaScriptHelper.eval((File)scriptFile, (ScriptContext)simpleScriptContext);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        if (result == null) {
            String description = "Script result value is null in " + this.function.getName();
            return this.throwWarning(description);
        }
        return Value.valueOf((Object)result);
    }
}

