/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processor.properties.PackageProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.config.ArrayConfig;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ExpressionFunctions;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.PeripheralExpressionException;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.FunctionDef;
import com.nxp.swtools.periphs.model.data.UserFunctions;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class ExpressionContext
implements IContext {
    private static final String FUNCTION_REQUIRES_LAMBDA = "Function requires lambda function format";
    private static final Logger LOGGER = LogManager.getLogger(ExpressionContext.class);
    public final ChildContext childContext;
    private final IMcu mcu;
    private ExpressionException exception = new PeripheralExpressionException("Something unspecified went wrong", ExpressionContext.class);
    private Set<Integer> invalidArguments = new HashSet<Integer>();

    public ExpressionContext(ChildContext childContext, IMcu mcu) {
        this.childContext = childContext;
        this.mcu = mcu;
    }

    public long getBitFieldValue(String registerName, String bitFieldName) {
        throw new UnsupportedOperationException("Bit-fields not supported");
    }

    public Object getSettingValue(String settingName) {
        Object propertyValue = PackageProperties.getProperty((String)settingName, (IMcuIdentification)this.mcu.getMcuIdentification());
        if (propertyValue != null) {
            return propertyValue;
        }
        IChild child = ChildProviderHelper.getChild(this.childContext, settingName);
        if (child != null) {
            return child;
        }
        throw new IllegalArgumentException("Value of: " + settingName + " not found");
    }

    public int getBitFiledWidth(String registerName, String bitFieldName) {
        throw new UnsupportedOperationException("Bit-fields not supported");
    }

    public String getBitFieldId(String registerName, String bitFieldName) {
        throw new UnsupportedOperationException("Bit-fields not supported");
    }

    public String getSettingId(String settingName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private @Nullable ConfigurationComponent determineFunctionComponent(FunctionInvocation function) {
        ConfigurationComponent currentComp;
        String compType = function.getLocation();
        ComponentConfig config = this.childContext.getComponentConfig();
        ConfigurationComponent configurationComponent = currentComp = config != null ? config.getComponent() : null;
        if (compType.isEmpty()) {
            return currentComp;
        }
        assert (currentComp != null) : "A function can only be resolved inside a component";
        if (compType.equalsIgnoreCase(currentComp.getId())) {
            return currentComp;
        }
        List<ConfigurationComponentTypeId> typeIds = this.mcu.getAvailableComponents().getComponentTypeIdsByType(compType);
        if (typeIds == null) {
            throw new IllegalArgumentException("Unknown function: " + function.getName() + ", at location: " + compType);
        }
        assert (typeIds.size() == 1) : "There can be only one component of the given type";
        ConfigurationComponent result = typeIds.get(0).getConfigurationComponent();
        if (SWToolsProperties.isVerificationOn() && !result.getComponents().isEmpty()) {
            LOGGER.severe("Function " + function.getName() + ", referencing non-global component: " + compType + "cannot be resolved for: " + currentComp);
        }
        return result;
    }

    private static @Nullable FunctionDef findFunction(FunctionInvocation func, IContext argContext, @Nullable UserFunctions userFuncs) {
        if (userFuncs != null) {
            for (FunctionDef def : userFuncs.getFunctionDefs()) {
                Expression funcBody = def.getTextExpr();
                if (funcBody != null && func.getArgNum() != funcBody.resolve(argContext).getFunctionReference().getArgNum() || !def.getId().equals(func.getName())) continue;
                return def;
            }
        }
        return null;
    }

    public IValue resolveFunction(FunctionInvocation function, IContext argContext) {
        FunctionDef def;
        ConfigurationComponent funcComp = this.determineFunctionComponent(function);
        if (funcComp != null && (def = ExpressionContext.findFunction(function, argContext, funcComp.getUserFunctions())) != null) {
            IFunction functionReference;
            Expression expression = def.getTextExpr();
            if (expression == null) {
                throw new IllegalStateException("Expression with code: " + def.getText() + " cannot be parsed.");
            }
            Object[] resolvedArgs = new Object[function.getArgNum()];
            int i = 0;
            while (i < resolvedArgs.length) {
                resolvedArgs[i] = function.getArgument(i).resolve(argContext).getValue();
                ++i;
            }
            try {
                functionReference = expression.resolve((IContext)this).getFunctionReference();
            }
            catch (ExpressionException e) {
                LOGGER.severe(FUNCTION_REQUIRES_LAMBDA);
                throw e;
            }
            return functionReference.invokeOn(argContext, resolvedArgs);
        }
        ExpressionFunctions expressionFunction = new ExpressionFunctions(function, argContext, this.childContext, this.mcu);
        try {
            switch (function.getName()) {
                case "featureDefined": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String feature = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.featureDefined(feature);
                }
                case "getFeature": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String feature = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.getFeature(feature);
                }
                case "hasOption": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild settingConfig = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String optionName = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.hasOption(settingConfig, optionName);
                }
                case "getOptionValue": 
                case "optionValue": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild settingConfig = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String optionName = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getOptionValue(settingConfig, optionName);
                }
                case "value": 
                case "getValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.value(node);
                }
                case "getDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getDescription(node);
                }
                case "getLabel": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.getLabel(node);
                }
                case "getValueDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getValueDescription(child);
                }
                case "getID": 
                case "getId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object node = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.getID(node);
                }
                case "getPeripheral": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getPeripheral(child);
                }
                case "getMode": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getMode(child);
                }
                case "getFnGroupName": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getFnGroupName(child);
                }
                case "getFnGroupPrefix": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getFnGroupPrefix(child);
                }
                case "isCalledFromDefaultInit": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.isCalledFromDefaultInit(child);
                }
                case "getType": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getType(child);
                }
                case "getCValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getCValue(child);
                }
                case "isAvailable": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object resolvedArg = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.isAvailable(resolvedArg);
                }
                case "isEnabled": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object resolvedArg = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.isEnabled(resolvedArg);
                }
                case "isCIdentifier": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String name = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.isCIdentifier(name);
                }
                case "length": 
                case "getSize": 
                case "size": 
                case "getLength": {
                    IValue resultSize;
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IValue value = function.getArgument(0).resolve(argContext);
                    if (value.getType().equals((Object)IValue.Type.STRING)) {
                        resultSize = expressionFunction.size(value.getString());
                    } else {
                        List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                        resultSize = expressionFunction.size(array);
                    }
                    return resultSize;
                }
                case "leftPadding": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    long level = function.getArgument(1).resolve(argContext).getLong();
                    return expressionFunction.leftPadding(text, level);
                }
                case "toLowerCase": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.toLowerCase(text);
                }
                case "toUpperCase": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.toUpperCase(text);
                }
                case "getPeripheralSignals": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.getPeripheralSignals(peripheral);
                }
                case "extractSignalID": 
                case "extractSignalId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String signal = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.extractSignalId(signal);
                }
                case "extractChannelID": 
                case "extractChannelId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String channel = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.extractChannelId(channel);
                }
                case "regexSubstr": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    String regex = function.getArgument(1).resolve(argContext).getString();
                    int groupIndex = (int)function.getArgument(2).resolve(argContext).getLong();
                    return expressionFunction.regexSubstr(text, regex, groupIndex);
                }
                case "regexMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    String regex = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.regexMatch(text, regex);
                }
                case "contains": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String text = function.getArgument(0).resolve(argContext).getString();
                    String searchFor = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.contains(text, searchFor);
                }
                case "queryFeature": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String resType = function.getArgument(0).resolve(argContext).getString();
                    String resId = function.getArgument(1).resolve(argContext).getString();
                    String featureName = function.getArgument(2).resolve(argContext).getString();
                    return expressionFunction.queryFeature(resType, resId, featureName);
                }
                case "queryFeatureAdvanced": {
                    ExpressionContext.checkNumberOfArgs(function, 3, 5);
                    String resType = function.getArgument(0).resolve(argContext).getString();
                    String resId = function.getArgument(1).resolve(argContext).getString();
                    String featureName = function.getArgument(2).resolve(argContext).getString();
                    boolean defaultFuncGroup = false;
                    String functionalGroup = null;
                    if (function.getArgNum() > 3) {
                        defaultFuncGroup = function.getArgument(3).resolve(argContext).getBoolean();
                    }
                    if (function.getArgNum() > 4) {
                        functionalGroup = function.getArgument(4).resolve(argContext).getString();
                    }
                    return expressionFunction.queryFeatureAdvanced(resType, resId, featureName, defaultFuncGroup, functionalGroup);
                }
                case "filter": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    boolean recursive = function.getArgNum() == 2 ? false : function.getArgument(2).resolve(argContext).getBoolean();
                    return expressionFunction.filter(array, condExpr, recursive);
                }
                case "enumItemsOf": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object enumConfig = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.enumItemsOf(enumConfig);
                }
                case "getResource": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String tableId = function.getArgument(0).resolve(argContext).getString();
                    String definitionId = function.getArgument(1).resolve(argContext).getString();
                    if (function.getArgNum() == 2) {
                        return expressionFunction.getResource(tableId, definitionId);
                    }
                    String component = function.getArgument(2).resolve(argContext).getString();
                    return expressionFunction.getResource(tableId, definitionId, component);
                }
                case "arrayToEnumItems": {
                    ExpressionContext.checkNumberOfArgs(function, 5);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction filterExpr = this.getLambdaFunction(function, argContext, 1);
                    IFunction idSelectExpr = this.getLambdaFunction(function, argContext, 2);
                    IFunction labelSelectExpr = this.getLambdaFunction(function, argContext, 3);
                    IFunction valueSelectExpr = this.getLambdaFunction(function, argContext, 4);
                    if (filterExpr == null || idSelectExpr == null || labelSelectExpr == null || valueSelectExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.arrayToEnumItems(array, filterExpr, idSelectExpr, labelSelectExpr, valueSelectExpr);
                }
                case "searchInArray": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.searchInArray(array, condExpr);
                }
                case "getParent": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object child = function.getArgument(0).resolve(argContext).getValue();
                    return expressionFunction.getParent(child);
                }
                case "getSetting": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    Object child = function.getArgument(0).resolve(argContext).getValue();
                    String id = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getSetting(child, id);
                }
                case "getCoreID": 
                case "getCoreId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getCoreId(child);
                }
                case "getPeriphInstanceIndex": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String name = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.getPeriphInstanceIndex(name);
                }
                case "getPeripheralType": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String name = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.getPeripheralType(name);
                }
                case "allDifferent": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    return expressionFunction.allDifferent(array);
                }
                case "forEachChildTrue": 
                case "allMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.allMatch(array, condExpr);
                }
                case "anyMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.anyMatch(array, condExpr);
                }
                case "noneMatch": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.noneMatch(array, condExpr);
                }
                case "map": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction funcExpr = this.getLambdaFunction(function, argContext, 1);
                    if (funcExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.map(array, funcExpr);
                }
                case "flatMap": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction funcExpr = this.getLambdaFunction(function, argContext, 1);
                    if (funcExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.flatMap(array, funcExpr);
                }
                case "reduce": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    Object identity = function.getArgument(1).resolve(argContext).getValue();
                    IFunction funcExpr = this.getLambdaFunction(function, argContext, 2);
                    if (funcExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.reduce(array, identity, funcExpr);
                }
                case "findFirst": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.findFirst(array, condExpr);
                }
                case "get": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    long index = function.getArgument(1).resolve(argContext).getLong();
                    return expressionFunction.get(array, index);
                }
                case "getFirst": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    return expressionFunction.getFirst(array);
                }
                case "getLast": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    return expressionFunction.getLast(array);
                }
                case "isPeripheralUsed": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String name = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.isPeripheralUsed(child, name);
                }
                case "toInt": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IValue arg0 = function.getArgument(0).resolve(argContext);
                    if (arg0.getType() == IValue.Type.BIG_RATIONAL) {
                        BigRational rational = arg0.getRational();
                        return expressionFunction.toInt(rational);
                    }
                    String text = arg0.getString();
                    return expressionFunction.toInt(text);
                }
                case "toString": {
                    ExpressionContext.checkNumberOfArgsEx(function, 1, 2);
                    if (function.getArgNum() == 1) {
                        Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                        return expressionFunction.toString(firstArg);
                    }
                    BigInteger integer = function.getArgument(0).resolve(argContext).getBigInteger();
                    int radix = (int)function.getArgument(1).resolve(argContext).getLong();
                    return expressionFunction.toString(integer, radix);
                }
                case "countOccurrences": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction condExpr = this.getLambdaFunction(function, argContext, 1);
                    if (condExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    boolean recursive = function.getArgNum() == 2 ? false : function.getArgument(2).resolve(argContext).getBoolean();
                    return expressionFunction.countOccurrences(array, condExpr, recursive);
                }
                case "getEnumItemId": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getEnumItemId(node);
                }
                case "getEnumItemLabel": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getEnumItemLabel(node);
                }
                case "getEnumItemValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getEnumItemValue(node);
                }
                case "getSetItemValue": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getSetItemValue(node);
                }
                case "paramExists": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String paramName = function.getArgument(0).resolve(argContext).getString();
                    return Value.valueOf((boolean)expressionFunction.paramExists(paramName));
                }
                case "findDuplicates": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction keyExpr = this.getLambdaFunction(function, argContext, 1);
                    if (keyExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.findDuplicates(array, keyExpr);
                }
                case "join": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> list = ExpressionFunctions.listAdapter(function, 0, argContext);
                    String delimiter = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.join(list, delimiter);
                }
                case "formatMessage": {
                    ExpressionContext.checkMinNumberOfArgs(function, 2);
                    String message = function.getArgument(0).resolve(argContext).getString();
                    @Nullable Object[] parameters = new Object[function.getArgNum() - 1];
                    int i = 1;
                    while (i < function.getArgNum()) {
                        parameters[i - 1] = function.getArgument(i).resolve(argContext).getValue();
                        ++i;
                    }
                    return expressionFunction.formatMessage(message, parameters);
                }
                case "round": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    BigRational fraction = function.getArgument(0).resolve(argContext).getRational();
                    return expressionFunction.round(fraction);
                }
                case "replaceText": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String original = function.getArgument(0).resolve(argContext).getString();
                    String textToReplace = function.getArgument(1).resolve(argContext).getString();
                    String replacement = function.getArgument(2).resolve(argContext).getString();
                    return expressionFunction.replaceText(original, textToReplace, replacement);
                }
                case "nodeExists": {
                    ExpressionContext.checkNumberOfArgs(function, 1, 2);
                    if (function.getArgNum() == 1) {
                        String id = function.getArgument(0).resolve(argContext).getString();
                        return expressionFunction.nodeExists(null, id);
                    }
                    IChild node = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String id = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.nodeExists(node, id);
                }
                case "addItemToList": {
                    ExpressionContext.checkNumberOfArgs(function, 5);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof List)) {
                        throw new IllegalArgumentException("First argument is not a list");
                    }
                    List list = (List)firstArg;
                    String id = function.getArgument(1).resolve(argContext).getString();
                    String name = function.getArgument(2).resolve(argContext).getString();
                    String value = function.getArgument(3).resolve(argContext).getString();
                    IResolvable expression = function.getArgument(4);
                    return expressionFunction.addItemToList(list, id, name, value, expression);
                }
                case "toArray": {
                    Object[] arguments = new Object[function.getArgNum()];
                    int i = 0;
                    while (i < arguments.length) {
                        arguments[i] = function.getArgument(i).resolve(argContext).getValue();
                        ++i;
                    }
                    return expressionFunction.toArray(arguments);
                }
                case "merge": {
                    List[] lists = new List[function.getArgNum()];
                    int index = 0;
                    while (index < function.getArgNum()) {
                        lists[index] = ExpressionFunctions.listAdapter(function, index, argContext);
                        ++index;
                    }
                    return expressionFunction.merge(lists);
                }
                case "createArray": {
                    ExpressionContext.checkNumberOfArgsEx(function, 0, 3);
                    if (function.getArgNum() == 0) {
                        return expressionFunction.createArray();
                    }
                    BigInteger firstValue = function.getArgument(0).resolve(argContext).getBigInteger();
                    BigInteger stepValue = function.getArgument(1).resolve(argContext).getBigInteger();
                    BigInteger stepCount = function.getArgument(2).resolve(argContext).getBigInteger();
                    return expressionFunction.createArray(firstValue, stepValue, stepCount);
                }
                case "isCoreMaster": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String coreId = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.isCoreMaster(coreId);
                }
                case "getPeripherals": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String type = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.getPeripherals(type);
                }
                case "getPeripheralClock": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getPeripheralClock(peripheral, clockRole);
                }
                case "getPeripheralClockFrequency": {
                    ExpressionContext.checkNumberOfArgs(function, 3);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    String functionalGroup = function.getArgument(2).resolve(argContext).getString();
                    return expressionFunction.getPeripheralClockFrequency(peripheral, clockRole, functionalGroup);
                }
                case "peripheralClockExists": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.peripheralClockExists(peripheral, clockRole);
                }
                case "frequencyToString": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    BigRational frequencyInHertz = function.getArgument(0).resolve(argContext).getRational();
                    return expressionFunction.frequencyToString(frequencyInHertz);
                }
                case "timeToString": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    BigRational timeInMicroseconds = function.getArgument(0).resolve(argContext).getRational();
                    return expressionFunction.timeToString(timeInMicroseconds);
                }
                case "getClockFunctionalGroups": {
                    ExpressionContext.checkNumberOfArgs(function, 0);
                    return expressionFunction.getClockFunctionalGroups();
                }
                case "hasPeripheralClockSignal": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.hasPeripheralClockSignal(peripheral, clockRole);
                }
                case "getPeripheralClockSignal": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getPeripheralClockSignal(peripheral, clockRole);
                }
                case "getPeripheralClockDescription": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getPeripheralClockDescription(peripheral, clockRole);
                }
                case "getPeripheralClockType": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheral = function.getArgument(0).resolve(argContext).getString();
                    String clockRole = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getPeripheralClockType(peripheral, clockRole);
                }
                case "getSettingByKey": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof ArrayConfig)) {
                        throw new IllegalArgumentException("First argument is not an array");
                    }
                    ArrayConfig array = (ArrayConfig)firstArg;
                    String key = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getSettingByKey(array, key);
                }
                case "settingWithKeyExists": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof ArrayConfig)) {
                        throw new IllegalArgumentException("First argument is not an array");
                    }
                    ArrayConfig array = (ArrayConfig)firstArg;
                    String key = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.settingWithKeyExists(array, key);
                }
                case "getSettingKey": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    Object firstArg = function.getArgument(0).resolve(argContext).getValue();
                    if (!(firstArg instanceof ISettingConfig)) {
                        throw new IllegalArgumentException("First argument is not a setting");
                    }
                    ISettingConfig setting = (ISettingConfig)firstArg;
                    return expressionFunction.getSettingKey(setting);
                }
                case "toHertz": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String input = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.toHertz(input);
                }
                case "toHertzFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String input = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.toHertzFloat(input);
                }
                case "isPeripheralAvailable": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String peripheralName = function.getArgument(0).resolve(argContext).getString();
                    String coreId = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.isPeripheralAvailable(peripheralName, coreId);
                }
                case "getFreq": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    return expressionFunction.getFreq(value, wantedUnit, defaultUnit);
                }
                case "getFreqFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    return expressionFunction.getFreqFloat(value, wantedUnit, defaultUnit);
                }
                case "isFreq": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.isFreq(value);
                }
                case "getTime": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    return expressionFunction.getTime(value, wantedUnit, defaultUnit);
                }
                case "getTimeFloat": {
                    ExpressionContext.checkNumberOfArgs(function, 2, 3);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    String wantedUnit = function.getArgument(1).resolve(argContext).getString();
                    String defaultUnit = function.getArgNum() > 2 ? function.getArgument(2).resolve(argContext).getString() : null;
                    return expressionFunction.getTimeFloat(value, wantedUnit, defaultUnit);
                }
                case "isTime": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    String value = function.getArgument(0).resolve(argContext).getString();
                    return expressionFunction.isTime(value);
                }
                case "sort": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    List<?> array = ExpressionFunctions.listAdapter(function, 0, argContext);
                    IFunction comparatorExpr = this.getLambdaFunction(function, argContext, 1);
                    if (comparatorExpr == null) {
                        return this.throwLambdaFunctionArgumentException();
                    }
                    return expressionFunction.sort(array, comparatorExpr);
                }
                case "stringCompare": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    String first = function.getArgument(0).resolve(argContext).getString();
                    String second = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.stringCompare(first, second);
                }
                case "getSubType": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getSubType(child);
                }
                case "getComponentInstances": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String componentTypeId = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.getComponentInstances(child, componentTypeId);
                }
                case "getSdkBasePointer": {
                    ExpressionContext.checkNumberOfArgs(function, 1);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    return expressionFunction.getSdkBasePointer(child);
                }
                case "execScript": {
                    ExpressionContext.checkNumberOfArgs(function, 2);
                    IChild child = ExpressionContext.getChildFromArgAtIndex(function, argContext, 0);
                    String pathToScript = function.getArgument(1).resolve(argContext).getString();
                    return expressionFunction.execScript(child, pathToScript);
                }
            }
            throw new PeripheralExpressionException("Unknown function", ExpressionContext.class);
        }
        catch (ExpressionException e) {
            e.setFunction(function);
            if (e instanceof PeripheralExpressionException) {
                ((PeripheralExpressionException)e).addChildContext(this.childContext);
            }
            this.invalidArguments.forEach(x -> this.exception.addInvalidArgument(x.intValue()));
            throw e;
        }
    }

    private IValue throwLambdaFunctionArgumentException() {
        this.exception = new PeripheralExpressionException("Function requires lambda function format in argument", this.exception, ExpressionContext.class);
        throw this.exception;
    }

    private @Nullable IFunction getLambdaFunction(FunctionInvocation function, IContext argContext, int index) {
        try {
            return function.getArgument(index).resolve(argContext).getFunctionReference();
        }
        catch (ExpressionException e) {
            this.exception = e;
            this.invalidArguments.add(index);
            return null;
        }
    }

    private static void checkMinNumberOfArgs(FunctionInvocation function, int expectedMinNumberOfArgs) throws IllegalArgumentException {
        if (function.getArgNum() < expectedMinNumberOfArgs) {
            throw new IllegalArgumentException("Function: " + function.getName() + " requires at least " + expectedMinNumberOfArgs + " argument(s)");
        }
    }

    private static void checkNumberOfArgs(FunctionInvocation function, int expectedNumberOfArgs) throws IllegalArgumentException {
        if (function.getArgNum() != expectedNumberOfArgs) {
            throw new IllegalArgumentException("Function: " + function.getName() + " requires exactly " + expectedNumberOfArgs + " argument(s)");
        }
    }

    private static void checkNumberOfArgs(FunctionInvocation function, int expectedMinNumberOfArgs, int expectedMaxNumberOfArgs) throws IllegalArgumentException {
        if (function.getArgNum() < expectedMinNumberOfArgs || function.getArgNum() > expectedMaxNumberOfArgs) {
            throw new IllegalArgumentException("Function: " + function.getName() + " requires " + expectedMinNumberOfArgs + " to " + expectedMaxNumberOfArgs + " argument(s)");
        }
    }

    private static void checkNumberOfArgsEx(FunctionInvocation function, int ... expectedNumberOfArgs) throws IllegalArgumentException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IntStream argNumbers = Arrays.stream(expectedNumberOfArgs);){
            if (!argNumbers.anyMatch(i -> i == function.getArgNum())) {
                throw new IllegalArgumentException("Function: " + function.getName() + " requires exactly " + Arrays.toString(expectedNumberOfArgs) + " argument(s)");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static IChild getChildFromArgAtIndex(FunctionInvocation function, IContext argContext, int index) {
        Object resolvedArg = function.getArgument(index).resolve(argContext).getValue();
        if (!(resolvedArg instanceof IChild)) {
            throw new IllegalArgumentException("Argument at given index(" + index + ") is not a child");
        }
        return (IChild)resolvedArg;
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }
}

