/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ChildStorageHelper;
import com.nxp.swtools.periphs.model.config.ChildValidationHelper;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.ICacheable;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.IPresettable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.QuickSelectionHelper;
import com.nxp.swtools.periphs.model.config.SettingConfigFactory;
import com.nxp.swtools.periphs.model.config.SettingConfigHelper;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.IQuickSelectionGroup;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.emit.CodeEmitter;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigSetConfig
implements IChildProvidable,
ICacheable,
IPresettable {
    public static final String NAME_GLOBAL = "#global";
    private static final Logger LOGGER = LogManager.getLogger(ConfigSetConfig.class);
    private final CodeEmitter codeEmitter;
    private final String id;
    private final String name;
    protected final ConfigSet configSet;
    protected final Map<String, ISettingConfig> settings = new HashMap<String, ISettingConfig>();
    @Nullable
    protected QuickSelection quickSelection = null;
    protected final StoragePeriphsConfigSet storageConfigSet;
    protected final IContext expressionContext;
    protected final ChildContext childContext;
    protected final IMcu mcu;
    protected final Map<String, Object> cache = new HashMap<String, Object>();

    protected ConfigSetConfig(String id, ConfigSet configSet, ChildContext parentContext, IMcu mcu, boolean global) {
        this.name = global ? NAME_GLOBAL : configSet.getId();
        this.mcu = mcu;
        this.childContext = parentContext.createForChild(this);
        this.childContext.setConfigSetConfig(this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.id = id;
        this.configSet = configSet;
        this.storageConfigSet = new StoragePeriphsConfigSet();
        this.storageConfigSet.setName(configSet.getId());
        this.quickSelection = QuickSelectionHelper.getDefaultQuickSelection(this);
        this.storageConfigSet.setQuick_selection(this.quickSelection != null ? this.quickSelection.getId() : null);
        this.addAllRequiredSettings();
        this.codeEmitter = new CodeEmitter(this);
    }

    public ConfigSetConfig(String id, ConfigSet configSet, StoragePeriphsConfigSet storageConfigSet, ChildContext parentContext, IMcu mcu, boolean global) {
        this.name = global ? NAME_GLOBAL : configSet.getId();
        this.mcu = mcu;
        this.childContext = parentContext.createForChild(this);
        this.childContext.setConfigSetConfig(this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.id = id;
        this.configSet = configSet;
        this.storageConfigSet = storageConfigSet;
        this.codeEmitter = new CodeEmitter(this);
        this.quickSelection = (QuickSelection)CollectionsUtils.nullableOptionalGet(QuickSelectionHelper.getAvailableQuickSelections(this).stream().filter(x -> x.getId().equals(storageConfigSet.getQuick_selection())).findFirst());
        HashMap<K, @Nullable V> storagesMap = new HashMap();
        storageConfigSet.getSettings().forEach(x -> {
            AStoragePeriphsSetting aStoragePeriphsSetting = storagesMap.put(x.getName(), x);
        });
        configSet.getSettingsList().forEach(x -> {
            String settingName = x.getId();
            String childId = SettingUtils.buildId(id, settingName);
            AStoragePeriphsSetting storageSetting = (AStoragePeriphsSetting)storagesMap.get(settingName);
            storagesMap.remove(settingName);
            if (storageSetting != null) {
                this.settings.put(settingName, SettingConfigFactory.createSettingConfig(childId, x, this.childContext, storageSetting, mcu));
            } else {
                this.settings.put(settingName, SettingConfigFactory.createSettingConfig(childId, settingName, x, this.childContext, mcu));
            }
        });
        if (!storagesMap.isEmpty()) {
            LOGGER.warning(String.format("The following settings of the configSet %s could not be restored: %s", configSet.getId(), storagesMap.keySet()));
        }
        this.updateStorageSettings();
    }

    private void updateStorageSettings() {
        ArrayList storages = new ArrayList();
        this.getChildren().forEach(sc -> {
            boolean bl = storages.add(sc.getStorageSetting());
        });
        this.getStorageConfigSet().setSettings(storages);
    }

    @Override
    public void applySelectedQuickSelection() {
        if (this.quickSelection != null) {
            this.getChildren().forEach(x -> x.deInitialize());
            this.applyQuickSelection(this.quickSelection);
        }
        this.getChildren().forEach(x -> x.initValue());
    }

    private void addAllRequiredSettings() {
        for (ISetting setting : this.configSet.getSettingsList()) {
            if (this.settings.containsKey(setting.getId())) continue;
            String childId = SettingUtils.buildId(this.getId(), setting.getId());
            ISettingConfig settingConfig = SettingConfigFactory.createSettingConfig(childId, setting.getId(), setting, this.childContext, this.mcu);
            this.settings.put(setting.getId(), settingConfig);
            if (!settingConfig.isStorable()) continue;
            this.storageConfigSet.getSettings().add(settingConfig.getStorageSetting());
        }
    }

    @Override
    public void updateStorageAvailability() {
        ChildStorageHelper.updateStorageAvialability(this.getStorageConfigSet().getSettings(), this.getChildren());
    }

    @Override
    public Map<String, Object> getCache() {
        return this.cache;
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    @Override
    public IDependency @Nullable [] getOwnDependencies(String source) {
        return ChildValidationHelper.getDependencies(this.configSet.getValidation(), this.getExpressionContext(), source, this.makeOriginatorId(this.childContext));
    }

    public void applyQuickSelection(@Nullable QuickSelection quickSel) {
        this.getChildren().forEach(x -> x.applyQuickSelection(quickSel, this));
    }

    public StoragePeriphsConfigSet getStorageConfigSet() {
        return this.storageConfigSet;
    }

    @Override
    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public @Nullable QuickSelection getQuickSelection() {
        return this.quickSelection;
    }

    @Override
    public void setQuickSelection(@Nullable QuickSelection quickSelection) {
        this.quickSelection = quickSelection;
        this.storageConfigSet.setQuick_selection(quickSelection != null ? quickSelection.getId() : null);
    }

    @Override
    public ConfigSetConfig getValue() {
        return this;
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        return this.settings.get(childName);
    }

    @Override
    public @Nullable IChild getChildById(String childId) {
        return ChildProviderHelper.getChildRelative(this, childId);
    }

    public CodeEmitter getCodeEmitter() {
        return this.codeEmitter;
    }

    public ConfigSet getConfigSet() {
        return this.configSet;
    }

    public @Nullable String getValueName() {
        return this.quickSelection != null ? this.quickSelection.getUIName(this.expressionContext) : null;
    }

    public List<ISettingConfig> getChildren() {
        return SettingConfigHelper.getConfigsOf(this.configSet.getSettings(), this.settings);
    }

    @Override
    public boolean isAvailable() {
        IChildProvidable parent = this.childContext.getParent();
        return this.configSet.isAvailable(this.expressionContext) && (parent == null || parent.isAvailable());
    }

    @Override
    public boolean isEnabled() {
        IChildProvidable parent = this.childContext.getParent();
        return this.configSet.isEnabled(this.expressionContext) && (parent == null || parent.isEnabled());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUiName() {
        return this.configSet.getUIName(this.expressionContext);
    }

    public @Nullable String getDescription() {
        return this.configSet.getResolvedDescription(this.expressionContext);
    }

    @Override
    public String @Nullable [] getOwnProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*own_problems*" + (Object)((Object)level), () -> this.isEnabled() ? ChildValidationHelper.getValidationProblems(this.configSet.getValidation(), this.expressionContext, level) : null);
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.configSet.isOptionSet(option);
    }

    @Override
    public @Nullable Object getOptionValue(String option) {
        return this.configSet.getOptionValue(option, this.getExpressionContext());
    }

    @Override
    public @Nullable String getError() {
        return CacheHelper.getValueCaching(this, "*error", () -> this.getProblems(Level.ERROR));
    }

    @Override
    public @Nullable String getWarning() {
        return CacheHelper.getValueCaching(this, "*warning", () -> this.getProblems(Level.WARNING));
    }

    @Override
    public @Nullable String getInfo() {
        return CacheHelper.getValueCaching(this, "*info", () -> this.getProblems(Level.INFO));
    }

    @Override
    public @Nullable String getProblems(Level level) {
        return CacheHelper.getValueCaching(this, "*problems*" + (Object)((Object)level), () -> IChildProvidable.super.getProblems(level));
    }

    @Override
    public @Nullable String getNestedProblems(Level level) {
        return CacheHelper.getValueCaching(this, "*nested_problems*" + (Object)((Object)level), () -> IChildProvidable.super.getNestedProblems(level));
    }

    @Override
    public List<String> getProblemsPaths(Level level) {
        List cachedValue = CacheHelper.getValueCaching(this, "*problems_paths*" + (Object)((Object)level), () -> IChildProvidable.super.getProblemsPaths(level));
        return cachedValue == null ? CollectionsUtils.emptyList() : cachedValue;
    }

    public String toString() {
        return "ConfigSet: [Id: " + this.getId() + "]";
    }

    @Override
    public @NonNull ConfigSet getModelData() {
        return this.configSet;
    }

    @Override
    public IQuickSelectionGroup getQuickSelectionGroup() {
        return this.getModelData();
    }
}

