/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.ICacheable;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.MasterPeripheral;
import com.nxp.swtools.periphs.model.data.Mode;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.converters.StorageYamlConverter;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class ComponentInstanceConfig
implements IChildProvidable,
ICacheable {
    private static final Logger LOGGER = LogManager.getLogger(ComponentInstanceConfig.class);
    private String name;
    private final ConfigurationComponent component;
    private final StoragePeriphsComponentInstance storageComponent;
    private Mode mode;
    @Nullable
    private String peripheral;
    private final Map<String, ConfigSetConfig> configSets = new HashMap<String, ConfigSetConfig>();
    protected final ChildContext childContext;
    protected final ExpressionContext expressionContext;
    protected final IMcu mcu;
    private boolean enabled = true;
    protected final Map<String, Object> cache = new HashMap<String, Object>();

    @Override
    public @NonNull String @Nullable [] getOwnProblems(Level level) {
        if (this.isEnabled() && level == Level.ERROR) {
            int count = 0;
            String unavailablePeripheralError = this.getPeripheralsUnavailableForCoreError();
            String usedPeripheralError = this.getMoreInstancesOnSamePeripheralError();
            String uniquenesOfNameError = this.getNotUniqueNameError();
            String peripheralNotUsableForModeError = this.getPeripheralNotUsableForModeError();
            if (unavailablePeripheralError != null) {
                ++count;
            }
            if (usedPeripheralError != null) {
                ++count;
            }
            if (uniquenesOfNameError != null) {
                ++count;
            }
            if (peripheralNotUsableForModeError != null) {
                ++count;
            }
            String[] result = new String[count];
            count = 0;
            if (unavailablePeripheralError != null) {
                result[count++] = unavailablePeripheralError;
            }
            if (usedPeripheralError != null) {
                result[count++] = usedPeripheralError;
            }
            if (uniquenesOfNameError != null) {
                result[count++] = uniquenesOfNameError;
            }
            if (peripheralNotUsableForModeError != null) {
                result[count++] = peripheralNotUsableForModeError;
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.component.isOptionSet(option);
    }

    @Override
    public @Nullable Object getOptionValue(String option) {
        return this.component.getOptionValue(option, this.expressionContext);
    }

    public Collection<String> getErroneousPeripherals() {
        if (this.isEnabled()) {
            Collection<String> result = this.getErroneousUnavailablePeripherals();
            result.addAll(this.getErroneousPeripheralsUsedMultipleTimes().keySet());
            return result;
        }
        return new ArrayList<String>(0);
    }

    private CollectionMap<String, ComponentInstanceConfig> getErroneousPeripheralsUsedMultipleTimes() {
        Supplier<CollectionMap> valueSupplier = () -> {
            CollectionMap result = new CollectionMap();
            FunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
            if (functionalGroup != null) {
                FunctionalGroup nonNullFunctionalGroup = functionalGroup;
                Map<String, ComponentInstanceConfig> instances = nonNullFunctionalGroup.getInstances();
                ArrayList<String> exlusivePeripherals = new ArrayList<String>();
                ArrayList<String> nonExclusivePeripherals = new ArrayList<String>();
                String selectedPeripheral = this.getPeripheral();
                if (selectedPeripheral != null) {
                    MasterPeripheral masterPeripheral = this.getMode().getMasterPeripheral();
                    if (masterPeripheral != null) {
                        if (masterPeripheral.isExclusive()) {
                            exlusivePeripherals.add(selectedPeripheral);
                        } else {
                            nonExclusivePeripherals.add(selectedPeripheral);
                        }
                    }
                    nonExclusivePeripherals.addAll(this.getSlavePeripherals());
                }
                for (ComponentInstanceConfig instance : instances.values()) {
                    if (this == instance || !instance.isEnabled()) continue;
                    for (String peripheralLoc : exlusivePeripherals) {
                        if (!instance.isPeripheralUsed(peripheralLoc)) continue;
                        result.add((Object)peripheralLoc, (Object)instance);
                    }
                    for (String peripheralLoc : nonExclusivePeripherals) {
                        if (!instance.isPeripheralUsedExlusively(peripheralLoc)) continue;
                        result.add((Object)peripheralLoc, (Object)instance);
                    }
                }
            }
            return result;
        };
        return CacheHelper.getValueCaching(this, "*multiusage_peripherals", valueSupplier);
    }

    private Collection<String> getErroneousUnavailablePeripherals() {
        ArrayList<String> result = new ArrayList<String>();
        FunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
        if (functionalGroup != null) {
            for (String peripheralLoc : this.getPeripherals()) {
                if (this.mcu.isPeripheralAvailableForCore(functionalGroup.getCore(), peripheralLoc)) continue;
                result.add(peripheralLoc);
            }
        }
        return result;
    }

    private @Nullable String getMoreInstancesOnSamePeripheralError() {
        CollectionMap<String, ComponentInstanceConfig> erroneousPeripherals = this.getErroneousPeripheralsUsedMultipleTimes();
        if (!erroneousPeripherals.isEmpty()) {
            String instancesString = CollectionsUtils.formatList((Collection)erroneousPeripherals.flatValuesSet(), (String)", ", c -> c.getName());
            String peripheralsString = CollectionsUtils.formatList((Collection)erroneousPeripherals.keySet(), (String)", ", null);
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_MultipleInstancesOnPeripheral), peripheralsString, instancesString);
        }
        return null;
    }

    public @Nullable String getNotUniqueNameError() {
        if (this.isEnabled()) {
            FunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
            if (functionalGroup == null) {
                return null;
            }
            PeriphsProfile profile = this.childContext.getProfile();
            String identifier = functionalGroup.createIdentifier(this.getId());
            if (profile.countSameIdentifierOccurences(functionalGroup.getIdPrefix(), identifier) > 1) {
                return ComponentInstanceConfig.getNameConflictError(this, this.getId());
            }
        }
        return null;
    }

    public static @Nullable String getNameConflictError(ComponentInstanceConfig instance, String nameToTest) {
        String error = null;
        FunctionalGroup functionalGroup = instance.getChildContext().getFunctionalGroup();
        if (functionalGroup != null) {
            List<FunctionalGroup> groupsContainingNewName = instance.getChildContext().getProfile().getGroupsContainingIdentifier(functionalGroup.getIdPrefix(), functionalGroup.createIdentifier(nameToTest));
            groupsContainingNewName.remove(functionalGroup);
            if (!groupsContainingNewName.isEmpty()) {
                String groupNames = UtilsText.join(groupsContainingNewName.stream().map(x -> x.getUiName()), (String)", ");
                error = MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_NameIsNotUniqueOtherGroup), nameToTest, groupNames, functionalGroup.getUiName());
            } else {
                error = MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_NameIsNotUnique), nameToTest);
            }
        }
        return error;
    }

    public @Nullable String getMasterPeripheralError() {
        if (this.isEnabled()) {
            CollectionMap<String, ComponentInstanceConfig> erroneousPeripherals = this.getErroneousPeripheralsUsedMultipleTimes();
            String masterPeripheral = this.getPeripheral();
            Collection conflictInstances = erroneousPeripherals.get((Object)masterPeripheral);
            if (masterPeripheral != null && conflictInstances != null && !conflictInstances.isEmpty()) {
                String instancesString = CollectionsUtils.formatList((Collection)conflictInstances, (String)", ", c -> c.getName());
                return MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_MultipleInstancesOnPeripheral), masterPeripheral, instancesString);
            }
            FunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
            if (functionalGroup != null && masterPeripheral != null && this.getErroneousUnavailablePeripherals().contains(masterPeripheral)) {
                String unformattedMessage = Messages.get().ComponentInstanceConfig_ComponentPeripheralsUnavailableForCore;
                return MessageFormat.format(UtilsText.safeString((String)unformattedMessage), masterPeripheral, functionalGroup.getCore());
            }
            String peripheralNotUsableForModeError = this.getPeripheralNotUsableForModeError();
            if (peripheralNotUsableForModeError != null) {
                return peripheralNotUsableForModeError;
            }
        }
        return null;
    }

    private @Nullable String getPeripheralNotUsableForModeError() {
        boolean isPeripheralUsableInMode;
        MasterPeripheral selectedModeMasterPeripheral = this.getMode().getMasterPeripheral();
        String selectedPeripheral = this.getPeripheral();
        if (selectedModeMasterPeripheral != null && !(isPeripheralUsableInMode = selectedModeMasterPeripheral.getPeripherals().stream().flatMap(type -> this.mcu.getPeripherals((String)type).stream()).anyMatch(p -> p.equals(selectedPeripheral)))) {
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_PeripheralNotUsableInMode), this.getMode().getUIName(this.expressionContext), UtilsText.safeString((String)selectedPeripheral));
        }
        return null;
    }

    public @Nullable String getPeripheralsError() {
        if (this.isEnabled()) {
            String unavailableError = this.getPeripheralsUnavailableForCoreError();
            String moreInstancesError = this.getMoreInstancesOnSamePeripheralError();
            if (unavailableError == null) {
                return moreInstancesError;
            }
            if (moreInstancesError == null) {
                return unavailableError;
            }
            return String.valueOf(unavailableError) + "\r\n" + moreInstancesError;
        }
        return null;
    }

    private @Nullable String getPeripheralsUnavailableForCoreError() {
        FunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
        Collection<String> unavailablePeripherals = this.getErroneousUnavailablePeripherals();
        String unavailablePeripheralsText = CollectionsUtils.formatList(unavailablePeripherals, (String)", ", null);
        if (!unavailablePeripheralsText.isEmpty() && functionalGroup != null) {
            String unformattedMessage = UtilsText.safeString((String)Messages.get().ComponentInstanceConfig_ComponentPeripheralsUnavailableForCore);
            return MessageFormat.format(unformattedMessage, unavailablePeripheralsText, functionalGroup.getCore());
        }
        return null;
    }

    public ComponentInstanceConfig(ConfigurationComponent component, FunctionalGroup functionalGroup, String name, Mode mode, Map<String, ConfigSetConfig> configSets, @Nullable String peripheral, ChildContext parentContext, IMcu mcu) {
        this.mcu = mcu;
        this.name = name;
        this.component = component;
        this.childContext = this.createChildContext(parentContext);
        this.childContext.setFunctionalGroup(functionalGroup);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.mode = mode;
        this.storageComponent = new StoragePeriphsComponentInstance();
        this.storageComponent.setEnabled(this.isEnabled());
        this.peripheral = peripheral;
        this.configSets.putAll(configSets);
        this.addRequiredConfigSets();
        this.updateStorage();
    }

    public ComponentInstanceConfig(ConfigurationComponent component, FunctionalGroup functionalGroup, String name, Mode mode, @Nullable String peripheral, ChildContext parentContext, IMcu mcu) {
        this(component, functionalGroup, name, mode, CollectionsUtils.emptyMap(), peripheral, parentContext, mcu);
    }

    public ComponentInstanceConfig(ConfigurationComponent component, FunctionalGroup functionalGroup, StoragePeriphsComponentInstance storageComponent, ChildContext parentContext, IMcu mcu) {
        this.mcu = mcu;
        this.name = storageComponent.getName();
        this.storageComponent = storageComponent;
        this.setEnabled(storageComponent.isEnabled());
        this.component = component;
        this.childContext = this.createChildContext(parentContext);
        this.childContext.setFunctionalGroup(functionalGroup);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        Mode modeLoc = component.getMode(storageComponent.getMode());
        if (modeLoc == null) {
            LOGGER.severe("Mode not found: " + storageComponent.getMode());
            modeLoc = component.getScenarios().get(0);
        }
        this.mode = modeLoc;
        this.peripheral = storageComponent.getPeripheral();
        for (StoragePeriphsConfigSet storageConfigSet : storageComponent.getConfig_sets()) {
            String configSetId = storageConfigSet.getName();
            ConfigSet configSet = component.getConfigSet(configSetId);
            if (configSet == null) {
                LOGGER.severe(MessageFormat.format("Component with ID {0} does not contain a config-set with ID {1} referenced in {2} with name {3}", component.getId(), configSetId, storageComponent.getClass().getSimpleName(), storageComponent.getName()));
                continue;
            }
            this.configSets.put(configSetId, new ConfigSetConfig(configSet.getId(), configSet, storageConfigSet, this.childContext, mcu, false));
        }
        ArrayList<ConfigSetConfig> createdConfigSets = new ArrayList<ConfigSetConfig>(this.configSets.values());
        this.addRequiredConfigSets();
        createdConfigSets.forEach(cs -> cs.applySelectedQuickSelection());
        this.updateStorage();
    }

    private final ChildContext createChildContext(ChildContext parentContext) {
        ChildContext ctx = parentContext.createForChild(this);
        ctx.setComponentInstanceConfig(this);
        PeriphsProfile profile = ctx.getProfile();
        ComponentConfig componentConfig = profile.getComponent(this.component.getId());
        if (componentConfig == null) {
            LOGGER.severe("Cannot create valid child-context for the component instance " + this.getName() + " of type " + this.component.getId() + " because there is no component configuration of that type in the profile." + "At first add component configuration to the profile.");
        }
        ctx.setComponentConfig(componentConfig);
        return ctx;
    }

    private void updateStorage() {
        this.storageComponent.setType(this.component.getId());
        ComponentConfig componentConfig = this.childContext.getComponentConfig();
        if (componentConfig != null) {
            this.storageComponent.setType_id(componentConfig.getComponentTypeId());
        }
        this.storageComponent.setName(this.name);
        this.storageComponent.setMode(this.mode.getId());
        this.storageComponent.setPeripheral(this.peripheral);
        this.storageComponent.setEnabled(this.enabled);
        this.storageComponent.getConfig_sets().clear();
        this.configSets.values().forEach(x -> {
            boolean bl = this.storageComponent.getConfig_sets().add(x.getStorageConfigSet());
        });
    }

    @Override
    public Map<String, Object> getCache() {
        return this.cache;
    }

    public ConfigurationComponent getComponent() {
        return this.component;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
        this.storageComponent.setName(name);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void changeMode(Mode newMode) {
        this.mode = newMode;
        this.storageComponent.setMode(newMode.getId());
        this.addRequiredConfigSets();
        this.updateStorage();
    }

    private boolean addRequiredConfigSets() {
        ArrayList<ConfigSetConfig> addedConfigSets = new ArrayList<ConfigSetConfig>();
        for (String configSetId : this.mode.getConfigSetRefs()) {
            if (this.configSets.containsKey(configSetId)) continue;
            ConfigSet configSet = this.component.getConfigSet(configSetId);
            if (configSet == null) {
                LOGGER.severe(MessageFormat.format("Component with ID {0} does not contain a config-set with ID {1} referenced in mode with ID {2}", this.component.getId(), configSetId, this.mode.getId()));
                continue;
            }
            ConfigSetConfig configSetConfig = new ConfigSetConfig(configSet.getId(), configSet, this.childContext, this.mcu, false);
            this.configSets.put(configSetId, configSetConfig);
            addedConfigSets.add(configSetConfig);
        }
        addedConfigSets.forEach(cs -> cs.applySelectedQuickSelection());
        return !addedConfigSets.isEmpty();
    }

    public boolean isPeripheralUsed(String peripheralInstance) {
        return this.getPeripherals().contains(peripheralInstance);
    }

    public boolean isPeripheralUsedExlusively(String peripheralInstance) {
        MasterPeripheral masterPeripheral = this.mode.getMasterPeripheral();
        return peripheralInstance.equals(this.peripheral) && masterPeripheral != null && masterPeripheral.isExclusive();
    }

    public @Nullable String getPeripheral() {
        return this.peripheral;
    }

    public List<String> getSlavePeripherals() {
        return CacheHelper.getValueCaching(this, "*nested_peripherals", () -> {
            ArrayList<String> result = new ArrayList<String>();
            LinkedList<@Nullable ? extends IChild> queue = new LinkedList<IChild>(CollectionsUtils.asList((Object)this));
            while (!queue.isEmpty()) {
                IChild child = (IChild)queue.poll();
                if (child == null) continue;
                if (child instanceof IChildProvidable) {
                    queue.addAll(((IChildProvidable)child).getChildren());
                }
                if (!child.isOptionSet("FEATURE_PERIPHERAL_SELECT")) continue;
                result.add(UtilsText.safeString((String)child.getValue().toString()));
            }
            return CollectionsUtils.unmodifiableList(result);
        });
    }

    public List<String> getPeripherals() {
        ArrayList<String> result = new ArrayList<String>(this.getSlavePeripherals());
        String masterPeripheral = this.getPeripheral();
        if (masterPeripheral != null) {
            result.add(masterPeripheral);
        }
        return result;
    }

    public void setPeripheral(@Nullable String peripheral) {
        this.peripheral = peripheral;
        this.storageComponent.setPeripheral(peripheral);
    }

    public Map<String, ConfigSetConfig> getConfigSets() {
        return CollectionsUtils.unmodifiableMap(this.configSets);
    }

    @Override
    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative(this, id);
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public @Nullable ConfigSetConfig getChild(String childName) {
        return this.configSets.get(childName);
    }

    public List<ConfigSetConfig> getChildren() {
        ArrayList<ConfigSetConfig> result = new ArrayList<ConfigSetConfig>();
        for (String configSetId : this.mode.getConfigSetRefs()) {
            ConfigSetConfig configSetConfig = this.configSets.get(configSetId);
            if (configSetConfig == null) {
                LOGGER.severe(MessageFormat.format("Configuration not found for config-set with ID {0} referenced in mode with ID {1} of component with ID {2}", configSetId, this.mode.getId(), this.component.getId()));
                continue;
            }
            result.add(configSetConfig);
        }
        return result;
    }

    public StoragePeriphsComponentInstance getStorageComponent() {
        return this.storageComponent;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getId() {
        return this.name;
    }

    public String getType() {
        return this.component.getId();
    }

    public @NonNull String getTypeName() {
        return this.getType();
    }

    @Override
    public String getUiName() {
        return this.name;
    }

    public @Nullable String getDescription() {
        return this.component.getResolvedDescription(this.expressionContext);
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    public ConfigurationComponentTypeId getConfigCompTypeId() {
        ComponentConfig config = this.childContext.getComponentConfig();
        assert (config != null);
        return config.getConfigCompTypeId();
    }

    public String getComponentTypeId() {
        return this.getConfigCompTypeId().getTypeId();
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.storageComponent.setEnabled(enabled);
    }

    public @Nullable String getYaml() {
        if (this.childContext.getProfile().isYamlEnabled()) {
            FunctionalGroup functionalGroup = this.childContext.getFunctionalGroup();
            String functionalGroupName = functionalGroup == null ? null : functionalGroup.getName();
            ComponentConfig componentConfig = this.childContext.getComponentConfig();
            String componentTypeId = componentConfig == null ? null : componentConfig.getComponentTypeId();
            IYamlStorable yamlStorable = StorageYamlConverter.toYamlStorable(this.storageComponent, functionalGroupName, componentTypeId);
            return new PeripheralsYamlConverter().createYamlFunction(yamlStorable);
        }
        return null;
    }

    @Override
    public void updateStorageAvailability() {
        this.storageComponent.getConfig_sets().clear();
        this.configSets.values().forEach(cs -> {
            if (cs.isAvailable() && this.mode.getConfigSetRefs().contains(cs.getConfigSet().getId())) {
                this.storageComponent.getConfig_sets().add(cs.getStorageConfigSet());
                cs.updateStorageAvailability();
            }
        });
    }

    protected void clearCache() {
        this.getCache().clear();
        this.configSets.values().forEach(x -> x.getCache().clear());
    }

    public String readComponentFile(String filePath) {
        ComponentConfig componentConfig = this.getChildContext().getComponentConfig();
        if (componentConfig != null) {
            return componentConfig.readComponentFile(filePath);
        }
        LOGGER.log(java.util.logging.Level.SEVERE, "Cannot find component config for this instance!");
        return "";
    }

    public String getScriptFile() {
        ComponentConfig componentConfig = this.getChildContext().getComponentConfig();
        if (componentConfig != null) {
            return componentConfig.getScriptFile();
        }
        LOGGER.log(java.util.logging.Level.SEVERE, "Cannot find component config for this instance!");
        return "";
    }

    @Override
    public @Nullable String getError() {
        return CacheHelper.getValueCaching(this, "*error", () -> this.getProblems(Level.ERROR));
    }

    @Override
    public @Nullable String getWarning() {
        return CacheHelper.getValueCaching(this, "*warning", () -> this.getProblems(Level.WARNING));
    }

    @Override
    public @Nullable String getInfo() {
        return CacheHelper.getValueCaching(this, "*info", () -> this.getProblems(Level.INFO));
    }

    public String toString() {
        return "ComponentInstance: [Type: " + this.getType() + ", Name: " + this.getName() + "]";
    }
}

