/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.Script;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.converters.StorageYamlConverter;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ComponentConfig
implements IChildProvidable {
    private static final Logger LOGGER = LogManager.getLogger(ComponentConfig.class);
    private final StoragePeriphsComponent storageComponent;
    private final ConfigurationComponentTypeId configCompTypeId;
    @Nullable
    protected ConfigSetConfig globalConfigSet;
    protected final ChildContext childContext;
    protected final ExpressionContext expressionContext;
    protected final IMcu mcu;

    public ComponentConfig(ConfigurationComponentTypeId configCompTypeId, StoragePeriphsComponent storageComponent, ChildContext parentContext, IMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild(this);
        this.childContext.setComponentConfig(this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.configCompTypeId = configCompTypeId;
        ConfigurationComponent component = configCompTypeId.getConfigurationComponent();
        this.storageComponent = storageComponent;
        this.storageComponent.setName(component.getId());
        StoragePeriphsConfigSet configSetStorage = storageComponent.getConfig_set_global();
        ConfigSet configSet = component.getGlobalConfigSet();
        if (configSet != null) {
            ConfigSetConfig configSetConfig = configSetStorage != null ? new ConfigSetConfig(configSet.getId(), configSet, configSetStorage, this.childContext, mcu, true) : new ConfigSetConfig(configSet.getId(), configSet, this.childContext, mcu, true);
            this.globalConfigSet = configSetConfig;
            storageComponent.setConfig_set_global(configSetConfig.getStorageConfigSet());
            configSetConfig.applySelectedQuickSelection();
        } else {
            this.globalConfigSet = null;
            if (configSetStorage != null) {
                LOGGER.severe(MessageFormat.format("Component with ID {0} does not contain a global config-set", component.getId()));
            }
        }
    }

    public ComponentConfig(ConfigurationComponentTypeId configCompTypeId, ChildContext parentContext, IMcu mcu) {
        this.mcu = mcu;
        this.childContext = parentContext.createForChild(this);
        this.childContext.setComponentConfig(this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.configCompTypeId = configCompTypeId;
        ConfigurationComponent component = configCompTypeId.getConfigurationComponent();
        this.storageComponent = new StoragePeriphsComponent();
        this.storageComponent.setName(component.getId());
        this.storageComponent.setTypeId(configCompTypeId.getTypeId());
        ConfigSet configSet = component.getGlobalConfigSet();
        if (configSet == null) {
            this.globalConfigSet = null;
        } else {
            ConfigSetConfig configSetConfig;
            this.globalConfigSet = configSetConfig = new ConfigSetConfig(configSet.getId(), configSet, this.childContext, mcu, true);
            this.storageComponent.setConfig_set_global(configSetConfig.getStorageConfigSet());
            configSetConfig.applySelectedQuickSelection();
        }
    }

    public StoragePeriphsComponent getStorageComponent() {
        return this.storageComponent;
    }

    public ConfigurationComponent getComponent() {
        return this.configCompTypeId.getConfigurationComponent();
    }

    public String getType() {
        return this.configCompTypeId.getConfigurationComponent().getId();
    }

    public @NonNull String getTypeName() {
        return this.getType();
    }

    public @Nullable ConfigSetConfig getGlobalConfigSet() {
        return this.globalConfigSet;
    }

    @Override
    public String getId() {
        return this.configCompTypeId.getConfigurationComponent().getId();
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative(this, id);
    }

    @Override
    public @Nullable IChild getChild(String name) {
        ConfigSetConfig globalConfigSetLoc = this.globalConfigSet;
        if (globalConfigSetLoc != null && globalConfigSetLoc.getName().equals(name)) {
            return globalConfigSetLoc;
        }
        return null;
    }

    @Override
    public List<? extends IChild> getChildren() {
        ArrayList<ConfigSetConfig> result = new ArrayList<ConfigSetConfig>();
        ConfigSetConfig globalConfigSetLoc = this.globalConfigSet;
        if (globalConfigSetLoc != null) {
            result.add(globalConfigSetLoc);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.configCompTypeId.getConfigurationComponent().getId();
    }

    @Override
    public String getUiName() {
        return this.configCompTypeId.getConfigurationComponent().getLabel(this.expressionContext);
    }

    public @Nullable String getDescription() {
        return this.configCompTypeId.getConfigurationComponent().getResolvedDescription(this.expressionContext);
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    @Override
    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public ConfigurationComponentTypeId getConfigCompTypeId() {
        return this.configCompTypeId;
    }

    public String getComponentTypeId() {
        return this.configCompTypeId.getTypeId();
    }

    public String getScriptFile() {
        Script script = this.configCompTypeId.getConfigurationComponent().getScript();
        if (script == null) {
            return "";
        }
        Path dir = this.configCompTypeId.getFileLocation();
        return UtilsText.safeString((String)dir.resolve(script.getFile()).toString());
    }

    public @Nullable String getYaml() {
        if (this.childContext.getProfile().isYamlEnabled()) {
            IYamlStorable yamlStorable = StorageYamlConverter.toYamlStorable(this.storageComponent);
            return new PeripheralsYamlConverter().createYamlFunction(yamlStorable);
        }
        return null;
    }

    @Override
    public void updateStorageAvailability() {
        if (this.globalConfigSet != null) {
            this.globalConfigSet.updateStorageAvailability();
        }
    }

    protected void clearCache() {
        if (this.globalConfigSet != null) {
            this.globalConfigSet.getCache().clear();
        }
    }

    public String readComponentFile(String filePath) {
        String finalPath = String.valueOf(UtilsText.safeString((String)this.configCompTypeId.getFileLocation().toString())) + "\\" + filePath;
        return UtilsText.safeString((String)UtilsFile.readFileToString((String)finalPath, null));
    }
}

