/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.ArraysUtils;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.data.Constraint;
import com.nxp.swtools.periphs.model.data.Dependency;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.Validation;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ChildValidationHelper {
    private static final String CHILD_PROBLEM_DESCRIPTION_PREFIX = "\u2013 See setting: ";

    public static @Nullable String getChildrenProblemsWithPrefix(IChildProvidable childProvidable, Level level) {
        if (childProvidable.isAvailable() && childProvidable.isEnabled()) {
            return ChildValidationHelper.getChildrenProblems(childProvidable, level);
        }
        return null;
    }

    public static @Nullable String getChildrenProblems(IChildProvidable childProvidable, Level level) {
        StringJoiner result = new StringJoiner("\n");
        List<String> childrenProblemsList = ChildValidationHelper.getChildrenProblemsList(childProvidable, level);
        if (childrenProblemsList != null) {
            for (String problem : childrenProblemsList) {
                result.add(ChildValidationHelper.createChildProblemPathString(problem));
            }
            return result.toString();
        }
        return null;
    }

    private static String createChildProblemPathString(String problemPath) {
        StringBuilder result = new StringBuilder();
        result.append(CHILD_PROBLEM_DESCRIPTION_PREFIX);
        result.append("(");
        result.append(problemPath);
        result.append(")");
        return UtilsText.safeToString((Object)result);
    }

    public static @Nullable List<String> getChildrenProblemsList(IChildProvidable childProvidable, Level level) {
        if (childProvidable.isAvailable() && childProvidable.isEnabled()) {
            List result = (List)childProvidable.getChildren().stream().filter(x -> x.getProblems(level) != null).map(x -> x.getProblemsPaths(level)).flatMap(list -> list.stream()).filter(path -> !path.isEmpty()).collect(CollectorsUtils.toList());
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    public static String @Nullable [] getSettingProblems(ISettingConfig child, Level level) {
        if (child.isAvailable() && child.isEnabled()) {
            String invalidValueError;
            String[] validationProblems;
            Object[] result = new String[]{};
            ISetting modelData = child.getModelData();
            assert (modelData != null) : "Given model is null";
            Validation validation = modelData.getValidation();
            IContext exprContext = child.getExpressionContext();
            String[] stringArray = validationProblems = validation == null ? null : ChildValidationHelper.getValidationProblems(validation, exprContext, level);
            if (validationProblems != null) {
                result = validationProblems;
            }
            String string = invalidValueError = level == Level.ERROR ? child.getValueError() : null;
            if (invalidValueError != null) {
                result = (String[])ArraysUtils.join((Object[])result, (Object)invalidValueError);
            }
            if (child.isOptionSet("FEATURE_PERIPHERAL_SELECT") && level == Level.ERROR) {
                String peripheralError = null;
                FunctionalGroup functionalGroup = child.getChildContext().getFunctionalGroup();
                if (functionalGroup != null) {
                    FunctionalGroup nonNullFunctionalGroup = functionalGroup;
                    Map<String, ComponentInstanceConfig> instances = nonNullFunctionalGroup.getInstances();
                    HashSet<String> conflictPeripherals = new HashSet<String>();
                    HashSet<ComponentInstanceConfig> conflictInstances = new HashSet<ComponentInstanceConfig>();
                    String selectedPeripheral = UtilsText.safeString((String)child.getValueName());
                    for (ComponentInstanceConfig instance : instances.values()) {
                        if (child.getChildContext().getComponentInstanceConfig() == instance || !instance.isEnabled() || !instance.isPeripheralUsedExlusively(selectedPeripheral)) continue;
                        conflictPeripherals.add(selectedPeripheral);
                        conflictInstances.add(instance);
                    }
                    if (!conflictPeripherals.isEmpty()) {
                        String instancesString = CollectionsUtils.formatList(conflictInstances, (String)", ", c -> UtilsText.safeString((String)c.getName()));
                        String peripheralsString = CollectionsUtils.formatList(conflictPeripherals, (String)", ", null);
                        String unformatedMessage = Messages.get().ComponentInstanceConfig_MultipleInstancesOnPeripheral;
                        peripheralError = MessageFormat.format(UtilsText.safeString((String)unformatedMessage), peripheralsString, instancesString);
                    }
                }
                if (peripheralError != null) {
                    result = (String[])ArraysUtils.join((Object[])result, peripheralError);
                }
            }
            return ArraysUtils.isEmpty((Object[])result) ? null : result;
        }
        return null;
    }

    public static String @Nullable [] getValidationProblems(Validation validation, IContext exprContext, Level level) {
        List<Constraint> violated = validation.collectViolatedConstraints(exprContext, level.toString());
        String[] result = (String[])violated.stream().map(x -> x.getDescription(exprContext)).toArray(String[]::new);
        return result.length == 0 ? null : result;
    }

    public static @Nullable String mergeProblems(String ... problems) {
        StringBuilder resultBuilder = null;
        if (problems != null) {
            String[] stringArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                String problem = stringArray[n2];
                if (!UtilsText.isEmpty((String)problem)) {
                    if (resultBuilder == null) {
                        resultBuilder = new StringBuilder(problem);
                    } else {
                        resultBuilder.append("\n").append(problem);
                    }
                }
                ++n2;
            }
        }
        return resultBuilder == null ? null : resultBuilder.toString();
    }

    public static IDependency @Nullable [] getDependencies(@Nullable Validation validation, IContext expressionContext, String source, String originatorId) {
        if (validation == null) {
            return null;
        }
        ArrayList<StorageDependency> result = new ArrayList<StorageDependency>();
        for (Dependency dep : validation.getDependencies()) {
            StorageDependency stg = dep.resolve(expressionContext, source, originatorId);
            if (stg == null) continue;
            result.add(stg);
        }
        return result.toArray(new IDependency[0]);
    }

    public static List<String> getProblemsPaths(IChildProvidable childProvidable, Level level) {
        String prefix;
        String name;
        if (childProvidable.isOptionSet("UI_LABEL_HIDDEN")) {
            prefix = name = "";
        } else {
            name = UtilsText.safeString((String)childProvidable.getUiName());
            prefix = String.valueOf(name) + " / ";
        }
        List<String> childrenProblemsList = ChildValidationHelper.getChildrenProblemsList(childProvidable, level);
        if (childrenProblemsList != null) {
            List problemsPaths = (List)childrenProblemsList.stream().flatMap(problem -> Arrays.asList(problem.split("\\R")).stream()).map(splitProblem -> String.valueOf(prefix) + splitProblem).filter(path -> !path.isEmpty()).collect(CollectorsUtils.toList());
            return problemsPaths;
        }
        return CollectionsUtils.asList((Object)name);
    }
}

