/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.config.AStructuredSettingConfig;
import com.nxp.swtools.periphs.model.config.ArrayConfig;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentsProvider;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.StructConfig;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ChildProviderHelper {
    public static @Nullable IChild getChildRelative(IChildProvidable providable, String id) {
        IChild child;
        int dotIdx = id.indexOf(".");
        String fstPart = id;
        String sndPart = "";
        if (dotIdx >= 0) {
            fstPart = id.substring(0, dotIdx);
            sndPart = id.substring(dotIdx + ".".length(), id.length());
        }
        if ((child = providable.getChild(fstPart)) instanceof IChildProvidable) {
            if (sndPart.isEmpty()) {
                return child;
            }
            return ChildProviderHelper.getChildRelative((IChildProvidable)child, sndPart);
        }
        return sndPart.isEmpty() && child != null ? child : null;
    }

    public static @Nullable IChild getChild(ChildContext context, String id) {
        String relativeId;
        IChild relativeParent;
        block33: {
            int dotIdx = id.indexOf(".");
            String fstPart = id;
            String sndPart = "";
            if (dotIdx >= 0) {
                fstPart = id.substring(0, dotIdx);
                sndPart = id.substring(dotIdx + ".".length(), id.length());
            }
            relativeParent = context.getCurrent();
            relativeId = id;
            if (!fstPart.startsWith("$")) break block33;
            relativeId = sndPart;
            switch (fstPart) {
                case "$parent": {
                    relativeParent = context.getParent();
                    break;
                }
                case "$this": {
                    relativeParent = context.getCurrent();
                    break;
                }
                case "$configSet": {
                    relativeParent = context.getConfigSetConfig();
                    break;
                }
                case "$instance": {
                    relativeParent = context.getComponentInstanceConfig();
                    break;
                }
                case "$global": {
                    ComponentConfig componentConfig = context.getComponentConfig();
                    relativeParent = componentConfig != null ? componentConfig.getGlobalConfigSet() : null;
                    break;
                }
                case "$component": {
                    relativeParent = context.getComponentConfig();
                    break;
                }
                case "$group": {
                    relativeParent = context.getFunctionalGroup();
                    break;
                }
                case "$root": {
                    relativeParent = context.getProfile();
                    break;
                }
                case "$components": {
                    relativeParent = new ComponentsProvider(context.getProfile());
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if (relativeId.isEmpty()) {
            return relativeParent;
        }
        return relativeParent instanceof IChildProvidable ? ChildProviderHelper.getChildRelative((IChildProvidable)relativeParent, relativeId) : null;
    }

    public static boolean typesOfChildrenEquals(AStructuredSettingConfig left, StructConfig right) {
        List<String> leftPath = ChildProviderHelper.getTypesOfAllChildren(left);
        Iterator<String> leftPathIterator = leftPath.iterator();
        List<String> rightPath = ChildProviderHelper.getTypesOfAllChildren(right);
        Iterator<String> rightPathIterator = rightPath.iterator();
        while (leftPathIterator.hasNext() && rightPathIterator.hasNext()) {
            String rightItem;
            @Nullable String leftItem = leftPathIterator.next();
            if (Objects.equals(leftItem, rightItem = rightPathIterator.next())) continue;
            return false;
        }
        if (leftPathIterator.hasNext()) {
            return false;
        }
        return !rightPathIterator.hasNext();
    }

    public static List<ISettingConfig> getAllChildren(AStructuredSettingConfig node) {
        LinkedList<ISettingConfig> subPath = new LinkedList<ISettingConfig>();
        for (ISettingConfig iSettingConfig : node.getChildren()) {
            subPath.add(iSettingConfig);
            if (!(iSettingConfig instanceof AStructuredSettingConfig)) continue;
            List<ISettingConfig> childrenOfChild = ChildProviderHelper.getAllChildren((AStructuredSettingConfig)iSettingConfig);
            subPath.addAll(childrenOfChild);
        }
        return subPath;
    }

    public static List<String> getTypesOfAllChildren(AStructuredSettingConfig node) {
        LinkedList<String> subPath = new LinkedList<String>();
        for (ISettingConfig iSettingConfig : node.getChildren()) {
            subPath.add(UtilsText.safeString((String)iSettingConfig.getTypeName()));
            if (iSettingConfig instanceof ArrayConfig) {
                ArrayConfig arrayConfig = (ArrayConfig)iSettingConfig;
                subPath.add(arrayConfig.getTypeName());
                continue;
            }
            if (!(iSettingConfig instanceof AStructuredSettingConfig)) continue;
            List<ISettingConfig> childrenOfChild = ChildProviderHelper.getAllChildren((AStructuredSettingConfig)iSettingConfig);
            childrenOfChild.forEach(childOfChild -> {
                boolean bl = subPath.add(UtilsText.safeString((String)childOfChild.getTypeName()));
            });
        }
        return subPath;
    }
}

