/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import java.util.logging.Logger;

public class ChildContext
implements Cloneable {
    private static final Logger LOGGER = LogManager.getLogger(ChildContext.class);
    private PeriphsProfile profile;
    @Nullable
    private FunctionalGroup functionalGroup;
    @Nullable
    private ComponentConfig componentConfig;
    @Nullable
    private ComponentInstanceConfig componentInstanceConfig;
    @Nullable
    private ConfigSetConfig configSetConfig;
    @Nullable
    private IChildProvidable parent;
    private IChild current;

    public ChildContext(PeriphsProfile profile) {
        this.profile = profile;
        this.current = profile;
    }

    public @Nullable FunctionalGroup getFunctionalGroup() {
        return this.functionalGroup;
    }

    public void setFunctionalGroup(FunctionalGroup functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public @Nullable ComponentConfig getComponentConfig() {
        return this.componentConfig;
    }

    public void setComponentConfig(@Nullable ComponentConfig componentConfig) {
        this.componentConfig = componentConfig;
    }

    public @Nullable ComponentInstanceConfig getComponentInstanceConfig() {
        return this.componentInstanceConfig;
    }

    public void setComponentInstanceConfig(@Nullable ComponentInstanceConfig componentInstanceConfig) {
        this.componentInstanceConfig = componentInstanceConfig;
    }

    public @Nullable ConfigSetConfig getConfigSetConfig() {
        return this.configSetConfig;
    }

    public void setConfigSetConfig(@Nullable ConfigSetConfig configSetConfig) {
        this.configSetConfig = configSetConfig;
    }

    public @Nullable IChildProvidable getParent() {
        return this.parent;
    }

    public void setParent(@Nullable IChildProvidable parent) {
        this.parent = parent;
    }

    public IChild getCurrent() {
        return this.current;
    }

    public void setCurrent(IChild current) {
        this.current = current;
    }

    public PeriphsProfile getProfile() {
        return this.profile;
    }

    public void setProfile(PeriphsProfile profile) {
        this.profile = profile;
    }

    public ChildContext createForChild(IChild child) {
        ChildContext childContext = this.clone();
        if (!(childContext.current instanceof IChildProvidable)) {
            LOGGER.severe("Setting with id: " + this.current.getId() + " is trying to create a context for it's child with id: " + child.getId() + ", but it is not supposed to have children.");
        }
        childContext.parent = (IChildProvidable)this.current;
        childContext.current = child;
        return childContext;
    }

    protected ChildContext clone() {
        ChildContext clone = new ChildContext(this.profile);
        clone.functionalGroup = this.functionalGroup;
        clone.componentConfig = this.componentConfig;
        clone.componentInstanceConfig = this.componentInstanceConfig;
        clone.configSetConfig = this.configSetConfig;
        clone.parent = this.parent;
        clone.current = this.current;
        return clone;
    }
}

