/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.AStructuredSettingConfig;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.PeripheralExpressionException;
import com.nxp.swtools.periphs.model.config.QuickSelectionHelper;
import com.nxp.swtools.periphs.model.config.ScalarUtils;
import com.nxp.swtools.periphs.model.config.SettingConfigFactory;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ArraySetting;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.ItemDefaults;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayConfig
extends AStructuredSettingConfig {
    private static final String LAMBDA_FOR_KEY_EXPR = "Lambda function is required for key_expr";
    private final List<ISettingConfig> settings = new ArrayList<ISettingConfig>();
    private ISetting instanceSetting;

    protected ArrayConfig(String id, String name, ISetting setting, ChildContext parentContext, IMcu mcu) {
        super(id, name, setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsArraySetting(), parentContext, mcu);
        this.instanceSetting = ((ArraySetting)setting).getReferenceType();
    }

    public ISetting getInstanceSetting() {
        return this.instanceSetting;
    }

    @Override
    public void applyOther(ISettingConfig config) {
        if (!(config instanceof ArrayConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), ArrayConfig.class.getName()));
        }
        ArrayConfig array = (ArrayConfig)config;
        int i = 0;
        while (i < array.getChildren().size()) {
            ISettingConfig member = array.getValue(i);
            assert (member != null);
            String childName = member.getName();
            String childId = SettingUtils.buildId(this.id, childName);
            ISettingConfig settingConfig = this.getValue(i);
            if (settingConfig == null) {
                settingConfig = SettingConfigFactory.createSettingConfig(childId, childName, this.instanceSetting, this.childContext, this.mcu);
                this.settings.add(settingConfig);
                if (settingConfig.isStorable()) {
                    ((StoragePeriphsArraySetting)this.storageSetting).getSettings().add(settingConfig.getStorageSetting());
                }
            }
            ISettingConfig settingConfigFinal = settingConfig;
            settingConfig.setUiNameSupplier(() -> this.determineUiName(settingConfigFinal));
            settingConfig.applyOther(member);
            ++i;
        }
        if (this.settings.size() > array.settings.size()) {
            this.settings.subList(array.settings.size(), this.settings.size()).clear();
            ((StoragePeriphsArraySetting)this.storageSetting).getSettings().subList(array.settings.size(), this.settings.size()).clear();
        }
    }

    @Override
    public void applyQuickSelection(@Nullable QuickSelection quickSelection, IChild relativeTo) {
        this.settings.clear();
        ((StoragePeriphsArraySetting)this.storageSetting).getSettings().clear();
        this.updateStorageAvailability();
        if (!this.applyQuickSelectionFromResource(quickSelection, relativeTo)) {
            String quickSelectionId = QuickSelectionHelper.getQuickSelectionId(this, relativeTo);
            String idWithSeparator = quickSelectionId.isEmpty() ? "" : String.valueOf(quickSelectionId) + ".";
            ArrayList<String> configQuickSelIds = new ArrayList<String>();
            if (quickSelection != null) {
                for (QuickSetting sett : quickSelection.getSettings()) {
                    if (!sett.getId().startsWith(idWithSeparator)) continue;
                    configQuickSelIds.add(sett.getId());
                }
            }
            int length = 0;
            for (String cfgQsId : configQuickSelIds) {
                String sndPart = cfgQsId.substring(idWithSeparator.length(), cfgQsId.length());
                int idxOfDot = sndPart.indexOf(".");
                String numberPart = idxOfDot >= 0 ? sndPart.substring(0, idxOfDot) : sndPart;
                try {
                    int number = Integer.parseInt(numberPart);
                    length = Math.max(length, number + 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int i = 0;
            while (i < length) {
                ISettingConfig settingConfig = this.addNewItem();
                settingConfig.applyQuickSelection(quickSelection, relativeTo);
                ++i;
            }
        }
    }

    protected ArrayConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsArraySetting storageSetting, IMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsStructuredSetting)storageSetting, parentContext, mcu);
        this.instanceSetting = ((ArraySetting)setting).getReferenceType();
        for (AStoragePeriphsSetting storageChildSetting : storageSetting.getSettings()) {
            String childName = UtilsText.safeString((String)Integer.toString(this.settings.size()));
            String childId = SettingUtils.buildId(id, childName);
            ISettingConfig settingConfig = SettingConfigFactory.createSettingConfig(childId, this.instanceSetting, this.childContext, storageChildSetting, mcu);
            settingConfig.setUiNameSupplier(() -> this.determineUiName(settingConfig));
            this.settings.add(settingConfig);
        }
    }

    @Override
    public ArrayConfig getValue() {
        return this;
    }

    public @Nullable ISettingConfig getValue(int idx) {
        if (idx < 0 || idx >= this.settings.size()) {
            return null;
        }
        return this.settings.get(idx);
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        try {
            Integer intId = Integer.valueOf(childName);
            return this.getValue(intId);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public List<ISettingConfig> getChildren() {
        return CollectionsUtils.unmodifiableList(this.settings);
    }

    public ISettingConfig addNewItem() {
        String childName = UtilsText.safeString((String)Integer.toString(this.settings.size()));
        String childId = SettingUtils.buildId(this.id, childName);
        ISettingConfig settingConfig = SettingConfigFactory.createSettingConfig(childId, childName, this.instanceSetting, this.childContext, this.mcu);
        settingConfig.setUiNameSupplier(() -> this.determineUiName(settingConfig));
        this.settings.add(settingConfig);
        this.applyItemDefaults(settingConfig);
        if (settingConfig.isStorable()) {
            ((StoragePeriphsArraySetting)this.storageSetting).getSettings().add(settingConfig.getStorageSetting());
        }
        return settingConfig;
    }

    public void applyItemDefaults(ISettingConfig settingConfig) {
        ArraySetting arraySetting = this.getModelData();
        ItemDefaults itemDefaults = arraySetting.getItemDefaults();
        if (itemDefaults != null) {
            String quickSelectionId = SettingUtils.buildId(settingConfig.getName(), "item_defaults_to_quick_selection");
            QuickSelection quickSelection = new QuickSelection(quickSelectionId, null, null, null, null);
            Set<Map.Entry<String, ItemDefaults.SetDefault>> setDefaultsEntrySet = itemDefaults.getDefaults().entrySet();
            for (Map.Entry<String, ItemDefaults.SetDefault> entry : setDefaultsEntrySet) {
                Expression valueExpr = entry.getValue().getValueExpr();
                if (valueExpr == null) continue;
                String relativeId = QuickSelectionHelper.getQuickSelectionId(settingConfig, this);
                String key = UtilsText.safeString((String)entry.getKey());
                if (!UtilsText.isEmpty((String)key)) {
                    relativeId = SettingUtils.buildId(relativeId, key);
                }
                try {
                    IValue lambdaValue = valueExpr.resolve(this.expressionContext);
                    IFunction functionReference = lambdaValue.getFunctionReference();
                    IValue resolvedValue = functionReference.invokeOn(this.expressionContext, new Object[]{settingConfig});
                    if (resolvedValue.getValue() instanceof ISettingConfig) {
                        Expression fakeExpression = Expression.createConstant((IValue)resolvedValue);
                        QuickSetting quickSetting = new QuickSetting(relativeId, null, null);
                        quickSetting.setResourceExpr(fakeExpression);
                        quickSelection.addSetting(quickSetting);
                        continue;
                    }
                    quickSelection.addSetting(new QuickSetting(relativeId, null, resolvedValue.getString()));
                }
                catch (ExpressionException e) {
                    e.log();
                }
            }
            settingConfig.applyQuickSelection(quickSelection, this);
        }
        settingConfig.initValue();
    }

    @Override
    public ArraySetting getModelData() {
        return (ArraySetting)super.getModelData();
    }

    public @Nullable ISettingConfig getSettingByKey(String key, IContext argContext) {
        Expression keyExpr = ((ArraySetting)this.setting).getKeySelector();
        if (keyExpr != null) {
            for (ISettingConfig member : this.settings) {
                String result = CacheHelper.getValueCaching(this, String.valueOf(member.getId()) + "*key_selector_expr", () -> {
                    try {
                        return keyExpr.resolve(argContext).getFunctionReference().invokeOn(member.getExpressionContext(), new Object[]{member}).getString();
                    }
                    catch (ExpressionException e) {
                        throw new PeripheralExpressionException(LAMBDA_FOR_KEY_EXPR, e, ArrayConfig.class);
                    }
                });
                if (!key.equals(result)) continue;
                return member;
            }
        }
        return null;
    }

    public boolean settingWithKeyExists(String key, IContext argContext) {
        return this.getSettingByKey(key, argContext) != null;
    }

    public @Nullable String getSettingKey(ISettingConfig member, IContext argContext) {
        assert (this.settings.contains(member));
        Expression keyExpr = ((ArraySetting)this.setting).getKeySelector();
        if (keyExpr != null) {
            return CacheHelper.getValueCaching(this, String.valueOf(member.getId()) + "*key_selector_expr", () -> {
                try {
                    return keyExpr.resolve(argContext).getFunctionReference().invokeOn(member.getExpressionContext(), new Object[]{member}).getString();
                }
                catch (ExpressionException e) {
                    throw new PeripheralExpressionException(LAMBDA_FOR_KEY_EXPR, e, ArrayConfig.class);
                }
            });
        }
        return null;
    }

    public StoragePeriphsArraySetting getStorageSetting() {
        return (StoragePeriphsArraySetting)this.storageSetting;
    }

    public boolean moveFront(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index <= 0) {
            return false;
        }
        this.swapSettings(index, index - 1);
        this.updateChildren();
        return true;
    }

    public boolean moveBack(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index >= this.settings.size() - 1) {
            return false;
        }
        this.swapSettings(index, index + 1);
        this.updateChildren();
        return true;
    }

    public boolean moveBeginning(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index <= 0) {
            return false;
        }
        this.settings.add(0, this.settings.remove(index));
        this.updateChildren();
        return true;
    }

    public boolean moveEnd(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index < 0 || index >= this.settings.size() - 1) {
            return false;
        }
        this.settings.add(this.settings.size() - 1, this.settings.remove(index));
        this.updateChildren();
        return true;
    }

    private void swapSettings(int index1, int index2) {
        ISettingConfig sett1 = this.settings.get(index1);
        ISettingConfig sett2 = this.settings.get(index2);
        this.settings.set(index2, sett1);
        this.settings.set(index1, sett2);
    }

    public boolean remove(ISettingConfig childSetting) {
        boolean result = this.settings.remove(childSetting);
        if (result) {
            this.updateChildren();
        }
        return result;
    }

    private void updateChildren() {
        int i = 0;
        while (i < this.settings.size()) {
            ISettingConfig config = this.settings.get(i);
            if (!config.getName().equals(Integer.toString(i))) {
                config.setName(UtilsText.safeString((String)Integer.toString(i)));
                String childId = SettingUtils.buildId(this.id, config.getName());
                config.setId(childId);
            }
            config.setUiNameSupplier(() -> this.determineUiName(config));
            ++i;
        }
        ArrayList storageSettings = ((StoragePeriphsArraySetting)this.storageSetting).getSettings();
        storageSettings.clear();
        this.settings.stream().filter(x -> x.isStorable()).forEach(x -> {
            boolean bl = storageSettings.add(x.getStorageSetting());
        });
    }

    public void updateSize() {
        block4: {
            boolean adding;
            Expression sizeExpression = this.getModelData().getSizeExpr();
            if (sizeExpression == null) break block4;
            long diff = sizeExpression.resolve(this.getExpressionContext()).getLong() - (long)this.settings.size();
            long size = Math.abs(diff);
            boolean bl = adding = diff > 0L;
            if (adding) {
                long i = 0L;
                while (i < size) {
                    this.addNewItem();
                    ++i;
                }
            } else {
                long i = 0L;
                while (i < size) {
                    this.remove(this.settings.get(this.settings.size() - 1));
                    ++i;
                }
            }
        }
    }

    @Override
    public @NonNull String getTypeName() {
        return "array";
    }

    private String determineUiName(ISettingConfig config) {
        String key = this.getSettingKey(config, this.getExpressionContext());
        return key != null ? key : config.getName();
    }

    @Override
    public void setDefaultValue() {
        for (ISettingConfig child : this.getChildren()) {
            child.setDefaultValue();
        }
    }

    public boolean canAddItem() {
        return !ScalarUtils.isAfterRange((ASettingConfig)this, this.getChildren().size() + 1);
    }

    public boolean canRemoveItem() {
        return !ScalarUtils.isBeforeRange((ASettingConfig)this, this.getChildren().size() - 1);
    }
}

