/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ChildStorageHelper;
import com.nxp.swtools.periphs.model.config.ChildValidationHelper;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.IStructuredSettingConfig;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import java.util.List;

public abstract class AStructuredSettingConfig
extends ASettingConfig
implements IStructuredSettingConfig {
    protected AStructuredSettingConfig(String id, String name, ISetting setting, AStoragePeriphsStructuredSetting storageSetting, ChildContext parentContext, IMcu mcu) {
        super(id, name, setting, (AStoragePeriphsSetting)storageSetting, parentContext, mcu);
    }

    @Override
    public @Nullable IChild getChildById(String childId) {
        return ChildProviderHelper.getChildRelative(this, childId);
    }

    protected String createChildId(String childName) {
        return SettingUtils.buildId(this.id, childName);
    }

    @Override
    public @Nullable String getNestedProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*nested_problems*" + (Object)((Object)level), () -> ChildValidationHelper.getChildrenProblemsWithPrefix(this, level));
    }

    @Override
    public @Nullable String getProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems*" + (Object)((Object)level), () -> IStructuredSettingConfig.super.getProblems(level));
    }

    @Override
    public List<String> getProblemsPaths(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems_paths*" + (Object)((Object)level), () -> IStructuredSettingConfig.super.getProblemsPaths(level));
    }

    public abstract List<? extends ISettingConfig> getChildren();

    @Override
    public void setId(String id) {
        super.setId(id);
        for (ISettingConfig iSettingConfig : this.getChildren()) {
            iSettingConfig.setId(SettingUtils.buildId(id, iSettingConfig.getName()));
        }
    }

    public AStoragePeriphsStructuredSetting getStorageSetting() {
        return (AStoragePeriphsStructuredSetting)this.storageSetting;
    }

    @Override
    public void updateStorageAvailability() {
        ChildStorageHelper.updateStorageAvialability(this.getStorageSetting().getSettings(), this.getChildren());
    }

    @Override
    public void initValue() {
        for (ISettingConfig iSettingConfig : this.getChildren()) {
            iSettingConfig.initValue();
        }
    }

    @Override
    public void deInitialize() {
        this.getChildren().forEach(x -> x.deInitialize());
    }
}

