/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildValidationHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.ICacheable;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.QuickSelectionHelper;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;

public abstract class ASettingConfig
implements ISettingConfig,
ICacheable {
    private static final String SETTING_WITH_ID = " >>> Setting with id: ";
    private static final String COMPONENT_COMMA = "Component: ";
    protected static final Logger LOGGER = LogManager.getLogger(ASettingConfig.class);
    protected String id;
    protected String name;
    protected final ISetting setting;
    protected final IMcu mcu;
    protected final ChildContext childContext;
    protected final IContext expressionContext;
    protected final AStoragePeriphsSetting storageSetting;
    protected Supplier<String> uiNameSupplier;

    protected ASettingConfig(String id, String name, ISetting setting, AStoragePeriphsSetting storageSetting, ChildContext parentContext, IMcu mcu) {
        this.id = id;
        this.name = name;
        this.mcu = mcu;
        this.setting = setting;
        this.storageSetting = storageSetting;
        this.storageSetting.setName(name);
        this.childContext = parentContext.createForChild(this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.uiNameSupplier = () -> setting.getUIName(this.expressionContext);
    }

    protected boolean applyQuickSelectionFromResource(@Nullable QuickSelection quickSelection, IChild relativeTo) {
        Expression resource;
        QuickSetting setToUse = QuickSelectionHelper.getQuickSelection(quickSelection, this, relativeTo);
        if (setToUse != null && (resource = setToUse.getResourceExpr()) != null) {
            ISettingConfig config = (ISettingConfig)resource.resolve(this.getExpressionContext()).getValue();
            this.applyOther(config);
            return true;
        }
        return false;
    }

    protected String getComponentName() {
        ComponentConfig componentConfig = this.getChildContext().getComponentConfig();
        return componentConfig != null ? componentConfig.getName() : "";
    }

    protected String getLogHeader() {
        return COMPONENT_COMMA + this.getComponentName() + SETTING_WITH_ID + this.getId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.setting.isOptionSet(option);
    }

    @Override
    public @Nullable Object getOptionValue(String option) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*option_value*" + option, () -> this.setting.getOptionValue(option, this.getExpressionContext()));
    }

    @Override
    public ISetting getModelData() {
        return this.setting;
    }

    @Override
    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public boolean isAvailable() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*available", () -> {
            IChildProvidable parent = this.childContext.getParent();
            return this.setting.isAvailable(this.expressionContext) && (parent == null || parent.isAvailable());
        });
    }

    @Override
    public boolean isEnabled() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*enabled", () -> {
            IChildProvidable parent = this.childContext.getParent();
            return this.setting.isEnabled(this.expressionContext) && (parent == null || parent.isEnabled());
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUiName() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*ui_name", this.uiNameSupplier);
    }

    public @Nullable String getDescription() {
        return this.setting.getResolvedDescription(this.expressionContext);
    }

    public @Nullable String getState() {
        if (!this.isEnabled()) {
            return Messages.get().ASettingConfig_Inactive;
        }
        return null;
    }

    public @Nullable String getStateDescription() {
        if (!this.isEnabled()) {
            return Messages.get().ASettingConfig_SettingIsInactive;
        }
        return null;
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    @Override
    public IDependency @Nullable [] getOwnDependencies(String source) {
        if (this.isAvailable() && this.isEnabled()) {
            return ChildValidationHelper.getDependencies(this.setting.getValidation(), this.getExpressionContext(), source, this.makeOriginatorId(this.childContext));
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.storageSetting.setName(name);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setUiNameSupplier(Supplier<String> supplier) {
        this.uiNameSupplier = supplier;
    }

    @Override
    public @Nullable String getError() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*error", () -> this.getProblems(Level.ERROR));
    }

    @Override
    public @Nullable String getWarning() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*warning", () -> this.getProblems(Level.WARNING));
    }

    @Override
    public @Nullable String getInfo() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*info", () -> this.getProblems(Level.INFO));
    }

    @Override
    public @Nullable String getProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems*" + (Object)((Object)level), () -> ISettingConfig.super.getProblems(level));
    }

    @Override
    public String @Nullable [] getOwnProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*own_problems*" + (Object)((Object)level), () -> ISettingConfig.super.getOwnProblems(level));
    }

    @Override
    public List<String> getProblemsPaths(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems_paths*" + (Object)((Object)level), () -> ISettingConfig.super.getProblemsPaths(level));
    }

    @Override
    public Map<String, Object> getCache() {
        ConfigSetConfig configSetConfig = this.childContext.getConfigSetConfig();
        if (configSetConfig != null) {
            return configSetConfig.getCache();
        }
        return new HashMap<String, Object>();
    }

    public String toString() {
        return "Setting: [Type: " + this.getTypeName() + ", Id: " + this.getId() + "]";
    }
}

