/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apukernel.design;

import com.nxp.s32ds.ext.emf.common.util.DiagnosticAttachment;
import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortAttributesInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortElementsInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfos;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortSpatialDepInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.gte.apukernel.ApuPortType;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;

public class ApuKernelServices {
    public List<ApuKernelPortInfo> getInPorts(ApuKernelInfo info) {
        return info.getPortInfos().stream().filter(port -> ApuPortType.ATTR_IN.equals((Object)port.getPortAttrbutesInfo().getPortType())).collect(Collectors.toList());
    }

    public List<ApuKernelPortInfo> getOutPorts(ApuKernelInfo info) {
        return info.getPortInfos().stream().filter(port -> ApuPortType.ATTR_OUT.equals((Object)port.getPortAttrbutesInfo().getPortType())).collect(Collectors.toList());
    }

    public List<ApuKernelPortInfo> getAllOutPorts(ApuKernelSource source) {
        return source.getKernelInfos().stream().flatMap(kernel -> kernel.getPortInfos().stream()).filter(port -> port.getPortAttrbutesInfo().getPortType().equals((Object)ApuPortType.ATTR_OUT)).collect(Collectors.toList());
    }

    public List<ApuKernelPortInfo> getAllInPorts(ApuKernelSource source) {
        return source.getKernelInfos().stream().flatMap(kernel -> kernel.getPortInfos().stream()).filter(port -> port.getPortAttrbutesInfo().getPortType().equals((Object)ApuPortType.ATTR_IN)).collect(Collectors.toList());
    }

    private String spatialDepToLable(ApuKernelPortSpatialDepInfo spatialDep) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("sp").append("(").append(spatialDep.getSpatialDepLeft()).append(",").append(spatialDep.getSpatialDepRight()).append(",").append(spatialDep.getSpatialDepTop()).append(",").append(spatialDep.getSpatialDepBottom()).append(")");
        return buffer.toString();
    }

    private String eParametrsToLable(ApuKernelPortElementsInfo elements) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(elements.getE0DataType()).append(" ").append(elements.getE0SizeX()).append(",").append(elements.getE0SizeY()).append(" ").append("[").append(elements.getEKSizeX()).append(",").append(elements.getEKSizeY()).append("]");
        return buffer.toString();
    }

    private String attributesToLable(ApuKernelPortAttributesInfo attributes) {
        return ApuKernelPortInfos.getAttributesDefine((Object)attributes);
    }

    public String getPortToolTip(ApuKernelPortInfo info) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(info.getName()).append(System.lineSeparator()).append(this.eParametrsToLable(info.getPortElementsInfo())).append(System.lineSeparator()).append(this.spatialDepToLable(info.getPortSpatialDepInfo())).append(System.lineSeparator()).append(this.attributesToLable(info.getPortAttrbutesInfo()));
        return buffer.toString();
    }

    public Boolean hasError(EObject eObj) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
        DiagnosticAttachment.attach((EObject)eObj, (Diagnostic)diagnostic);
        if (diagnostic.getSeverity() == 4) {
            return true;
        }
        return false;
    }

    public boolean cool(EObject eObject) {
        return true;
    }

    public String getKernelToolTip(ApuKernelInfo apuKernelInfo) {
        StringBuilder builder = new StringBuilder();
        builder.append(apuKernelInfo.getName()).append(System.lineSeparator());
        StringJoiner outJoiner = new StringJoiner(",");
        for (ApuKernelPortInfo apuKernelPortInfo : this.getOutPorts(apuKernelInfo)) {
            outJoiner.add(apuKernelPortInfo.getName());
        }
        builder.append(outJoiner.toString());
        builder.append(System.lineSeparator());
        StringJoiner inJoiner = new StringJoiner(",");
        for (ApuKernelPortInfo apuKernelPortInfo : this.getInPorts(apuKernelInfo)) {
            inJoiner.add(apuKernelPortInfo.getName());
        }
        builder.append(inJoiner.toString());
        return builder.toString();
    }

    public String createKernelName(ApuKernelInfo kernel) {
        String pattern = String.valueOf(ApuUsages.getNameWithoutPostfix((String)kernel.getName())) + "{0}";
        List list = kernel.getSource().getKernelInfos().stream().map(ApuKernelInfo::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public String createPortName(ApuKernelPortInfo portInfo) {
        String pattern = String.valueOf(ApuUsages.getNameWithoutPostfix((String)portInfo.getName())) + "{0}";
        List list = portInfo.getKernelInfo().getPortInfos().stream().map(ApuKernelPortInfo::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public EObject pasteKernel(EObject context, EObject copiedElement, EObject container) {
        return this.pasteCopiedElementWithNamePostfix(copiedElement, container);
    }

    private EObject pasteCopiedElementWithNamePostfix(EObject copiedElement, EObject container) {
        if (container instanceof ApuKernelSource && copiedElement instanceof ApuKernelInfo) {
            ApuKernelSource kernelSource = (ApuKernelSource)container;
            ApuKernelInfo copiedKern = (ApuKernelInfo)copiedElement;
            copiedKern.setSource(kernelSource);
            copiedKern.setName(this.createKernelName(copiedKern));
            kernelSource.getKernelInfos().add((Object)copiedKern);
            return kernelSource;
        }
        if (container instanceof ApuKernelInfo && copiedElement instanceof ApuKernelPortInfo) {
            ApuKernelInfo kernInfo = (ApuKernelInfo)container;
            ApuKernelPortInfo copiedPort = (ApuKernelPortInfo)copiedElement;
            copiedPort.setKernelInfo(kernInfo);
            copiedPort.setName(this.createPortName(copiedPort));
            kernInfo.getPortInfos().add((Object)copiedPort);
            return kernInfo;
        }
        return null;
    }
}

