/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.sections;

import com.freescale.s32ds.debug.ka.freertos.view.AbstractFreeRTOSView;
import com.freescale.system.browser.model.OSAwarenessData;
import com.freescale.system.browser.ui.AbstractSection;
import com.freescale.system.browser.ui.TabbedWidgetFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;

public abstract class AbstractFreeRTOSSection
extends AbstractSection
implements IDebugContextListener {
    protected StackLayout m_stackLayout;
    protected Composite m_stackPanel;
    protected Object m_input;
    protected Map<IProcess, AbstractFreeRTOSView> m_procToView = new HashMap<IProcess, AbstractFreeRTOSView>();

    public AbstractFreeRTOSSection() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public void createControls(Composite parent, Page page) {
        super.createControls(parent, page);
        TabbedWidgetFactory widgetFactory = this.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        final Color fborderColor = Display.getCurrent().getSystemColor(18);
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite composite = (Composite)e.widget;
                Rectangle b = composite.getClientArea();
                GC gc = e.gc;
                gc.setForeground(fborderColor);
                gc.drawRectangle(b.x + 5 - 1, b.y + 4, b.width - 10 + 1, b.height - 8);
            }
        });
        this.m_stackPanel = new Composite(composite, 0);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 2);
        fd.top = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, 0);
        this.m_stackPanel.setLayoutData((Object)fd);
        this.m_stackLayout = new StackLayout();
        this.m_stackLayout.topControl = null;
        this.m_stackPanel.setLayout((Layout)this.m_stackLayout);
    }

    public void setSectionInput(OSAwarenessData input) {
        if ((input instanceof IThread || input instanceof IStackFrame) && input != this.m_input) {
            boolean cfr_ignored_0 = input instanceof IStackFrame;
            IThread newInput = (IThread)input;
            if (newInput != null) {
                IProcess process;
                this.m_input = input;
                IDebugTarget dbgTgt = newInput.getDebugTarget();
                if (dbgTgt != null && (process = dbgTgt.getProcess()) != null) {
                    AbstractFreeRTOSView view = this.m_procToView.get(process);
                    if (view == null) {
                        view = this.createFreeRTOSView(this.m_stackPanel, 0);
                        this.m_procToView.put(process, view);
                    } else {
                        view.updateView();
                    }
                    if (this.m_stackLayout.topControl != view) {
                        if (this.m_stackLayout.topControl != null && !this.m_stackLayout.topControl.isDisposed()) {
                            this.m_stackLayout.topControl.setVisible(false);
                        }
                        this.m_stackLayout.topControl = view;
                        view.setVisible(true);
                        this.m_stackPanel.layout(false);
                    }
                }
            }
        }
    }

    public Object getSectionInput() {
        return this.m_input;
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
    }

    public void setActionBarsForTab(IActionBars actionBars) {
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        super.refresh();
        if (this.m_stackLayout.topControl != null && !this.m_stackLayout.topControl.isDisposed()) {
            ((AbstractFreeRTOSView)this.m_stackLayout.topControl).updateView();
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        AbstractFreeRTOSView view;
        IProcess process = DebugUITools.getCurrentProcess();
        if (process != null && process.isTerminated() && (view = this.m_procToView.get(process)) != null) {
            this.m_procToView.remove(process);
            view.dispose();
            Object var3_3 = null;
        }
    }

    protected abstract AbstractFreeRTOSView createFreeRTOSView(Composite var1, int var2);
}

