/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.IOSTask;
import com.freescale.s32ds.debug.ka.freertos.model.NumericalData;
import com.freescale.s32ds.debug.ka.freertos.model.OSData;
import com.freescale.s32ds.debug.ka.freertos.model.OSDataStructure;
import com.freescale.s32ds.debug.ka.freertos.model.TaskEventData;
import com.freescale.s32ds.debug.ka.freertos.model.TaskNameData;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class TCB
extends OSDataStructure
implements IOSTask {
    private IRunControl.IExecutionDMContext context;
    private IStoreManager storeManager;
    private boolean bIsCurrentTCB = false;
    private boolean bIsBlockedOnObject = false;
    private List<String> invalidIndexes = new LinkedList<String>();

    public TCB(IRunControl.IExecutionDMContext context, long lAddressIn, boolean bStackCheckingOn, IStoreManager storeManager) {
        this.context = context;
        this.storeManager = storeManager;
        this.lAddress = lAddressIn;
        this.bValid = true;
        this.sStructureStartQueryString = "pxCurrentTCB";
        this.sStructureSizeQueryString = "sizeof(*pxCurrentTCB)";
        this.sStructureMemberQueryString = "&(pxCurrentTCB->";
        this.data.put("name", new TaskNameData(context, "${tasks.c}pcTaskName", storeManager));
        this.data.put("state", new OSData(context, "${tasks.c}xGenericListItem.pvContainer", storeManager));
        this.data.put("priority", new NumericalData(context, "${tasks.c}uxPriority", storeManager));
        this.data.put("basePriority", new NumericalData(context, "${tasks.c}uxBasePriority", storeManager));
        this.data.put("stackStart", new OSData(context, "${tasks.c}pxStack", storeManager));
        this.data.put("stackTop", new OSData(context, "${tasks.c}pxTopOfStack", storeManager));
        this.data.put("event", new TaskEventData(context, "${tasks.c}xEventListItem.pvContainer", storeManager));
        this.prvObtainStructure(context, this.invalidIndexes);
    }

    @Override
    public String getTaskName() {
        return ((OSData)this.data.get("name")).getValue();
    }

    @Override
    public String getTaskPriority() {
        String sReturn = "Unknown";
        sReturn = ((OSData)this.data.get("priority")).getValue();
        if (((OSData)this.data.get("basePriority")).getOffsetIntoStruct() < 0) {
            return sReturn;
        }
        sReturn = String.valueOf(((OSData)this.data.get("basePriority")).getValue()) + "/" + sReturn;
        return sReturn;
    }

    @Override
    public String getTaskState() {
        String state;
        String value = ((OSData)this.data.get("state")).getValue();
        if (this.bIsCurrentTCB) {
            state = "RUNNING";
        } else if (value.equalsIgnoreCase("")) {
            state = "Not known";
        } else {
            state = this.storeManager.getTaskStore(this.context).sGetStateFromListAddress(Long.decode(value));
            if (state == "SUSPENDED" && this.bIsBlockedOnObject) {
                state = "BLOCKED";
            } else if (state == "BLOCKED" && !this.bIsBlockedOnObject) {
                state = "DELAYING";
            }
        }
        return state;
    }

    @Override
    public String getTaskStackStart() {
        return ((OSData)this.data.get("stackStart")).getValue();
    }

    @Override
    public String getTaskStackTop() {
        return ((OSData)this.data.get("stackTop")).getValue();
    }

    @Override
    public String getTaskEvent() {
        return ((OSData)this.data.get("event")).getValue();
    }

    public void setMemberValues(String sData, long lCurrentTCB) {
        long lFinalAddress = this.lAddress;
        for (OSData value : this.data.values()) {
            value.saveValue();
        }
        this.bIsCurrentTCB = false;
        if (!sData.equals(this.sRawBytes) || lCurrentTCB == lFinalAddress) {
            this.sRawBytes = sData;
            for (OSData value : this.data.values()) {
                if (value.getOffsetIntoStruct() < 0) continue;
                value.setValue(sData);
            }
            if (lCurrentTCB == lFinalAddress) {
                this.bIsCurrentTCB = true;
                this.sRawBytes = String.valueOf(this.sRawBytes) + ",";
            } else {
                this.bIsCurrentTCB = false;
            }
            this.bIsBlockedOnObject = !((OSData)this.data.get("event")).getValue().equals("0x00000000");
        }
    }

    @Override
    public boolean isCurrentTask() {
        return this.bIsCurrentTCB;
    }
}

