/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.NumericalData;
import com.freescale.s32ds.debug.ka.freertos.model.OSData;
import com.freescale.s32ds.debug.ka.freertos.model.OSDataStructure;
import com.freescale.s32ds.debug.ka.freertos.model.StringPointerData;
import com.freescale.s32ds.debug.ka.freertos.model.TimerAutoReloadData;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class RTOSTimer
extends OSDataStructure {
    private List<String> invalidIndexes = new LinkedList<String>();

    public RTOSTimer(IRunControl.IExecutionDMContext context, long lAddressIn, IStoreManager storeManager) {
        this.lAddress = lAddressIn;
        this.bValid = true;
        this.sStructureStartQueryString = "((xTIMER*)pxCurrentTCB)";
        this.sStructureSizeQueryString = "sizeof(xTIMER)";
        this.sStructureMemberQueryString = "&(((xTIMER*)pxCurrentTCB)->";
        this.data.put("name", new StringPointerData(context, "pcTimerName", storeManager));
        this.data.put("period", new NumericalData(context, "xTimerPeriodInTicks", storeManager));
        this.data.put("reload", new TimerAutoReloadData(context, "uxAutoReload", storeManager));
        this.data.put("callback", new TimerAutoReloadData(context, "pxCallbackFunction", storeManager));
        this.data.put("id", new TimerAutoReloadData(context, "pvTimerID", storeManager));
        this.prvObtainStructure(context, this.invalidIndexes);
    }

    public String getTimerName() {
        return ((OSData)this.data.get("name")).getValue();
    }

    public String getTimerPeriod() {
        return ((OSData)this.data.get("period")).getValue();
    }

    public String getTimerReloadValue() {
        return ((OSData)this.data.get("reload")).getValue();
    }

    public String getTimerCallbackFunction() {
        return ((OSData)this.data.get("callback")).getValue();
    }

    public String getTimerID() {
        return ((OSData)this.data.get("id")).getValue();
    }
}

