/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.OSData;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class QueueTypeData
extends OSData {
    private static final String[] sQueueType = new String[]{"Queue", "Mutex", "CntSem", "BinSem", "RcrMtx"};

    public QueueTypeData(IRunControl.IExecutionDMContext context, String name, IStoreManager storeManager) {
        super(context, name, storeManager);
    }

    @Override
    public boolean setValue(String sValueList) {
        this.saveValue();
        if (this.sValue == "" && this.iOffsetIntoStruct != -1) {
            int iValueLocation = this.iOffsetIntoStruct / 4;
            iValueLocation *= 11;
            if (this.storeManager.isBigEndian(this.context)) {
                int offsetBigEndian = iValueLocation + this.iOffsetIntoStruct % 4 * 2 + 2;
                int queueTypeBigEndian = Integer.parseInt(sValueList.substring(offsetBigEndian, offsetBigEndian + 2), 16);
                this.sValue = this.prvGetQueueTypeName(queueTypeBigEndian);
            } else {
                int offset = iValueLocation + (4 - this.iOffsetIntoStruct % 4 - 1) * 2 + 2;
                int queueType = Integer.parseInt(sValueList.substring(offset, offset + 2), 16);
                this.sValue = this.prvGetQueueTypeName(queueType);
            }
        }
        return !this.sOriginal.equals(this.sValue);
    }

    protected String prvGetQueueTypeName(int iQueueType) {
        return iQueueType < sQueueType.length ? sQueueType[iQueueType] : "";
    }
}

