/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.model.OSData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public abstract class OSDataStructure {
    protected static final int INVALID_OFFSET = -1;
    protected long lAddress = 0L;
    protected boolean bValid = false;
    protected String sRawBytes = "";
    protected Map<String, OSData> data = new HashMap<String, OSData>();
    protected String sStructureStartQueryString;
    protected String sStructureSizeQueryString;
    protected String sStructureMemberQueryString;
    protected int iStructSizeBytes = -1;

    public void prvObtainStructure(IRunControl.IExecutionDMContext context, List<String> invalidIndexes) {
        long lCurrentStructAddress = 0L;
        try {
            lCurrentStructAddress = DSFInterface.getDefault().lEvaluateExpression(context, this.sStructureStartQueryString);
            this.iStructSizeBytes = DSFInterface.getDefault().iEvaluateExpression(context, this.sStructureSizeQueryString);
            for (String key : this.data.keySet()) {
                OSData abstractOSData = this.data.get(key);
                if (invalidIndexes.contains(key)) {
                    abstractOSData.setOffset(-1);
                    continue;
                }
                try {
                    String sNameInStruct = abstractOSData.getDataItemName();
                    if (sNameInStruct.length() == 0) {
                        abstractOSData.setOffset(-1);
                        invalidIndexes.add(key);
                        continue;
                    }
                    long lReturned = DSFInterface.getDefault().lEvaluateExpression(context, String.valueOf(this.sStructureMemberQueryString) + sNameInStruct + ")");
                    long lOffset = lReturned - lCurrentStructAddress;
                    abstractOSData.setOffset((int)lOffset);
                }
                catch (NumberFormatException numberFormatException) {
                    abstractOSData.setOffset(-1);
                    invalidIndexes.add(key);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Unable to establish OSDataStructure size.");
        }
        catch (ExecutionException executionException) {
            System.err.println("Unable establish OSDataStructure structure.");
        }
    }

    public long getAddress() {
        return this.lAddress;
    }

    public long getSize() {
        return this.iStructSizeBytes;
    }

    public void vSetValid(boolean bValue) {
        this.bValid = bValue;
    }

    public boolean getIsValid() {
        return this.bValid;
    }

    public void setMemberValues(String sData) {
        if (!sData.equals(this.sRawBytes)) {
            this.sRawBytes = sData;
            for (OSData value : this.data.values()) {
                value.setValue(sData);
            }
        }
    }
}

