/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.IOSData;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class OSData
implements IOSData {
    private String sItemName;
    protected boolean bUpdateRequired = true;
    protected String sValue;
    protected String sOriginal;
    protected int iOffsetIntoStruct;
    protected IRunControl.IExecutionDMContext context;
    protected IStoreManager storeManager;

    public OSData(IRunControl.IExecutionDMContext context, String name, IStoreManager storeManager) {
        this.sItemName = name;
        this.iOffsetIntoStruct = -1;
        this.sValue = "";
        this.context = context;
        this.storeManager = storeManager;
    }

    protected static String sSwapHexWord(String input) {
        return String.valueOf(input.substring(0, 2)) + input.substring(8, 10) + input.substring(6, 8) + input.substring(4, 6) + input.substring(2, 4);
    }

    public static String sReadStringFromBufferBigEndian(String sValueList) {
        String sReturn = "";
        byte[] cChars = new byte[sValueList.length()];
        int i = 0;
        int iWordIndex = 0;
        boolean done = false;
        do {
            String sWord = sValueList.substring(iWordIndex, iWordIndex + 10);
            int iIndex = 2;
            while (iIndex < 10) {
                String sTemp = sWord.substring(iIndex, iIndex + 2);
                try {
                    cChars[i] = (byte)Integer.parseInt(sTemp, 16);
                    ++i;
                }
                catch (NumberFormatException e) {
                    System.err.println("sReadStringFromBufferBigEndian: " + e.getMessage());
                    sTemp = "00";
                }
                if (sTemp.equals("00")) {
                    done = true;
                    break;
                }
                iIndex += 2;
            }
            iWordIndex += 11;
        } while (!done);
        sReturn = new String(cChars);
        sReturn = sReturn.substring(0, i - 1);
        return sReturn;
    }

    public void saveValue() {
        this.sOriginal = this.sValue;
    }

    @Override
    public String getValue() {
        return this.sValue;
    }

    public String getOriginalValue() {
        return this.sOriginal;
    }

    public void setOffset(int iOffset) {
        this.iOffsetIntoStruct = iOffset;
    }

    public String getDataItemName() {
        return this.sItemName;
    }

    public int getOffsetIntoStruct() {
        return this.iOffsetIntoStruct;
    }

    public boolean updateRequired() {
        boolean bUpdate = this.bUpdateRequired;
        return bUpdate;
    }

    @Override
    public boolean setValue(String sValueList) {
        this.saveValue();
        int iValueLocation = this.iOffsetIntoStruct / 4;
        this.sValue = sValueList.substring(iValueLocation *= 11, iValueLocation + 10);
        if (!this.storeManager.isBigEndian(this.context)) {
            this.sValue = OSData.sSwapHexWord(this.sValue);
        }
        return !this.sOriginal.equals(this.sValue);
    }
}

