/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.controller;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.controller.ITimerStore;
import com.freescale.s32ds.debug.ka.freertos.model.RTOSTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class TimerStore
implements ITimerStore {
    private List<RTOSTimer> listAllTimers = new ArrayList<RTOSTimer>();
    private boolean bTimerListsPresent = true;
    private IRunControl.IExecutionDMContext context;
    private IStoreManager storeManager;

    public TimerStore(IRunControl.IExecutionDMContext context, IStoreManager storeManager) {
        this.context = context;
        this.storeManager = storeManager;
    }

    @Override
    public Object[] getTimerArray() {
        return this.listAllTimers.toArray();
    }

    private int prvAlreadyStored(long lAddress) {
        int iReturn = -1;
        int i = 0;
        while (i < this.listAllTimers.size()) {
            RTOSTimer xTimer = this.listAllTimers.get(i);
            if (xTimer.getAddress() == lAddress) {
                iReturn = i;
                break;
            }
            ++i;
        }
        return iReturn;
    }

    private void prvReadTimersFromList(String sListName) {
        if (this.bTimerListsPresent) {
            try {
                int iNumberOfItems = DSFInterface.getDefault().iEvaluateExpression(this.context, String.valueOf(sListName) + ".uxNumberOfItems");
                long lListAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, String.valueOf(sListName) + ".xListEnd.pxNext");
                int i = 0;
                while (i < iNumberOfItems) {
                    RTOSTimer xTimer;
                    String sQuery = "(unsigned long)(((struct xLIST_ITEM*)" + lListAddress + ")->pvOwner)";
                    long lContainerAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, sQuery);
                    int iIndex = this.prvAlreadyStored(lContainerAddress);
                    if (iIndex >= 0) {
                        xTimer = this.listAllTimers.get(iIndex);
                        xTimer.vSetValid(true);
                    } else {
                        xTimer = new RTOSTimer(this.context, lContainerAddress, this.storeManager);
                        this.listAllTimers.add(xTimer);
                    }
                    sQuery = "(((struct xLIST_ITEM*)" + lListAddress + ")->pxNext)";
                    lListAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, sQuery);
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                this.bTimerListsPresent = false;
                System.err.println("prvReadTimersFromList: failed to read list: " + e.getMessage());
            }
            catch (ExecutionException e) {
                this.bTimerListsPresent = false;
                System.err.println("prvReadTimersFromList ExecutionException: " + e.getMessage());
            }
        }
    }

    private void prvCreateTimerList() {
        RTOSTimer xTimer;
        int i = 0;
        while (i < this.listAllTimers.size()) {
            xTimer = this.listAllTimers.get(i);
            xTimer.vSetValid(false);
            ++i;
        }
        this.prvReadTimersFromList("${timers.c}xActiveTimerList1");
        this.prvReadTimersFromList("${timers.c}xActiveTimerList2");
        i = 0;
        while (i < this.listAllTimers.size()) {
            xTimer = this.listAllTimers.get(i);
            if (!xTimer.getIsValid()) {
                this.listAllTimers.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void vUpdateTimerMembers() {
        try {
            int i = 0;
            while (i < this.listAllTimers.size()) {
                try {
                    RTOSTimer xTimer = this.listAllTimers.get(i);
                    String sResult = DSFInterface.getDefault().sGetMemory(this.context, xTimer.getAddress(), (int)xTimer.getSize());
                    xTimer.setMemberValues(sResult);
                }
                catch (ExecutionException e) {
                    System.err.println("vUpdateTimerMembers(): " + e.getMessage());
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("vUpdateTimerMembers(): " + e.getMessage());
        }
    }

    @Override
    public void vHandleSuspendEvent() {
        if (DSFInterface.getDefault() != null) {
            this.prvCreateTimerList();
            this.vUpdateTimerMembers();
        }
    }
}

