/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.controller;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.controller.ITaskStore;
import com.freescale.s32ds.debug.ka.freertos.model.TCB;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class TaskStore
implements ITaskStore {
    private List<xList> xStateLists = new LinkedList<xList>();
    private List<TCB> listAllTasks = new ArrayList<TCB>();
    private int iNumberOfPriorities = 0;
    private boolean bStackCheckingOn = false;
    private IRunControl.IExecutionDMContext context;
    private IStoreManager storeManager;

    public TaskStore(IRunControl.IExecutionDMContext context, IStoreManager storeManager) {
        this.context = context;
        this.storeManager = storeManager;
    }

    @Override
    public Object[] getTCBArray() {
        return this.listAllTasks.toArray();
    }

    @Override
    public String sGetStateFromListAddress(Long lAddress) {
        String sReturn = "";
        int i = 0;
        while (i < this.xStateLists.size()) {
            xList x = this.xStateLists.get(i);
            if (x.lAddress == lAddress) {
                sReturn = x.sState;
                break;
            }
            ++i;
        }
        return sReturn;
    }

    private int prvAlreadyStored(long lAddress) {
        int iReturn = -1;
        int i = 0;
        while (i < this.listAllTasks.size()) {
            TCB xTCB = this.listAllTasks.get(i);
            if (xTCB.getAddress() == lAddress) {
                iReturn = i;
                break;
            }
            ++i;
        }
        return iReturn;
    }

    private void prvReadTasksFromList(String sListName) {
        try {
            int iNumberOfItems = DSFInterface.getDefault().iEvaluateExpression(this.context, String.valueOf(sListName) + ".uxNumberOfItems");
            long lListAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, String.valueOf(sListName) + ".xListEnd.pxNext");
            int i = 0;
            while (i < iNumberOfItems) {
                TCB xTCB;
                String sQuery = "(unsigned long)(((struct xLIST_ITEM*)" + lListAddress + ")->pvOwner)";
                long lContainerAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, sQuery);
                int iIndex = this.prvAlreadyStored(lContainerAddress);
                if (iIndex >= 0) {
                    xTCB = this.listAllTasks.get(iIndex);
                    xTCB.vSetValid(true);
                } else {
                    xTCB = new TCB(this.context, lContainerAddress, this.bStackCheckingOn, this.storeManager);
                    this.listAllTasks.add(xTCB);
                }
                sQuery = "(((struct xLIST_ITEM*)" + lListAddress + ")->pxNext)";
                lListAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, sQuery);
                ++i;
            }
        }
        catch (ExecutionException e) {
            System.err.println("prvReadTasksFromList ExecutionException: " + e.getMessage());
        }
    }

    private void prvCreateTaskList() {
        int i = 0;
        while (i < this.listAllTasks.size()) {
            TCB xTCB = this.listAllTasks.get(i);
            xTCB.vSetValid(false);
            ++i;
        }
        try {
            if (this.iNumberOfPriorities == 0) {
                int iSizeOfReadyLists = DSFInterface.getDefault().iEvaluateExpression(this.context, "sizeof(${tasks.c}pxReadyTasksLists)");
                int iSizeOfSingleList = DSFInterface.getDefault().iEvaluateExpression(this.context, "sizeof(struct xLIST)");
                if (iSizeOfReadyLists > 0 && iSizeOfSingleList > 0) {
                    this.iNumberOfPriorities = iSizeOfReadyLists / iSizeOfSingleList;
                }
                int i2 = 0;
                while (i2 < this.iNumberOfPriorities) {
                    String sListName = "${tasks.c}pxReadyTasksLists[" + i2 + "]";
                    xList xLinkedList = new xList();
                    xLinkedList.sState = "READY";
                    xLinkedList.lAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, "(&" + sListName + ")");
                    this.xStateLists.add(xLinkedList);
                    ++i2;
                }
                xList xLinkedList = new xList();
                xLinkedList.sState = "BLOCKED";
                xLinkedList.lAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, "(&${tasks.c}xDelayedTaskList1)");
                this.xStateLists.add(xLinkedList);
                xLinkedList = new xList();
                xLinkedList.sState = "BLOCKED";
                xLinkedList.lAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, "(&${tasks.c}xDelayedTaskList2)");
                this.xStateLists.add(xLinkedList);
                xLinkedList = new xList();
                xLinkedList.sState = "READY";
                xLinkedList.lAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, "(&${tasks.c}xPendingReadyList)");
                this.xStateLists.add(xLinkedList);
                xLinkedList = new xList();
                xLinkedList.sState = "SUSPENDED";
                xLinkedList.lAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, "(&${tasks.c}xSuspendedTaskList)");
                this.xStateLists.add(xLinkedList);
            }
            i = 0;
            while (i < this.iNumberOfPriorities) {
                String sListName = "${tasks.c}pxReadyTasksLists[" + i + "]";
                this.prvReadTasksFromList(sListName);
                ++i;
            }
            this.prvReadTasksFromList("${tasks.c}xDelayedTaskList1");
            this.prvReadTasksFromList("${tasks.c}xDelayedTaskList2");
            this.prvReadTasksFromList("${tasks.c}xPendingReadyList");
            this.prvReadTasksFromList("${tasks.c}xSuspendedTaskList");
        }
        catch (ExecutionException executionException) {
            this.iNumberOfPriorities = 0;
        }
        i = 0;
        while (i < this.listAllTasks.size()) {
            TCB xTCB = this.listAllTasks.get(i);
            if (!xTCB.getIsValid()) {
                this.listAllTasks.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void vUpdateTaskMembers() {
        block5: {
            try {
                long lCurrentTCB = this.getCurrentTCB();
                if (lCurrentTCB == 0L) break block5;
                int i = 0;
                while (i < this.listAllTasks.size()) {
                    try {
                        TCB xTCB = this.listAllTasks.get(i);
                        String sResult = DSFInterface.getDefault().sGetMemory(this.context, xTCB.getAddress(), (int)xTCB.getSize());
                        xTCB.setMemberValues(sResult, lCurrentTCB);
                    }
                    catch (ExecutionException e) {
                        System.err.println("vUpdateTaskMembers (read TCB): " + e.getMessage());
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("vUpdateTaskMembers (get lCurrentTCB): " + e.getMessage());
            }
        }
    }

    @Override
    public long getCurrentTCB() {
        return DSFInterface.getDefault().lEvaluateExpression(this.context, "pxCurrentTCB");
    }

    @Override
    public long getCurrentTCBAddress() {
        return DSFInterface.getDefault().lEvaluateExpression(this.context, "&pxCurrentTCB");
    }

    @Override
    public void vHandleSuspendEvent() {
        if (DSFInterface.getDefault() != null) {
            this.prvCreateTaskList();
            this.vUpdateTaskMembers();
        }
    }

    private class xList {
        long lAddress;
        String sState;

        private xList() {
        }
    }
}

