/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.controller;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.controller.IQueueStore;
import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.QueueRegistry;
import com.freescale.s32ds.debug.ka.freertos.model.RTOSQueue;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class QueueStore
implements IQueueStore {
    private List<QueueRegistry> xRegisteredQueues = new LinkedList<QueueRegistry>();
    private boolean bQueueRegistryPresent = true;
    private long lQueueRegistryStartAddress = 0L;
    private int iQueueRegistrySizeBytes = 0;
    private int iQueueRegistrySizeInItems = 0;
    private String sRawData = "";
    private QueueRegistry xQueueRegisterMaster = null;
    List<Integer> InvalidQueueRegistryItemIndexes = new LinkedList<Integer>();
    List<Integer> InvalidRTOSQueueIndexes = new LinkedList<Integer>();
    private IRunControl.IExecutionDMContext context;
    private IStoreManager storeManager;

    public QueueStore(IRunControl.IExecutionDMContext context, IStoreManager storeManager) {
        this.context = context;
        this.storeManager = storeManager;
    }

    @Override
    public String sGetNameFromQueueAddress(String sAddressIn) {
        String sReturn = sAddressIn;
        try {
            long lAddressIn = Long.decode(sAddressIn);
            int i = 0;
            while (i < this.xRegisteredQueues.size()) {
                QueueRegistry xQRegisteredItem = this.xRegisteredQueues.get(i);
                String sTxAddress = xQRegisteredItem.xQueue.getTxQueueAddress();
                String sRxAddress = xQRegisteredItem.xQueue.getRxQueueAddress();
                if (Long.decode(sTxAddress) == lAddressIn || Long.decode(sRxAddress) == lAddressIn) {
                    sReturn = xQRegisteredItem.getQueueName();
                    break;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("sGetNameFromQueueAddress decode error: " + e.getMessage());
        }
        return sReturn;
    }

    private int prvAlreadyStored(String sAddressIn) {
        int iReturn = -1;
        int i = 0;
        while (i < this.xRegisteredQueues.size()) {
            QueueRegistry xItem = this.xRegisteredQueues.get(i);
            if (xItem.getQueueHandle().equals(sAddressIn)) {
                iReturn = i;
                break;
            }
            ++i;
        }
        return iReturn;
    }

    public void vUpdateQueueMembers() {
        int i = 0;
        while (i < this.xRegisteredQueues.size()) {
            QueueRegistry xQueueEntry = this.xRegisteredQueues.get(i);
            try {
                String sResult = DSFInterface.getDefault().sGetMemory(this.context, xQueueEntry.xQueue.getAddress(), (int)xQueueEntry.xQueue.getSize());
                xQueueEntry.xQueue.setMemberValues(sResult);
            }
            catch (ExecutionException e) {
                System.err.println("vUpdateQueueMembers ExecutionException: " + e.getMessage());
            }
            ++i;
        }
    }

    public void prvObtainQueueRegistrySize() {
        if (DSFInterface.getDefault() != null && this.bQueueRegistryPresent && this.iQueueRegistrySizeInItems == 0) {
            try {
                this.lQueueRegistryStartAddress = DSFInterface.getDefault().lEvaluateExpression(this.context, "(&(xQueueRegistry[0]))");
                if (this.lQueueRegistryStartAddress != 0L) {
                    this.iQueueRegistrySizeBytes = DSFInterface.getDefault().iEvaluateExpression(this.context, "sizeof(xQueueRegistry)");
                    int iRegistryItemSize = DSFInterface.getDefault().iEvaluateExpression(this.context, "sizeof(xQueueRegistryItem)");
                    this.iQueueRegistrySizeInItems = this.iQueueRegistrySizeBytes / iRegistryItemSize;
                } else {
                    this.bQueueRegistryPresent = false;
                }
            }
            catch (NumberFormatException e) {
                this.bQueueRegistryPresent = false;
                System.err.println("prvObtainQueueRegistrySize: failed to decode registry start address: " + e.getMessage());
            }
            catch (ExecutionException e) {
                this.bQueueRegistryPresent = false;
                System.err.println("prvObtainQueueRegistrySize: " + e.getMessage());
            }
        }
    }

    private void prvInvalidateAllQueues() {
        int iQueue = 0;
        while (iQueue < this.xRegisteredQueues.size()) {
            QueueRegistry xQueueEntry = this.xRegisteredQueues.get(iQueue);
            xQueueEntry.xQueue.vSetValid(false);
            ++iQueue;
        }
    }

    private void prvLookForNewlyRegisteredQueues(String sArrayData) {
        int iQueue = 0;
        while (iQueue < this.iQueueRegistrySizeInItems) {
            QueueRegistry xQueueEntry = new QueueRegistry(this.context, this.xQueueRegisterMaster, this.storeManager);
            xQueueEntry.setMemberValues(sArrayData.substring(iQueue * (this.iQueueRegistrySizeBytes / this.iQueueRegistrySizeInItems / 4) * 11));
            if (!xQueueEntry.getQueueName().isEmpty()) {
                String sQueuePointer = xQueueEntry.getQueueHandle();
                int iIndex = this.prvAlreadyStored(sQueuePointer);
                if (iIndex < 0) {
                    xQueueEntry.xQueue = new RTOSQueue(this.context, xQueueEntry.getQueueName(), sQueuePointer, this.storeManager);
                    this.xRegisteredQueues.add(xQueueEntry);
                } else {
                    xQueueEntry = this.xRegisteredQueues.get(iIndex);
                    xQueueEntry.xQueue.vSetValid(true);
                }
            }
            ++iQueue;
        }
    }

    private void prvDeleteOrphanedQueues() {
        int iQueue = 0;
        while (iQueue < this.xRegisteredQueues.size()) {
            QueueRegistry xQueueEntry = this.xRegisteredQueues.get(iQueue);
            if (!xQueueEntry.xQueue.getIsValid()) {
                this.xRegisteredQueues.remove(iQueue);
                --iQueue;
            }
            ++iQueue;
        }
    }

    private void prvUpdateListOfRegisteredQueues(String sArrayData) {
        this.prvInvalidateAllQueues();
        this.prvLookForNewlyRegisteredQueues(sArrayData);
        this.prvDeleteOrphanedQueues();
    }

    @Override
    public void vHandleSuspendEvent() {
        if (DSFInterface.getDefault() != null) {
            this.prvObtainQueueRegistrySize();
            if (this.bQueueRegistryPresent) {
                try {
                    String sArrayData = DSFInterface.getDefault().sGetMemory(this.context, this.lQueueRegistryStartAddress, this.iQueueRegistrySizeBytes);
                    if (!sArrayData.equals(this.sRawData)) {
                        this.sRawData = sArrayData;
                        this.prvUpdateListOfRegisteredQueues(sArrayData);
                    }
                    this.vUpdateQueueMembers();
                }
                catch (ExecutionException e) {
                    System.err.println("vHandleSuspendEvent ExecutionException: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public Object[] getQueueArray() {
        LinkedList<RTOSQueue> xQueues = new LinkedList<RTOSQueue>();
        int i = 0;
        while (i < this.xRegisteredQueues.size()) {
            xQueues.add(this.xRegisteredQueues.get((int)i).xQueue);
            ++i;
        }
        return xQueues.toArray();
    }
}

