/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos;

import com.freescale.s32ds.debug.ka.freertos.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.controller.StoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.IOSTask;
import com.freescale.s32ds.debug.ka.freertos.model.RTOSQueue;
import com.freescale.s32ds.debug.ka.freertos.model.RTOSTimer;
import com.freescale.system.browser.model.ISimpleTableDataProvider;
import com.freescale.system.browser.model.ThreadInfo;
import com.freescale.system.browser.model.ThreadSequenceHolder;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class FreeRTOSTaskTabDataProvider
implements ISimpleTableDataProvider {
    private IStoreManager fStoreManager;

    public ThreadSequenceHolder getThreadSequenceHolder(IRunControl.IExecutionDMContext context) {
        this.fStoreManager = StoreManager.getDefault();
        if (context != null) {
            this.fStoreManager.updateTaskStore(context);
            this.fStoreManager.updateQueueStore(context);
            this.fStoreManager.updateTimerStore(context);
            Object[] elements = this.fStoreManager.getTaskStore(context).getTCBArray();
            if (elements != null) {
                Object element;
                ArrayList<ThreadInfo> threadInfos = new ArrayList<ThreadInfo>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    element = objectArray[n2];
                    if (element instanceof IOSTask) {
                        HashMap<String, String> extendedInfo = new HashMap<String, String>();
                        extendedInfo.put("task.Name", ((IOSTask)element).getTaskName());
                        extendedInfo.put("task.State", ((IOSTask)element).getTaskState());
                        extendedInfo.put("task.Priority", ((IOSTask)element).getTaskPriority());
                        extendedInfo.put("task.StackStart", ((IOSTask)element).getTaskStackStart());
                        extendedInfo.put("task.StackTop", ((IOSTask)element).getTaskStackTop());
                        extendedInfo.put("task.Event", ((IOSTask)element).getTaskEvent());
                        threadInfos.add(new ThreadInfo(null, null, extendedInfo));
                    }
                    ++n2;
                }
                elements = this.fStoreManager.getQueueStore(context).getQueueArray();
                if (elements != null) {
                    objectArray = elements;
                    n = elements.length;
                    n2 = 0;
                    while (n2 < n) {
                        element = objectArray[n2];
                        if (element instanceof RTOSQueue) {
                            ((RTOSQueue)element).getQueueName();
                            ((RTOSQueue)element).getQueueAddress();
                            ((RTOSQueue)element).getQueueMaxLength();
                            ((RTOSQueue)element).getQueueItemSize();
                            ((RTOSQueue)element).getQueueCurrentLength();
                            ((RTOSQueue)element).getQueueNumberOfWaitingToSendTasks();
                            ((RTOSQueue)element).getQueueNumberOfWaitingToRecieiveTasks();
                            ((RTOSQueue)element).getQueueType();
                        }
                        ++n2;
                    }
                }
                if ((elements = this.fStoreManager.getTimerStore(context).getTimerArray()) != null) {
                    objectArray = elements;
                    n = elements.length;
                    n2 = 0;
                    while (n2 < n) {
                        element = objectArray[n2];
                        if (element instanceof RTOSTimer) {
                            ((RTOSTimer)element).getTimerName();
                            ((RTOSTimer)element).getTimerPeriod();
                            ((RTOSTimer)element).getTimerReloadValue();
                            ((RTOSTimer)element).getTimerCallbackFunction();
                            ((RTOSTimer)element).getTimerID();
                        }
                        ++n2;
                    }
                }
                return new ThreadSequenceHolder(threadInfos);
            }
        }
        return null;
    }
}

