/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder;

import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ListEditor {
    private static final String MOVEUP_STR = "Up";
    private static final String MOVEDOWN_STR = "Down";
    private ToolBar toolBar;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    private final List list;
    private final Collection<Runnable> listeners = new ArrayList<Runnable>();
    private final Image IMG_MOVEUP = CDTSharedImages.getImage((String)"icons/elcl16/list-moveup.gif");
    private final Image IMG_MOVEDOWN = CDTSharedImages.getImage((String)"icons/elcl16/list-movedown.gif");

    public ListEditor(Composite parent, String compTitle) {
        Composite filePanel = new Composite(parent, 0){
            {
                GridLayout form1 = new GridLayout();
                form1.numColumns = 1;
                form1.horizontalSpacing = 0;
                form1.verticalSpacing = 0;
                form1.marginHeight = 0;
                form1.marginWidth = 0;
                this.setLayout((Layout)form1);
                this.setLayoutData(new GridData(1808));
            }
        };
        Composite titlePanel = new Composite(filePanel, 2048, compTitle){
            {
                GridLayout titleform = new GridLayout(2, false);
                titleform.horizontalSpacing = 0;
                titleform.verticalSpacing = 0;
                titleform.marginHeight = 0;
                titleform.marginWidth = 0;
                this.setLayout((Layout)titleform);
                GridData tgdata = new GridData(768);
                tgdata.heightHint = 25;
                this.setLayoutData(tgdata);
                ListEditor.this.title = new Label((Composite)this, 1);
                ListEditor.this.title.setText("  " + string);
                GridData grid2 = new GridData(768);
                ListEditor.this.title.setLayoutData((Object)grid2);
            }
        };
        new Composite(titlePanel, 0){
            {
                GridLayout form2 = new GridLayout();
                form2.numColumns = 5;
                form2.horizontalSpacing = 0;
                form2.verticalSpacing = 0;
                form2.marginWidth = 0;
                form2.marginHeight = 0;
                this.setLayout((Layout)form2);
                ListEditor.this.toolBar = new ToolBar((Composite)this, 8519936);
                ListEditor.this.moveUpItem = new ToolItem(ListEditor.this.toolBar, 8);
                ListEditor.this.moveUpItem.setImage(ListEditor.this.IMG_MOVEUP);
                ListEditor.this.moveUpItem.setToolTipText(ListEditor.MOVEUP_STR);
                ListEditor.this.moveUpItem.addListener(13, e -> ListEditor.this.upPressed());
                ListEditor.this.moveDownItem = new ToolItem(ListEditor.this.toolBar, 8);
                ListEditor.this.moveDownItem.setImage(ListEditor.this.IMG_MOVEDOWN);
                ListEditor.this.moveDownItem.setToolTipText(ListEditor.MOVEDOWN_STR);
                ListEditor.this.moveDownItem.addListener(13, e -> ListEditor.this.downPressed());
                GridData grid3 = new GridData(896);
                this.setLayoutData(grid3);
            }
        };
        this.list = new List(filePanel, 2818);
        GridData grid4 = new GridData(1808);
        Point preferredSize = titlePanel.computeSize(-1, -1);
        grid4.widthHint = preferredSize.x;
        grid4.heightHint = preferredSize.y * 3;
        grid4.horizontalSpan = 2;
        this.list.setLayoutData((Object)grid4);
        this.list.addListener(13, e -> this.selectionChanged());
        this.selectionChanged();
    }

    public void setList(String[] listVal) {
        this.updateAndNotify(() -> {
            this.list.removeAll();
            Stream.of(listVal).forEach(arg_0 -> ((List)this.list).add(arg_0));
        });
    }

    public void addChangeListener(Runnable listener) {
        this.listeners.add(listener);
    }

    private void updateAndNotify(Runnable runnable) {
        Object[] before = this.list.getItems();
        runnable.run();
        if (!Arrays.equals(before, this.list.getItems())) {
            this.listeners.forEach(Runnable::run);
        }
    }

    public void removeAll() {
        this.updateAndNotify(() -> ((List)this.list).removeAll());
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    private void upPressed() {
        this.updateAndNotify(() -> {
            int index = this.list.getSelectionIndex();
            String curSelList = this.list.getItem(index);
            String preList = this.list.getItem(index - 1);
            this.list.setItem(index - 1, curSelList);
            this.list.setItem(index, preList);
            this.list.setSelection(index - 1);
            this.selectionChanged();
        });
    }

    private void downPressed() {
        this.updateAndNotify(() -> {
            int index = this.list.getSelectionIndex();
            String curSelList = this.list.getItem(index);
            String nextList = this.list.getItem(index + 1);
            this.list.setItem(index + 1, curSelList);
            this.list.setItem(index, nextList);
            this.list.setSelection(index + 1);
            this.selectionChanged();
        });
    }

    private void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        int count = this.list.getSelectionCount();
        this.moveUpItem.setEnabled(size > 1 && index > 0 && count == 1);
        this.moveDownItem.setEnabled(size > 1 && index >= 0 && index < size - 1 && count == 1);
    }

    public List getListControl() {
        return this.list;
    }

    public Label getLabelControl() {
        return this.title;
    }

    public void setEnabled(boolean enabled) {
        Stream.of(this.title, this.toolBar, this.list).forEach(FuncUtils.bindConsumer(Control::setEnabled, (Object)enabled));
    }
}

