/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.GnuMakefileGenerator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.MakefileGenerator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.ToolConstants;
import com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder.LinkOrder;
import com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder.SourceChainMap;
import com.nxp.s32ds.ext.cdt.makefilegenerator.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LinkerOrderHelper {
    private static final String DOUBLE_QUOTE = "\"";

    public static String getCustomLinkOrderInputs(ITool linker, MakefileGenerator generator) throws BuildException {
        SourceChainMap chains = new SourceChainMap(linker);
        StringBuilder args = new StringBuilder();
        LinkOrder linkOrder = new LinkOrder(linker);
        Map<String, String> userObjectMap = LinkerOrderHelper.getUserObjectMap(linker);
        String[] stringArray = linkOrder.get().orElse(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String linkOrderItem = stringArray[n2];
            IFile file = generator.getProject().getFile(linkOrderItem);
            if (chains.containsKey(file.getFileExtension())) {
                ArrayList<IPath> paths = new ArrayList<IPath>();
                LinkerOrderHelper.getLinkerInputs(generator, chains, file, paths);
                for (IPath path : paths) {
                    String unflaggedPath = DOUBLE_QUOTE + path.toPortableString() + DOUBLE_QUOTE;
                    LinkerOrderHelper.updateArgs(generator, args, unflaggedPath);
                }
            } else {
                for (String inputUserObject : userObjectMap.keySet()) {
                    if (!inputUserObject.equals(linkOrderItem)) continue;
                    LinkerOrderHelper.updateArgs(generator, args, userObjectMap.get(inputUserObject));
                    break;
                }
            }
            ++n2;
        }
        return args.toString().trim();
    }

    public static Map<String, String> getUserObjectMap(ITool tool) {
        HashMap<String, String> map = new HashMap<String, String>();
        IBuildMacroProvider buildMacroProvider = ManagedBuildManager.getBuildMacroProvider();
        for (IOption option : LinkerOrderHelper.getOptions(tool, 7)) {
            try {
                String[] unresolvedObjects = option.getUserObjects();
                if (unresolvedObjects == null) continue;
                String[] stringArray = unresolvedObjects;
                int n = unresolvedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    String unresolvedObject = stringArray[n2];
                    try {
                        String[] resolved = LinkerOrderHelper.resolve(tool, buildMacroProvider, option, unresolvedObject);
                        if (resolved != null && resolved.length > 0) {
                            map.put(unresolvedObject, resolved[0]);
                        }
                    }
                    catch (BuildMacroException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static void getLinkerInputs(MakefileGenerator generator, SourceChainMap chains, IFile file, List<IPath> paths) {
        List chain = (List)chains.get(file.getFileExtension());
        if (chain == null) {
            return;
        }
        Vector<IPath> relativeOutputLocations = generator.getRelativeOutputLocations((IResource)file, (ITool)chain.get(0));
        IPath outputDir = generator.getBuildWorkingDirLocation();
        if (chain.size() == 2) {
            for (IPath relativeOutputLocation : relativeOutputLocations) {
                paths.add(outputDir.append(relativeOutputLocation));
            }
            return;
        }
        IProject project = generator.getProject();
        IPath relativeOutputDir = outputDir.removeFirstSegments(project.getLocation().segmentCount());
        for (IPath relativeOutputLocation : relativeOutputLocations) {
            IFile outputFile = project.getFile(relativeOutputDir.append(relativeOutputLocation));
            LinkerOrderHelper.getLinkerInputs(generator, chains, outputFile, paths);
        }
    }

    private static void updateArgs(MakefileGenerator generator, StringBuilder args, String unflaggedPath) {
        String convertedPath = LinkerOrderHelper.convert(generator, unflaggedPath);
        if (convertedPath.length() > 0) {
            args.append(convertedPath).append(ToolConstants.NEWLINE);
        }
    }

    private static String[] resolve(final ITool tool, IBuildMacroProvider buildMacroProvider, final IOption option, String unresolvedObject) throws BuildMacroException {
        IOptionContextData contextData = new IOptionContextData(){

            public IOption getOption() {
                return option;
            }

            public IOptionCategory getOptionCategory() {
                return option.getCategory();
            }

            public IBuildObject getParent() {
                return tool;
            }
        };
        return buildMacroProvider.resolveStringListValueToMakefileFormat(unresolvedObject, "", " ", 2, (Object)contextData);
    }

    static String convert(MakefileGenerator generator, String unflaggedPath) {
        IPath absolutePath;
        String path;
        String prefix = Utils.getPrefixBeforeQuotes(unflaggedPath);
        if (prefix != null) {
            unflaggedPath = unflaggedPath.substring(prefix.length());
        }
        if (Utils.removeQuotes(unflaggedPath).length() == 0) {
            return "";
        }
        if (Utils.isQuoted(unflaggedPath)) {
            unflaggedPath = Utils.removeQuotes(unflaggedPath);
        }
        if (!Utils.isQuoted(path = generator.getRelativeOutputPath(absolutePath = Path.fromOSString((String)unflaggedPath.toString()), true))) {
            path = Utils.quotePath(path);
        }
        if (prefix != null) {
            path = String.valueOf(prefix) + path;
        }
        return path;
    }

    private static List<IOption> getOptions(ITool tool, int type) {
        ArrayList<IOption> options = new ArrayList<IOption>();
        IOption[] iOptionArray = tool.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            try {
                if (option.getValueType() == type) {
                    options.add(option);
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return options;
    }

    public static String sanitizeMakeTarget(String output) {
        Path path = new Path(output);
        String portableString = path.toPortableString();
        return GnuMakefileGenerator.escapeWhitespaces((String)portableString);
    }
}

