/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.GnuMakefileGenerator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.MakefileGenerator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.ToolConstants;
import com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder.LinkOrder;
import com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder.LinkerOrderHelper;
import com.nxp.s32ds.ext.cdt.makefilegenerator.utils.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ArgumentFileBuilder {
    private static final String EMPTY_STRING = new String();
    private static final String LIBS = "LIBS";
    private static final String OBJS = "OBJS";
    private static final String USER_OBJS = "USER_OBJS";
    private static final String OIPUS = "OIPUS";
    private static final String OIPUV = "OIPUV";
    private int fEnabled = 0;
    private int fBuildCommandCounter = 0;
    private List<BuildCommand> buildCommandList = new LinkedList<BuildCommand>();
    private MakefileGenerator generator;
    private List<String> nameList = new LinkedList<String>();
    private static final String MAKE_SINGLE_VAR_CHARS = "@%<?^+|*";

    public ArgumentFileBuilder(MakefileGenerator generator) {
        this.generator = generator;
    }

    public void enable() {
        ++this.fEnabled;
        this.fBuildCommandCounter = 1;
    }

    public void disable() {
        --this.fEnabled;
    }

    public boolean isEnabled() {
        return this.fEnabled > 0;
    }

    private BuildCommand getReducedBuildFlags(String[] argfileFlags, String[] cmdlineFlags, String additionalOption) {
        BuildCommand buildCommand = new BuildCommand();
        new StringBuffer();
        int i = 0;
        while (i < argfileFlags.length) {
            buildCommand.fileArguments.add(argfileFlags[i]);
            ++i;
        }
        StringBuffer cmdArgs = new StringBuffer();
        cmdArgs.append(additionalOption);
        String[] stringArray = cmdlineFlags;
        int n = cmdlineFlags.length;
        int n2 = 0;
        while (n2 < n) {
            String cmdFlag = stringArray[n2];
            cmdArgs.append(" " + cmdFlag);
            ++n2;
        }
        buildCommand.buildCommand = cmdArgs.toString();
        return buildCommand;
    }

    private String[] getCompactedFlags(ITool tool, String relativePath, String targetName, String[] argfileFlags, String[] cmdlineFlags, IPath topBuildLocation, boolean overwriteExistingArgsFile) {
        String[] flags;
        if (this.isEnabled()) {
            String replacementFlag = ArgumentFileBuilder.getReplacementFlag(tool);
            if (replacementFlag != null) {
                String fileName = this.getUniqueFileName(String.valueOf(relativePath) + targetName, topBuildLocation);
                if (!overwriteExistingArgsFile) {
                    boolean unique = false;
                    while (!unique) {
                        File f = topBuildLocation.append(fileName).toFile();
                        boolean bl = unique = !f.exists();
                        if (unique) continue;
                        this.addToNameList(fileName);
                        fileName = this.getUniqueFileName(String.valueOf(relativePath) + targetName, topBuildLocation);
                    }
                }
                String additionalOption = Utils.quotePath(String.valueOf(replacementFlag) + fileName);
                BuildCommand buildCommand = this.getReducedBuildFlags(argfileFlags, cmdlineFlags, additionalOption);
                flags = new String[]{buildCommand.buildCommand};
                buildCommand.fileName = fileName;
                buildCommand.tool = tool;
                buildCommand.targetName = targetName;
                this.addToNameList(fileName);
                this.buildCommandList.add(buildCommand);
            } else {
                flags = argfileFlags;
            }
        } else {
            flags = new String[argfileFlags.length + cmdlineFlags.length];
            int i = 0;
            while (i < argfileFlags.length) {
                flags[i] = argfileFlags[i];
                ++i;
            }
            i = 0;
            while (i < cmdlineFlags.length) {
                flags[i + argfileFlags.length] = cmdlineFlags[i];
                ++i;
            }
        }
        return flags;
    }

    void resetNameList() {
        this.nameList = new LinkedList<String>();
    }

    void addToNameList(String name) {
        this.nameList.add(name);
    }

    private boolean isNameUnique(String name) {
        for (String item : this.nameList) {
            if (!item.equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    public String convertBuildCmd(ITool tool, String targetName, String buildCmd, IConfiguration config, String buildTargetExt, MakefileGenerator makefileGenerator) {
        if (this.isEnabled() && this.buildCommandList.size() > 0) {
            BuildCommand buildCommand = this.buildCommandList.get(this.buildCommandList.size() - 1);
            if (buildCommand.tool.equals(tool) && buildCommand.targetName != null && buildCommand.targetName.equals(targetName) && buildCmd.contains(buildCommand.buildCommand)) {
                int startOfIntermediateFlag;
                String intermediateFlags;
                int intermediateFlagsIndex;
                StringBuilder convertedCmd = new StringBuilder();
                int index = this.getIndexOnArgumentBoundary(buildCmd, "$(", 0);
                if (index != -1 && (intermediateFlagsIndex = buildCmd.indexOf(buildCommand.buildCommand, 0)) > 0 && intermediateFlagsIndex < index && (intermediateFlags = buildCmd.substring(startOfIntermediateFlag = intermediateFlagsIndex + buildCommand.buildCommand.length(), index).trim()).length() > 0) {
                    convertedCmd.append(buildCmd.substring(0, intermediateFlagsIndex));
                    convertedCmd.append(String.valueOf(intermediateFlags) + " ");
                    convertedCmd.append(String.valueOf(buildCommand.buildCommand) + " ");
                    buildCmd = buildCmd.substring(index);
                    index = this.getIndexOnArgumentBoundary(buildCmd, "$(", 0);
                }
                LinkOrder linkOrder = new LinkOrder(tool);
                boolean seenInputMacro = false;
                while (index != -1) {
                    int end;
                    if (index > 0) {
                        convertedCmd.append(buildCmd.substring(0, index));
                        buildCmd = buildCmd.substring(index);
                        index = 0;
                    }
                    if ((end = buildCmd.indexOf(")", 2)) == -1) break;
                    String macro = buildCmd.substring(index + 2, end);
                    String value = this.getResolvedValues(config, macro, buildTargetExt);
                    boolean isObjects = macro.startsWith(OBJS) || macro.startsWith(USER_OBJS) || macro.startsWith(OIPUS) || macro.startsWith(OIPUV);
                    boolean linkOrderIsEnabled = linkOrder.isEnabled();
                    if (value.equals(macro) && !linkOrderIsEnabled || value.equals(macro) && linkOrderIsEnabled && !isObjects) {
                        convertedCmd.append(buildCmd.substring(0, end + 1));
                    } else if (isObjects) {
                        if (linkOrderIsEnabled) {
                            if (!seenInputMacro) {
                                linkOrder.update(makefileGenerator.getConfig());
                                try {
                                    value = LinkerOrderHelper.getCustomLinkOrderInputs(tool, makefileGenerator);
                                    seenInputMacro = true;
                                }
                                catch (BuildException e) {
                                    Activator.log((Exception)((Object)e));
                                }
                            } else {
                                value = "";
                            }
                        }
                        if (!value.isEmpty()) {
                            buildCommand.fileArguments.add(value);
                        }
                    } else {
                        buildCommand.fileArguments.add(value);
                    }
                    buildCmd = buildCmd.substring(end + 1);
                    index = this.getIndexOnArgumentBoundary(buildCmd, "$(", index);
                }
                if (buildCmd.length() > 0) {
                    convertedCmd.append(buildCmd);
                }
                return convertedCmd.toString();
            }
        }
        return buildCmd;
    }

    private String getResolvedValues(IConfiguration config, String macro, String buildTargetExt) {
        StringBuilder builder = new StringBuilder();
        if (macro.equals(LIBS)) {
            String[] libs = config.getLibs(buildTargetExt);
            int i = 0;
            while (i < libs.length) {
                String string = libs[i];
                builder.append(String.valueOf(string) + ToolConstants.NEWLINE);
                ++i;
            }
        } else if (macro.startsWith(USER_OBJS)) {
            String[] userObjs = config.getUserObjects(buildTargetExt);
            int i = 0;
            while (i < userObjs.length) {
                String obj = new Path(userObjs[i]).toPortableString();
                builder.append(String.valueOf(Utils.quotePath(obj)) + ToolConstants.NEWLINE);
                ++i;
            }
        } else {
            List<String> values;
            HashMap<String, List<String>> buildVarsAgregateValues;
            HashMap buildOutputVars = this.generator.getBuildOutputVars();
            if (buildOutputVars != null && buildOutputVars.containsKey(macro) && (buildVarsAgregateValues = this.generator.getBuildVarsAgregateValues()) != null && (values = buildVarsAgregateValues.get(macro)) != null) {
                for (String value : values) {
                    value = Utils.quotePath(value);
                    builder.append(String.valueOf(value) + ToolConstants.NEWLINE);
                }
            }
        }
        if (builder.length() > 0) {
            return builder.toString().trim();
        }
        return macro;
    }

    private int getIndexOnArgumentBoundary(String buildCmd, String what, int i) {
        String[] arguments;
        String subString = buildCmd.substring(i);
        String[] stringArray = arguments = Utils.mergeLinesWithQuotes(subString.split(" "));
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            if (argument.startsWith(what)) {
                return buildCmd.indexOf(argument, i);
            }
            ++n2;
        }
        return -1;
    }

    public String[] convertFlags(String relativePath, IPath sourceLocation, ITool tool, IPath outputLocation, boolean needExplicitRuleForFile, String[] flags, String targetName, IPath topBuildLocation) {
        return this.convertFlags(relativePath, sourceLocation, tool, outputLocation, needExplicitRuleForFile, flags, targetName, topBuildLocation, true);
    }

    private String[] convertFlags(String relativePath, IPath sourceLocation, ITool tool, IPath outputLocation, boolean needExplicitRuleForFile, String[] flags, String targetName, IPath topBuildLocation, boolean useVars) {
        return this.convertFlags(relativePath, sourceLocation, tool, outputLocation, needExplicitRuleForFile, flags, targetName, topBuildLocation, useVars, true);
    }

    private String[] convertFlags(String relativePath, IPath sourceLocation, ITool tool, IPath outputLocation, boolean needExplicitRuleForFile, String[] flags, String targetName, IPath topBuildLocation, boolean useVars, boolean overwriteExistingArgsFile) {
        if (targetName == null) {
            return flags;
        }
        LinkedList<String> argfileFlagList = new LinkedList<String>();
        LinkedList<String> cmdlineFlagList = new LinkedList<String>();
        int i = 0;
        while (i < flags.length) {
            String[] subFlags;
            String flag = flags[i];
            String[] stringArray = subFlags = Utils.mergeLinesWithQuotes(flag.split(" "));
            int n = subFlags.length;
            int n2 = 0;
            while (n2 < n) {
                String subflag = stringArray[n2];
                boolean commaSeparated = false;
                String[] tokens = new String[]{subflag};
                if (subflag.indexOf(",") > -1) {
                    commaSeparated = true;
                    tokens = subflag.split(",");
                }
                subflag = "";
                String[] stringArray2 = tokens;
                int n3 = tokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String token = stringArray2[n4];
                    try {
                        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
                        String resolvedFlag = !needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(token, EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)tool)) : provider.resolveValue(token, EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)tool));
                        resolvedFlag = resolvedFlag.trim();
                        if (resolvedFlag.length() > 0) {
                            token = resolvedFlag;
                        }
                        if (token.indexOf("/") != -1 || token.indexOf("\\") != -1) {
                            String[] strs = Utils.mergeLinesWithQuotes(token.split(" "));
                            token = "";
                            int j = 0;
                            while (j < strs.length) {
                                String prefix = Utils.getPrefixBeforeQuotes(strs[j]);
                                if (prefix != null) {
                                    strs[j] = strs[j].substring(prefix.length());
                                } else {
                                    int in = strs[j].indexOf("../");
                                    if (in != -1 && strs[j].indexOf("\"") == -1 && strs[j].startsWith("-")) {
                                        prefix = strs[j].substring(0, in);
                                        strs[j] = strs[j].substring(in);
                                    }
                                }
                                boolean isQuoted = Utils.isQuoted(strs[j]);
                                Path p = new Path(Utils.removeQuotes(strs[j]));
                                String newValue = p.toPortableString();
                                if (isQuoted) {
                                    newValue = Utils.quotePath(newValue);
                                }
                                if (prefix != null) {
                                    newValue = String.valueOf(prefix) + newValue;
                                }
                                token = String.valueOf(token) + newValue;
                                if (j != strs.length - 1) {
                                    token = String.valueOf(token) + " ";
                                }
                                ++j;
                            }
                            provider.resolveValue("${ProjDirPath}", EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)tool));
                        }
                    }
                    catch (BuildMacroException e) {
                        e.printStackTrace();
                    }
                    subflag = String.valueOf(subflag) + token;
                    if (commaSeparated) {
                        subflag = String.valueOf(subflag) + ",";
                    }
                    ++n4;
                }
                if (commaSeparated && subflag.endsWith(",")) {
                    subflag = subflag.substring(0, subflag.length() - 1);
                }
                if (this.containsMakeVariable(subflag)) {
                    int pos = subflag.indexOf("$<");
                    if (pos != -1) {
                        subflag = String.valueOf(subflag.substring(0, pos)) + "\"" + subflag.substring(pos, subflag.length() - pos + 2) + "\"";
                    }
                    cmdlineFlagList.add(subflag);
                } else {
                    argfileFlagList.add(subflag);
                }
                ++n2;
            }
            ++i;
        }
        String[] argFlags = argfileFlagList.toArray(new String[argfileFlagList.size()]);
        String[] cmdFlags = cmdlineFlagList.toArray(new String[cmdlineFlagList.size()]);
        return this.getCompactedFlags(tool, relativePath, targetName, argFlags, cmdFlags, topBuildLocation, overwriteExistingArgsFile);
    }

    private boolean containsMakeVariable(String flag) {
        char nextChar;
        int dollarPos = flag.indexOf(36);
        return dollarPos != -1 && dollarPos < flag.length() && MAKE_SINGLE_VAR_CHARS.indexOf(nextChar = flag.charAt(dollarPos + 1)) != -1;
    }

    /*
     * Unable to fully structure code
     */
    private String getUniqueFileName(String targetName, IPath topBuildLocation) {
        targetPath = new Path(targetName);
        if (targetPath.isAbsolute() || this.isOutsideProjectDirectory(targetPath, topBuildLocation)) {
            targetName = targetPath.lastSegment();
        }
        parentRelativeCharacters = new String[]{"../", "..\\"};
        i = 0;
        while (i < parentRelativeCharacters.length) {
            parentIndex = targetName.indexOf(parentRelativeCharacters[i]);
            while (parentIndex >= 0) {
                targetName = targetName.substring(parentIndex + parentRelativeCharacters[i].length());
                parentIndex = targetName.indexOf(parentRelativeCharacters[i]);
            }
            ++i;
        }
        dotIndex = targetName.lastIndexOf(46);
        if (dotIndex > 0) {
            targetName = targetName.substring(0, dotIndex);
        }
        if (!this.isNameUnique(String.valueOf(targetName) + ".args")) ** GOTO lbl20
        return String.valueOf(targetName) + ".args";
lbl-1000:
        // 1 sources

        {
            ++this.fBuildCommandCounter;
lbl20:
            // 2 sources

            ** while (!this.isNameUnique((String)(String.valueOf((Object)targetName) + "_" + this.fBuildCommandCounter + ".args")))
        }
lbl21:
        // 1 sources

        return String.valueOf(targetName) + "_" + this.fBuildCommandCounter + ".args";
    }

    private boolean isOutsideProjectDirectory(Path targetPath, IPath topBuildLocation) {
        if (targetPath.isAbsolute()) {
            return false;
        }
        IPath newPath = topBuildLocation.append((IPath)targetPath);
        return !topBuildLocation.isPrefixOf(newPath);
    }

    public void writeBuildCommands(IPath moduleOutputDir, IPath topBuildPath) throws CoreException {
        for (BuildCommand command : this.buildCommandList) {
            IFile argumentFile = this.generator.createFile(topBuildPath.append(command.fileName));
            StringBuffer makeBuf = new StringBuffer();
            String[] flags = Utils.mergeLinesWithQuotes(command.fileArguments.toArray(new String[command.fileArguments.size()]));
            int i = 0;
            while (i < flags.length) {
                if (i > 0) {
                    if (flags[i].startsWith("-") || flags[i].startsWith("\"")) {
                        makeBuf.append(ToolConstants.NEWLINE);
                    } else {
                        makeBuf.append(" ");
                    }
                }
                makeBuf.append(flags[i]);
                ++i;
            }
            GnuMakefileGenerator.save((StringBuffer)makeBuf, (IFile)argumentFile);
        }
        this.buildCommandList = new LinkedList<BuildCommand>();
    }

    private static String getReplacementFlag(ITool tool) {
        ITool superTool = tool;
        while (superTool != null) {
            String id = superTool.getId();
            IOption option = tool.getOptionBySuperClassId(String.valueOf(id) + ".option.file_arg");
            if (option != null) {
                String value = null;
                try {
                    value = option.getStringValue();
                    value = value.replaceAll("%20", " ");
                }
                catch (BuildException buildException) {}
                return value;
            }
            superTool = superTool.getSuperClass();
        }
        return null;
    }

    private static class BuildCommand {
        public String buildCommand;
        public LinkedList<String> fileArguments = new LinkedList();
        public String fileName;
        public ITool tool;
        public String targetName;

        private BuildCommand() {
        }
    }
}

