/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.symbols;

import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbol;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkSymbolsHolder {
    public static final String SYMBOLS_ELEMENT = "symbols";
    private final String toolChainId;
    private Map<SdkSymbolTypes, List<SdkSymbol>> symbolsByType;

    public SdkSymbolsHolder(String toolChainId) {
        this.toolChainId = toolChainId;
        this.symbolsByType = new EnumMap<SdkSymbolTypes, List<SdkSymbol>>(SdkSymbolTypes.class);
    }

    public void addSymbol(SdkSymbol symbol, SdkSymbolTypes type) {
        List<SdkSymbol> symbols = this.symbolsByType.get((Object)type);
        if (symbols == null) {
            symbols = new LinkedList<SdkSymbol>();
        }
        if (symbols.stream().noneMatch(s -> symbol.getSymbolName().equals(s.getSymbolName()) && symbol.getLangId().equals(s.getLangId()) && this.getSymbolType((SdkSymbol)s).equals((Object)type))) {
            symbols.add(symbol);
        }
        this.symbolsByType.put(type, symbols);
    }

    public void addSymbols(String symbolsString) {
        if (symbolsString == null) {
            return;
        }
        this.addSymbols(symbolsString, "", SdkSymbolTypes.DEFINED);
    }

    public void addSymbols(String symbolsString, String langId, SdkSymbolTypes type) {
        if (symbolsString == null) {
            return;
        }
        Arrays.stream(symbolsString.split(",")).map(String::trim).filter(symbolName -> !symbolName.isEmpty()).map(symbolName -> new SdkSymbol((String)symbolName, langId, this)).forEach(symbol -> this.addSymbol((SdkSymbol)symbol, type));
    }

    public void addSymbols(List<String> symbols, String langId, SdkSymbolTypes type) {
        if (symbols == null) {
            return;
        }
        symbols.stream().map(String::trim).filter(symbolName -> !symbolName.isEmpty()).map(symbolName -> new SdkSymbol((String)symbolName, langId, this)).forEach(symbol -> this.addSymbol((SdkSymbol)symbol, type));
    }

    public Map<SdkSymbolTypes, List<SdkSymbol>> getSymbols() {
        return this.symbolsByType;
    }

    public void removeSymbol(SdkSymbol symbol, SdkSymbolTypes type) {
        this.getSymbolsByType(type).remove(symbol);
    }

    public List<SdkSymbol> getSymbolsByType(SdkSymbolTypes type) {
        LinkedList symbols = this.symbolsByType.get((Object)type);
        return symbols != null ? symbols : new LinkedList();
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public void clear() {
        this.symbolsByType.clear();
    }

    public boolean isEmpty() {
        return this.symbolsByType.isEmpty();
    }

    public void convertToXml(Document document, Element sdkElement) {
        Element symbolsElement = document.createElement(SYMBOLS_ELEMENT);
        for (Map.Entry<SdkSymbolTypes, List<SdkSymbol>> e : this.symbolsByType.entrySet()) {
            e.getValue().forEach(s -> s.convertToXml(document, symbolsElement, (SdkSymbolTypes)((Object)((Object)e.getKey()))));
        }
        sdkElement.appendChild(symbolsElement);
    }

    public SdkSymbolTypes getSymbolType(SdkSymbol symbol) {
        for (Map.Entry<SdkSymbolTypes, List<SdkSymbol>> e : this.symbolsByType.entrySet()) {
            if (!e.getValue().contains(symbol)) continue;
            return e.getKey();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<SdkSymbolTypes, List<SdkSymbol>> e : this.symbolsByType.entrySet()) {
            e.getValue().forEach(s -> {
                StringBuilder stringBuilder2 = sb.append(s.toString()).append('\n');
            });
        }
        return sb.toString();
    }
}

