/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.symbols;

import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkSymbol {
    public static final String SYMBOL_ELEMENT = "symbol";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String LANG_ATTRIBUTE = "langId";
    public static final String TYPE_ATTRIBUTE = "type";
    private String symbolName;
    private final String langId;
    private final SdkSymbolsHolder holder;

    public SdkSymbol(String symbolName, String langId, SdkSymbolsHolder holder) {
        Objects.requireNonNull(symbolName);
        this.symbolName = symbolName;
        this.langId = langId != null ? langId : "";
        this.holder = holder;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public String getLangId() {
        return this.langId != null ? this.langId : "";
    }

    public SdkSymbolsHolder getHolder() {
        return this.holder;
    }

    public String getHolderToolChainId() {
        return this.holder.getToolChainId();
    }

    public boolean isCommon() {
        return this.langId == null || this.langId.isEmpty();
    }

    public void convertToXml(Document document, Element symbolsElement, SdkSymbolTypes type) {
        Element symbolElement = document.createElement(SYMBOL_ELEMENT);
        symbolElement.setAttribute(NAME_ATTRIBUTE, this.getSymbolName());
        symbolElement.setAttribute(LANG_ATTRIBUTE, this.getLangId());
        symbolElement.setAttribute(TYPE_ATTRIBUTE, type.getName());
        symbolsElement.appendChild(symbolElement);
    }
}

