/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resources;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkBinaryFileResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResource;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkKind;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkResourcesHolder {
    private final String toolChainId;
    private Map<ResourceSdkKind, Set<SdkResource>> resourcesByType;

    public SdkResourcesHolder(String toolChainId) {
        this.toolChainId = toolChainId;
        this.resourcesByType = new EnumMap<ResourceSdkKind, Set<SdkResource>>(ResourceSdkKind.class);
    }

    public void addResource(SdkResource resource) {
        this.resourcesByType.computeIfAbsent(resource.getType(), s -> new LinkedHashSet()).add(resource);
    }

    public void addResource(Element element, String sdkBasePath) {
        LinkedHashSet<SdkResource> resources = new LinkedHashSet<SdkResource>();
        switch (element.getNodeName()) {
            case "binaryFile": {
                resources.add(SdkBinaryFileResource.createResource(element, sdkBasePath));
                break;
            }
            case "headerFile": {
                SDKResourcesHandler.INSTANCE.addSdkResources(element, sdkBasePath, null, resources);
                break;
            }
            case "headerFolder": {
                SDKResourcesHandler.INSTANCE.addSdkResources(element, sdkBasePath, SDKSupportPlugin.headersMatcher, resources);
                break;
            }
            case "includeFile": {
                SDKResourcesHandler.INSTANCE.addSdkResources(element, sdkBasePath, null, resources);
            }
        }
        resources.forEach(this::addResource);
    }

    public void setResources(IConfigurationElement element, IPath sdkBasePath) {
        Set<SdkResource> binaryFiles = SDKResourcesHandler.INSTANCE.getSdkResources(element, sdkBasePath, ResourceSdkKind.BINARY_FILE, false, SDKSupportPlugin.binariesMatcher);
        this.resourcesByType.put(ResourceSdkKind.BINARY_FILE, binaryFiles != null ? binaryFiles : Collections.emptySet());
        Set<SdkResource> headers = SDKResourcesHandler.INSTANCE.getSdkResources(element, sdkBasePath, ResourceSdkKind.HEADER_FOLDER, true, SDKSupportPlugin.headersMatcher);
        this.resourcesByType.put(ResourceSdkKind.HEADER_FOLDER, headers != null ? headers : Collections.emptySet());
        Set<SdkResource> includeFiles = SDKResourcesHandler.INSTANCE.getSdkResources(element, sdkBasePath, ResourceSdkKind.INCLUDE_FILE, false, null);
        this.resourcesByType.put(ResourceSdkKind.INCLUDE_FILE, includeFiles != null ? includeFiles : Collections.emptySet());
    }

    public void setResources(Collection<SdkResource> resources) {
        this.clear();
        resources.forEach(this::addResource);
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public Map<ResourceSdkKind, Set<SdkResource>> getResources() {
        return this.resourcesByType;
    }

    public Set<SdkResource> getHeaders() {
        LinkedHashSet<SdkResource> result = new LinkedHashSet<SdkResource>();
        result.addAll(this.getResourcesByType(ResourceSdkKind.HEADER_FOLDER));
        result.addAll(this.getResourcesByType(ResourceSdkKind.HEADER_FILE));
        return result;
    }

    public Set<SdkResource> getIncludeFiles() {
        return this.getResourcesByType(ResourceSdkKind.INCLUDE_FILE);
    }

    public Set<SdkResource> getBinaryFiles() {
        return this.getResourcesByType(ResourceSdkKind.BINARY_FILE);
    }

    public void setIncludeFiles(Collection<SdkResource> includeFiles) {
        this.resourcesByType.put(ResourceSdkKind.INCLUDE_FILE, new LinkedHashSet<SdkResource>(includeFiles));
    }

    public void convertToXml(Document document, Element sdkElement, IPath sdkBasePath) {
        this.resourcesByType.entrySet().stream().flatMap(ent -> ((Set)ent.getValue()).stream()).forEach(res -> res.convertToXml(document, sdkElement, sdkBasePath));
    }

    public boolean isEmpty() {
        return this.resourcesByType.isEmpty();
    }

    public void clear() {
        this.resourcesByType.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" BINARY FILES = ").append(this.getBinaryFiles());
        sb.append(" HEADERS = ").append(this.getHeaders());
        sb.append(" INCLUDE FILES = ").append(this.getIncludeFiles());
        return sb.toString();
    }

    private Set<SdkResource> getResourcesByType(ResourceSdkKind resourceType) {
        LinkedHashSet resources = this.resourcesByType.get(resourceType);
        return resources != null ? resources : new LinkedHashSet();
    }
}

