/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resources;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkBinaryFileResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkHeaderFileResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkHeaderFolderResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkIncludeFileResource;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkKind;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SdkResource {
    public static final String BINARY_FILE_ELEMENT = "binaryFile";
    public static final String HEADER_FOLDER_ELEMENT = "headerFolder";
    public static final String HEADER_FILE_ELEMENT = "headerFile";
    public static final String INCLUDE_FILE_ELEMENT = "includeFile";
    public static final String LINKER_FILE_ELEMENT = "linkerFile";
    public static final String RESOURCE_FILE_ELEMENT = "resourceFile";
    public static final String RESOURCE_FOLDER_ELEMENT = "resourceFolder";
    public static final String SOURCE_FOLDER_ELEMENT = "sourceFolder";
    public static final String SOURCE_FILE_ELEMENT = "sourceFile";
    public static final String PATH_ATTRIBUTE = "path";
    public static final String COPY_ATTRIBUTE = "copy";
    public static final String COPY_TO_PROJECT_PATH_ATTRIBUTE = "copyToProjectPath";
    public static final String RENAME_TO_ATTRIBUTE = "renameTo";
    public static final String TO_OPEN_ATTRIBUTE = "toOpen";
    public static final String LANG_ID_ATTRIBUTE = "langId";
    private IExtendedPath path;
    private String langId;
    private ResourceSdkKind type;

    protected SdkResource(ResourceSdkKind type, IExtendedPath path) {
        this.type = type;
        this.path = Objects.requireNonNull(path);
        this.langId = null;
    }

    protected SdkResource(ResourceSdkKind type, IExtendedPath path, String langId) {
        this(type, path);
        this.langId = langId;
    }

    public ResourceSdkKind getType() {
        return this.type;
    }

    public IExtendedPath getPath() {
        return this.path;
    }

    public String getLangId() {
        return this.langId != null ? this.langId : "";
    }

    public String toString() {
        return String.valueOf(this.path.toString()) + " langId=" + this.getLangId();
    }

    public void convertToXml(Document document, Element sdkElement, IPath sdkBasePath) {
        sdkElement.appendChild(this.createResourceElement(document, sdkBasePath));
    }

    protected Element createResourceElement(Document document, IPath sdkBasePath) {
        String renameTo;
        Element resourceElement = document.createElement(this.getXmlElementName());
        resourceElement.setAttribute(PATH_ATTRIBUTE, this.path.makeRelativeTo(sdkBasePath).toOSString());
        resourceElement.setAttribute(COPY_ATTRIBUTE, Boolean.toString(this.path.isCopy()));
        resourceElement.setAttribute(LANG_ID_ATTRIBUTE, this.getLangId());
        String copyPath = this.path.copyPath();
        if (copyPath != null && !copyPath.isEmpty()) {
            resourceElement.setAttribute(COPY_TO_PROJECT_PATH_ATTRIBUTE, copyPath);
        }
        if ((renameTo = this.path.renameTo()) != null && !renameTo.isEmpty()) {
            resourceElement.setAttribute(RENAME_TO_ATTRIBUTE, renameTo);
        }
        return resourceElement;
    }

    protected abstract String getXmlElementName();

    public static SdkResource createResource(ResourceSdkKind resourceType, IExtendedPath path, String langId) {
        switch (resourceType) {
            case BINARY_FILE: {
                return new SdkBinaryFileResource(path, langId);
            }
            case HEADER_FILE: {
                return new SdkHeaderFileResource(path, langId);
            }
            case HEADER_FOLDER: {
                return path.toFile().isDirectory() ? new SdkHeaderFolderResource(path, langId) : SdkResource.createResource(ResourceSdkKind.HEADER_FILE, path, langId);
            }
            case INCLUDE_FILE: {
                return new SdkIncludeFileResource(path, langId);
            }
        }
        throw new IllegalArgumentException("Unsupported resource type");
    }

    public static String getXmlElementName(ResourceSdkKind resourceType) {
        switch (resourceType) {
            case BINARY_FILE: {
                return BINARY_FILE_ELEMENT;
            }
            case HEADER_FILE: {
                return HEADER_FILE_ELEMENT;
            }
            case HEADER_FOLDER: {
                return HEADER_FOLDER_ELEMENT;
            }
            case INCLUDE_FILE: {
                return INCLUDE_FILE_ELEMENT;
            }
            case LINKER_FILE: {
                return LINKER_FILE_ELEMENT;
            }
            case RESOURCE_FILE: {
                return RESOURCE_FILE_ELEMENT;
            }
            case SOURCE_FILE: {
                return SOURCE_FILE_ELEMENT;
            }
            case SOURCE_FOLDER: {
                return SOURCE_FOLDER_ELEMENT;
            }
        }
        return "";
    }
}

