/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resources;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResource;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkKind;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkBinaryFileResource
extends SdkResource {
    public static final String PREFIX_ATTRIBUTE = "prefix";

    public SdkBinaryFileResource(IExtendedPath path) {
        super(ResourceSdkKind.BINARY_FILE, path);
    }

    public SdkBinaryFileResource(IExtendedPath path, String langId) {
        super(ResourceSdkKind.BINARY_FILE, path, langId);
    }

    public SdkBinaryFileResource(IExtendedPath path, String langId, boolean hasPrefix) {
        super(ResourceSdkKind.BINARY_FILE, path, langId);
        this.setHasPrefix(hasPrefix);
    }

    public boolean hasPrefix() {
        return this.getPath().hasPrefix();
    }

    @Override
    public void convertToXml(Document document, Element sdkElement, IPath sdkBasePath) {
        Element resourceElement = this.createResourceElement(document, sdkBasePath);
        resourceElement.setAttribute(PREFIX_ATTRIBUTE, Boolean.toString(this.hasPrefix()));
        sdkElement.appendChild(resourceElement);
    }

    @Override
    protected String getXmlElementName() {
        return "binaryFile";
    }

    public static SdkBinaryFileResource createResource(Element element, String sdkBasePath) {
        SdkBinaryFileResource binaryFileResource = (SdkBinaryFileResource)SDKResourcesHandler.INSTANCE.getSdkResource(element, sdkBasePath);
        String prefixAttribute = element.getAttribute(PREFIX_ATTRIBUTE);
        if (prefixAttribute != null && !prefixAttribute.isEmpty()) {
            binaryFileResource.setHasPrefix(Boolean.parseBoolean(prefixAttribute));
        }
        return binaryFileResource;
    }

    void setHasPrefix(boolean hasPrefix) {
        this.getPath().setHasPrefix(hasPrefix);
    }
}

