/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resources;

import com.nxp.s32ds.cle.ide.sdk.core.resources.ProjectSourceFolder;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectStructure {
    public static final String PROJECT_STRUCTURE_ELEMENT = "projectStructure";
    private String toolChainId;
    private Set<ProjectSourceFolder> projectSourceFolders;

    public ProjectStructure(String toolChainId) {
        this.toolChainId = toolChainId;
        this.projectSourceFolders = new LinkedHashSet<ProjectSourceFolder>();
    }

    public void addProjectSourceFolder(ProjectSourceFolder projectSourceFolder) {
        if (projectSourceFolder.isValidPath()) {
            this.projectSourceFolders.add(projectSourceFolder);
        }
    }

    public Set<ProjectSourceFolder> getProjectSourceFolders() {
        return this.projectSourceFolders;
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public boolean isEmpty() {
        return this.projectSourceFolders.isEmpty();
    }

    public void clear() {
        this.projectSourceFolders.clear();
    }

    public void convertToXml(Document document, Element sdkElement) {
        if (!this.projectSourceFolders.isEmpty()) {
            Element projectSourceFoldersElement = document.createElement(PROJECT_STRUCTURE_ELEMENT);
            this.projectSourceFolders.forEach(psf -> psf.convertToXml(document, projectSourceFoldersElement));
            sdkElement.appendChild(projectSourceFoldersElement);
        }
    }

    public static ProjectStructure parse(Element sourceFoldersElement, String toolChainId) {
        ProjectStructure projectSourceFolders = new ProjectStructure(toolChainId);
        NodeList sourceFolderElements = sourceFoldersElement.getElementsByTagName("projectSourceFolder");
        int i = 0;
        while (i < sourceFolderElements.getLength()) {
            projectSourceFolders.addProjectSourceFolder(ProjectSourceFolder.parse((Element)sourceFolderElements.item(i)));
            ++i;
        }
        return projectSourceFolders;
    }

    public static ProjectStructure parse(IConfigurationElement sourceFoldersElement, String toolChainId) {
        ProjectStructure projectSourceFolders = new ProjectStructure(toolChainId);
        Arrays.stream(sourceFoldersElement.getChildren("projectSourceFolder")).forEach(e -> projectSourceFolders.addProjectSourceFolder(ProjectSourceFolder.parse(e)));
        return projectSourceFolders;
    }
}

