/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.platform;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SdkPlatform {
    public static final String PLATFORM_ELEMENT = "platform";
    public static final String TARGET_ATTRIBUTE = "target";
    public static final String HOST_ATTRIBUTE = "host";
    private String target;
    private String host;

    public String getTarget() {
        return this.target;
    }

    public String getHost() {
        return this.host;
    }

    public SdkPlatform(String target, String host) {
        this.target = target == null ? null : target.toLowerCase();
        this.host = host == null ? null : host.toLowerCase();
    }

    public void convertToXml(Document document, Element sdkElement) {
        Element platformElement = document.createElement(PLATFORM_ELEMENT);
        platformElement.setAttribute(TARGET_ATTRIBUTE, this.getTarget());
        platformElement.setAttribute(HOST_ATTRIBUTE, this.getHost());
        sdkElement.appendChild(platformElement);
    }

    public static SdkPlatform parseElement(Object element) {
        NodeList platformElements;
        if (element instanceof IConfigurationElement) {
            IConfigurationElement[] platformElements2 = ((IConfigurationElement)element).getChildren(PLATFORM_ELEMENT);
            if (platformElements2 != null && platformElements2.length > 0) {
                IConfigurationElement platformElement = platformElements2[0];
                return new SdkPlatform(platformElement.getAttribute(TARGET_ATTRIBUTE), platformElement.getAttribute(HOST_ATTRIBUTE));
            }
        } else if (element instanceof Element && (platformElements = ((Element)element).getElementsByTagName(PLATFORM_ELEMENT)) != null && platformElements.getLength() > 0) {
            Element platformElement = (Element)platformElements.item(0);
            return new SdkPlatform(platformElement.getAttribute(TARGET_ATTRIBUTE), platformElement.getAttribute(HOST_ATTRIBUTE));
        }
        SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", "Unable to parse \"platform\" element."));
        return null;
    }

    public static SdkPlatform parseElement(Element element) {
        return new SdkPlatform(element.getAttribute(TARGET_ATTRIBUTE), element.getAttribute(HOST_ATTRIBUTE));
    }
}

