/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.modules;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.ISDKSmartFilter;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkModulesHolder {
    public static final String MODULES_ELEMENT = "modules";
    private final String sdkId;
    private SdkModule rootModule;
    private Set<SdkModule> refModules;

    public SdkModulesHolder(String sdkId, String name, String description) {
        this.sdkId = Objects.requireNonNull(sdkId, "Holder SDK id shouldn't be null");
        this.refModules = new LinkedHashSet<SdkModule>();
        this.rootModule = this.initRootModule(name, description);
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public SdkModule getRootModule() {
        return this.rootModule;
    }

    public Set<SdkModule> getModules() {
        LinkedHashSet<SdkModule> result = new LinkedHashSet<SdkModule>();
        result.add(this.rootModule);
        result.addAll(this.refModules);
        return result;
    }

    public Set<SdkModule> getModules(String toolChainId) {
        LinkedHashSet<SdkModule> result = new LinkedHashSet<SdkModule>();
        if (toolChainId == null || toolChainId.isEmpty()) {
            result.add(this.rootModule);
        } else {
            SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
            if (this.rootModule.checkToolChainCompatibility(toolChainId, checker).isOK()) {
                result.add(this.rootModule);
            }
        }
        result.addAll(this.getRefModules(toolChainId));
        return result;
    }

    public Set<SdkModule> getModules(ISDKFilter filter) {
        LinkedHashSet<SdkModule> result = new LinkedHashSet<SdkModule>();
        result.add(this.rootModule);
        result.addAll(this.getRefModules(filter));
        return result;
    }

    public Set<SdkModule> getRefModules() {
        return this.refModules;
    }

    public Set<SdkModule> getRefModules(String toolChainId) {
        if (toolChainId == null || toolChainId.isEmpty()) {
            return this.refModules;
        }
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        return this.refModules.stream().filter(m -> m.checkToolChainCompatibility(toolChainId, checker).isOK()).collect(Collectors.toSet());
    }

    public Set<SdkModule> getRefModules(ISDKFilter filter) {
        return this.refModules.stream().filter(module -> module.getSdk() != null && ((ISDKSmartFilter)filter).acceptOptions(module.getSdk())).collect(Collectors.toSet());
    }

    public IStatus addRefModule(SdkModule refModule) {
        ISDK refModuleSdk = refModule.getSdk();
        if (refModuleSdk != null && refModuleSdk.getModules().hasModules()) {
            Status status = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SdkModulesHolder_module_sdk_refers_to_other_modules, (Object)refModule.getId()), null);
            SDKSupportPlugin.log((IStatus)status);
            return status;
        }
        this.refModules.add(refModule);
        return Status.OK_STATUS;
    }

    public void convertToXml(Document document, Element sdkElement) {
        Element modulesElement = document.createElement(MODULES_ELEMENT);
        this.refModules.forEach(module -> module.convertToXml(document, modulesElement));
        sdkElement.appendChild(modulesElement);
    }

    public List<ISDK> getModulesSdks() {
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        ISDK rootSdk = SDKUtils.getSDKbyID(this.rootModule.getSdkId());
        result.add(Objects.requireNonNull(rootSdk, "Fatal error: holder SDK not found."));
        result.addAll(this.getRefModulesSdks());
        return result;
    }

    public List<ISDK> getRefModulesSdks() {
        return this.refModules.stream().map(module -> SDKUtils.getSDKbyID(module.getSdkId())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ISDK> getRefModulesSdks(ISDKFilter filter) {
        return this.refModules.stream().map(module -> SDKUtils.getSDKbyID(module.getSdkId())).filter(Objects::nonNull).filter(((ISDKSmartFilter)filter)::acceptOptions).collect(Collectors.toList());
    }

    public List<String> getRefModulesSdksIds() {
        return this.refModules.stream().map(SdkModule::getSdkId).collect(Collectors.toList());
    }

    public Set<IPath> getModulesBasePaths() {
        return this.getBasePaths(this.getModulesSdks());
    }

    public Set<IPath> getRefModulesBasePaths() {
        return this.getBasePaths(this.getRefModulesSdks());
    }

    public Set<IEnvironment> getModulesEnvironments() {
        return this.getEnvironments(this.getModulesSdks());
    }

    public Set<IEnvironment> getRefModulesEnvironments() {
        return this.getEnvironments(this.getRefModulesSdks());
    }

    public ISDK getRootSdk() {
        return SDKUtils.getSDKbyID(this.sdkId);
    }

    public Map<IEnvironment, Set<IExtendedPath>> getPathsGroupByEnvironment(List<IExtendedPath> paths) {
        HashMap<IEnvironment, Set<IExtendedPath>> result = new HashMap<IEnvironment, Set<IExtendedPath>>();
        for (IEnvironment sdkEnvironment : this.getModulesEnvironments()) {
            IPath environmentPath = Path.fromOSString((String)SDKSupportPlugin.performStringSubstitution(sdkEnvironment.getValue(), null));
            paths.stream().filter(arg_0 -> ((IPath)environmentPath).isPrefixOf(arg_0)).forEach(path -> {
                boolean bl = result.computeIfAbsent(sdkEnvironment, s -> new LinkedHashSet()).add(path);
            });
        }
        return result;
    }

    public boolean removeRefModule(String refModuleId) {
        return this.refModules.removeIf(m -> refModuleId.equals(m.getId()));
    }

    public boolean hasModules() {
        return !this.refModules.isEmpty();
    }

    private SdkModule initRootModule(String name, String description) {
        return new SdkModule(this.sdkId, name, description, this.sdkId);
    }

    private Set<IPath> getBasePaths(List<ISDK> sdks) {
        return sdks.stream().map(SDKSupportPlugin::getEclipsePath).collect(Collectors.toSet());
    }

    private Set<IEnvironment> getEnvironments(List<ISDK> sdks) {
        return sdks.stream().map(ISDK::getEnv).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

