/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.modules;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.ISDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkModule {
    public static final String MODULE_ELEMENT = "module";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String SDK_ID_ATTRIBUTE = "sdkId";
    private final String id;
    private final String name;
    private String description;
    private final String sdkId;
    private boolean isRoot;

    public SdkModule(String id, String name, String description, String sdkId) {
        this.id = Objects.requireNonNull(id, "Module id should not be null");
        this.name = Objects.requireNonNull(name, "Module name should not be null");
        this.description = description;
        this.sdkId = Objects.requireNonNull(sdkId, "Module SDK id should not be null");
        this.isRoot = true;
    }

    public SdkModule(String id, String name, String description, String sdkId, boolean isRoot) {
        this(id, name, description, sdkId);
        this.isRoot = isRoot;
    }

    public SdkModule(Element moduleElement) {
        this.id = moduleElement.getAttribute(ID_ATTRIBUTE);
        this.name = moduleElement.getAttribute(NAME_ATTRIBUTE);
        this.description = moduleElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.sdkId = moduleElement.getAttribute(SDK_ID_ATTRIBUTE);
        this.isRoot = false;
    }

    public SdkModule(IConfigurationElement moduleElement) {
        this.id = moduleElement.getAttribute(ID_ATTRIBUTE);
        this.name = moduleElement.getAttribute(NAME_ATTRIBUTE);
        this.description = moduleElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.sdkId = moduleElement.getAttribute(SDK_ID_ATTRIBUTE);
        this.isRoot = false;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public ISDK getSdk() {
        return this.getSdkInternal();
    }

    public IPath getBasePath() {
        ISDK sdk = this.getSdkInternal();
        return sdk != null ? SDKSupportPlugin.getEclipsePath(sdk) : null;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void convertToXml(Document document, Element modulesElement) {
        Element moduleElement = document.createElement(MODULE_ELEMENT);
        moduleElement.setAttribute(ID_ATTRIBUTE, this.getId());
        moduleElement.setAttribute(NAME_ATTRIBUTE, this.getName());
        moduleElement.setAttribute(DESCRIPTION_ATTRIBUTE, this.getDescription());
        moduleElement.setAttribute(SDK_ID_ATTRIBUTE, this.getSdkId());
        modulesElement.appendChild(moduleElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sdkId == null ? 0 : this.sdkId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkModule other = (SdkModule)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.sdkId.equals(other.sdkId);
    }

    public IStatus checkToolChainCompatibility(String toolChainId, ISDKCompatibilityChecker checker) {
        if ("all_toolchains".equals(toolChainId)) {
            return Status.OK_STATUS;
        }
        ISDK sdk = this.getSdk();
        if (sdk == null) {
            return ISDKAttachStatuses.ERROR_SDK_MISSED;
        }
        String[] sdkToolChainIds = sdk.getToolChainIDs();
        if (sdkToolChainIds == null || sdkToolChainIds.length == 0) {
            return Status.OK_STATUS;
        }
        return checker.checkToolchainsCompatibility(sdkToolChainIds[0], toolChainId);
    }

    private ISDK getSdkInternal() {
        ISDK sdk = SDKUtils.getSDKbyID(this.sdkId);
        if (sdk == null) {
            SDKSupportPlugin.error("Referenced SDK does not exist", null);
        }
        return sdk;
    }
}

