/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.attach;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKFilesChecker;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkAttachUtils {
    public static IStatus restoreProjectSdkFolders(ISDK sdk, List<IExtendedPath> missedPaths, IProject project) {
        try {
            List<IConfiguration> attachedConfigs = SDKAttach.getAttached(project, sdk);
            IFolder sdkFolder = project.getFolder(sdk.getTargetFolderName());
            SDKUtils.restoreSDKFolder(sdkFolder, attachedConfigs);
            Map<IEnvironment, Set<IExtendedPath>> pathsToRestore = sdk.getModules().getPathsGroupByEnvironment(missedPaths);
            Set<IExtendedPath> sdkPaths = pathsToRestore.getOrDefault(sdk.getEnv(), Collections.emptySet());
            SdkAttachUtils.restoreSdkFolders(sdk, project, attachedConfigs, null, sdkPaths);
            List<ISDK> refSdks = sdk.getModules().getRefModulesSdks();
            for (ISDK refSdk : refSdks) {
                sdkPaths = pathsToRestore.getOrDefault(refSdk.getEnv(), Collections.emptySet());
                SdkAttachUtils.restoreSdkFolders(refSdk, project, attachedConfigs, sdkFolder, sdkPaths);
            }
        }
        catch (CoreException ce) {
            Status errorStatus = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Unable to restore project folders for SDK {0}: {1}", (Object)sdk.getId(), (Object)ce.getMessage()));
            SDKSupportPlugin.log((IStatus)errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public static Map<String, Set<IExtendedPath>> checkMissedSdkTargetFiles(IProject project, List<ISDK> attachedSdks) {
        ArrayList<ISDK> preparedAttachedSdks = new ArrayList<ISDK>();
        List aggregatedSdks = attachedSdks.stream().filter(sdk -> sdk.getModules().hasModules()).collect(Collectors.toList());
        attachedSdks.removeAll(aggregatedSdks);
        for (ISDK aggregatedSdk : aggregatedSdks) {
            preparedAttachedSdks.add(aggregatedSdk);
            aggregatedSdk.getModules().getRefModulesSdks().stream().forEach(attachedSdks::remove);
        }
        preparedAttachedSdks.addAll(attachedSdks);
        HashMap<String, Set<IExtendedPath>> checkResults = new HashMap<String, Set<IExtendedPath>>();
        for (ISDK sdk2 : preparedAttachedSdks) {
            Map<String, Set<IExtendedPath>> resultFiles = SDKFilesChecker.getFilesChecker(sdk2, project, ISDKFilesChecker.Mode.MISSED).checkFiles().getResultFiles();
            for (Map.Entry<String, Set<IExtendedPath>> e : resultFiles.entrySet()) {
                String sdkId = e.getKey();
                Set<IExtendedPath> missedPaths = e.getValue();
                if (aggregatedSdks.isEmpty()) {
                    checkResults.computeIfAbsent(sdkId, s -> new HashSet()).addAll(missedPaths);
                    continue;
                }
                for (ISDK asdk : aggregatedSdks) {
                    String asdkId = asdk.getId();
                    if (asdk.getModules().getRefModulesSdksIds().contains(sdkId)) {
                        checkResults.computeIfAbsent(asdkId, s -> new HashSet()).addAll(missedPaths);
                        continue;
                    }
                    checkResults.computeIfAbsent(sdkId, s -> new HashSet()).addAll(missedPaths);
                }
            }
        }
        return checkResults;
    }

    private static void restoreSdkFolders(ISDK sdk, IProject project, List<IConfiguration> attachedConfigs, IFolder holderSdkFolder, Set<IExtendedPath> pathsToRestore) throws CoreException {
        if (pathsToRestore.isEmpty()) {
            return;
        }
        IPath sdkBasePath = SDKSupportPlugin.getEclipsePath(sdk);
        String targetFolderName = sdk.getTargetFolderName();
        IFolder sdkFolder = holderSdkFolder == null ? project.getFolder(targetFolderName) : holderSdkFolder.getFolder(targetFolderName);
        for (IExtendedPath path : pathsToRestore) {
            String copyPath = path.copyPath();
            if (copyPath != null && !copyPath.isEmpty() && !copyPath.equals(".")) {
                SDKUtils.restoreSDKFolder(project.getFolder(copyPath), attachedConfigs);
                continue;
            }
            IPath srcRelPath = path.makeRelativeTo(sdkBasePath);
            IFolder folder = sdkFolder;
            int i = 0;
            while (i < srcRelPath.segmentCount() - 1) {
                folder = folder.getFolder(srcRelPath.segment(i));
                SDKUtils.restoreSDKFolder(folder, attachedConfigs);
                ++i;
            }
        }
    }
}

