/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeListener;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventParser;
import com.nxp.s32ds.cle.ide.sdk.core.ContributedSdkHandler;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerComponent;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkComponentChangeEventHandler
implements ComponentChangeListener {
    public void onComponentChange(ComponentChangeEvent event) {
        ComponentChangeEventParser parser = new ComponentChangeEventParser(event);
        if (!"software_package".equals(parser.getArchetype())) {
            return;
        }
        Object object = event.getParameters().get("payload");
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.stream().filter(obj -> obj instanceof SoftwareManagerPackageDescriptor).flatMap(obj -> ((SoftwareManagerPackageDescriptor)obj).getComponents().stream()).filter(component -> "sdk".equals(component.getType())).map(SoftwareManagerComponent::getManifest).forEach(this::handleSdkDescriptor);
        }
    }

    private void handleSdkDescriptor(String sdkDescriptorFilePath) {
        Map<IStatus, List<ISDK>> result = ContributedSdkHandler.loadFromDescriptorFile(sdkDescriptorFilePath, true);
        List<ISDK> loadedSdks = result.get(Status.OK_STATUS);
        if (loadedSdks != null) {
            loadedSdks.stream().forEach(sdk -> SDKSupportPlugin.log(NLS.bind((String)"SDK {0} loaded successfully", (Object)sdk.getBriefInfo())));
        }
    }
}

