/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.processors.ISourcePathProcessor;
import com.freescale.s32ds.cross.sdk.processors.OpenProcessor;
import com.freescale.s32ds.cross.sdk.processors.RemoveProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResource;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkKind;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class SDKResourcesHandler {
    public static final SDKResourcesHandler INSTANCE = new SDKResourcesHandler();
    private static final String PROJ_DIR_PATH = "ProjDirPath";

    public IFile getTargetFile(IExtendedPath sdkFile, ISDK sdk, IProject project) {
        return (IFile)this.getTargetResource(sdkFile, sdk, project);
    }

    public IResource getTargetResource(IExtendedPath sdkFile, ISDK sdk, IProject project) {
        return this.getTargetResource(sdkFile, sdk, project, null);
    }

    public IResource getTargetResource(IExtendedPath sdkFile, ISDK sdk, IProject project, ISDK holderSdk) {
        Object file = null;
        String copyPath = sdkFile.copyPath();
        String renameTo = sdkFile.renameTo();
        if (this.isCopyToProjectRoot(copyPath)) {
            file = this.isRenamed(renameTo) ? project.getFile(renameTo) : project.getFile(sdkFile.lastSegment());
        } else {
            IPath srcRelPath = sdkFile.makeRelativeTo(SDKSupportPlugin.getEclipsePath(sdk));
            try {
                IFolder folder = this.getFolder(srcRelPath, copyPath, sdk, project, holderSdk);
                String lastSegment = srcRelPath.lastSegment();
                if (folder != null && lastSegment != null) {
                    file = sdkFile.toFile().isDirectory() ? (this.isRenamed(renameTo) ? folder.getFolder(renameTo) : folder.getFolder(lastSegment)) : (this.isRenamed(renameTo) ? folder.getFile(renameTo) : folder.getFile(lastSegment));
                }
            }
            catch (Exception e) {
                SDKSupportPlugin.error(e);
            }
        }
        return file;
    }

    public void removeResourcesFromProject(ISDK sdk, IProject project, String toolChainId) {
        IFolder projectSdkFolder = project.getFolder(sdk.getTargetFolderName());
        if (projectSdkFolder.isVirtual()) {
            return;
        }
        List<IExtendedPath> toRemove = Arrays.stream(sdk.getResources(toolChainId)).flatMap(Arrays::stream).collect(Collectors.toList());
        if (toRemove.isEmpty()) {
            return;
        }
        Map<IEnvironment, Set<IExtendedPath>> pathsToRemove = sdk.getModules().getPathsGroupByEnvironment(toRemove);
        if (pathsToRemove == null || pathsToRemove.isEmpty()) {
            return;
        }
        RemoveProcessor removeProcessor = new RemoveProcessor();
        pathsToRemove.getOrDefault(sdk.getEnv(), Collections.emptySet()).forEach(path -> this.removeResource(this.getTargetResource((IExtendedPath)path, sdk, project), removeProcessor));
        for (ISDK refSdk : sdk.getModules().getRefModulesSdks()) {
            pathsToRemove.getOrDefault(refSdk.getEnv(), Collections.emptySet()).forEach(path -> this.removeResource(this.getTargetResource((IExtendedPath)path, refSdk, project, sdk), removeProcessor));
        }
    }

    public boolean openTargetResources(ISDK sdk, IProject project, String toolChainId) {
        List<IExtendedPath> toOpen = Arrays.stream(sdk.getResources(toolChainId)).flatMap(Arrays::stream).filter(IExtendedPath::toOpen).collect(Collectors.toList());
        if (toOpen.isEmpty()) {
            return false;
        }
        Map<IEnvironment, Set<IExtendedPath>> pathsToOpen = sdk.getModules().getPathsGroupByEnvironment(toOpen);
        if (pathsToOpen == null || pathsToOpen.isEmpty()) {
            return false;
        }
        OpenProcessor openProcessor = new OpenProcessor();
        pathsToOpen.getOrDefault(sdk.getEnv(), Collections.emptySet()).forEach(path -> this.openResource(this.getTargetResource((IExtendedPath)path, sdk, project), openProcessor));
        AvailableSDKFilter sdkFilter = new AvailableSDKFilter(project);
        for (ISDK refSdk : sdk.getModules().getRefModulesSdks(sdkFilter)) {
            pathsToOpen.getOrDefault(refSdk.getEnv(), Collections.emptySet()).forEach(path -> this.openResource(this.getTargetResource((IExtendedPath)path, refSdk, project, sdk), openProcessor));
        }
        return true;
    }

    public Map<String, List<IExtendedPath>> getResourcesGroupByToolChainsIds(ISDK sdk, int resourceType) {
        TCHolder[] holders;
        LinkedHashMap<String, List<IExtendedPath>> result = new LinkedHashMap<String, List<IExtendedPath>>();
        TCHolder rootHolder = sdk.getRoot();
        if (rootHolder != null) {
            Arrays.stream(rootHolder.get(resourceType)).forEach(ep -> {
                boolean bl = result.computeIfAbsent(rootHolder.getTCId(), s -> new ArrayList()).add(ep);
            });
        }
        if ((holders = sdk.getToolchains()) != null) {
            TCHolder[] tCHolderArray = holders;
            int n = holders.length;
            int n2 = 0;
            while (n2 < n) {
                TCHolder toolChainHolder = tCHolderArray[n2];
                String toolChainId = toolChainHolder.getTCId();
                Arrays.stream(toolChainHolder.get(resourceType)).forEach(ep -> {
                    boolean bl = result.computeIfAbsent(toolChainId, s -> new ArrayList()).add(ep);
                });
                ++n2;
            }
        }
        if (sdk.getModules().hasModules()) {
            sdk.getModules().getRefModulesSdks().stream().map(refSdk -> this.getResourcesGroupByToolChainsIds((ISDK)refSdk, resourceType)).forEach(map2 -> map2.entrySet().forEach(e -> {
                boolean bl = result.computeIfAbsent((String)e.getKey(), s -> new ArrayList()).addAll((Collection)e.getValue());
            }));
        }
        return result;
    }

    public String[] getResourcePaths(ISDK sdk, ISDKFilter filter, String configToolChainId, int resourceType) {
        return this.getResourcePaths(sdk, filter, configToolChainId, resourceType, "");
    }

    public String[] getResourcePaths(ISDK sdk, ISDKFilter filter, String configToolChainId, int resourceType, String langId) {
        AbstractSDK asdk = (AbstractSDK)sdk;
        switch (resourceType) {
            case 2: {
                return asdk.getBinariesPaths(filter, configToolChainId);
            }
            case 1: {
                return asdk.getIncludePaths(filter, configToolChainId, langId);
            }
            case 5: {
                return this.getResourcesPathsStrings(asdk.getResourcesPaths(filter, configToolChainId, resourceType, langId));
            }
            case 4: {
                return this.getResourcesPathsStrings(sdk.getResourcesPaths(filter, configToolChainId, resourceType));
            }
        }
        return new String[0];
    }

    public Set<String> getResourcePaths(ISDK sdk, String toolChainId, int resourceType) {
        List<IExtendedPath> paths = null;
        switch (resourceType) {
            case 2: {
                return this.getBinaryFiles(sdk, toolChainId);
            }
            case 1: {
                paths = Arrays.asList(sdk.getHeaders(toolChainId));
                break;
            }
            case 5: {
                paths = sdk.getIncludeFiles(toolChainId);
                break;
            }
            case 4: {
                paths = Arrays.asList(sdk.getLinkerFiles(toolChainId));
                break;
            }
            case 3: {
                paths = Arrays.asList(sdk.getOtherResources(toolChainId));
                break;
            }
            case 0: {
                paths = Arrays.asList(sdk.getSources(toolChainId));
                break;
            }
        }
        if (paths == null || paths.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        paths.stream().filter(p -> !p.toFile().isDirectory()).map(p -> this.getResourcePathString((IExtendedPath)p, sdk)).filter(Objects::nonNull).forEach(result::add);
        return result;
    }

    public String getResourcePathString(IExtendedPath path, ISDK sdk) {
        IPath sdkBasePath = SDKSupportPlugin.getEclipsePath(sdk);
        if (sdkBasePath == null || sdkBasePath.isEmpty()) {
            return null;
        }
        IPath relative = path.makeRelativeTo(sdkBasePath);
        if (path.isCopy()) {
            String copyPath = path.copyPath();
            String renameTo = path.renameTo();
            if (copyPath != null) {
                String fileName;
                String string = fileName = this.isRenamed(renameTo) ? renameTo : path.lastSegment();
                if (this.isCopyToProjectRoot(copyPath)) {
                    return this.generateResourcePathString((IPath)new Path(fileName), PROJ_DIR_PATH);
                }
                return this.generateResourcePathString((IPath)new Path(String.valueOf(copyPath) + '/' + fileName), PROJ_DIR_PATH);
            }
            return this.getResourcePathStringBasedOnSdkEnvironment(sdk, relative);
        }
        return this.getResourcePathStringBasedOnSdkEnvironment(sdk, relative);
    }

    public String generateResourcePathString(IPath path, String name) {
        String pathString = path.toString();
        if (pathString.endsWith("/") || pathString.endsWith("\\")) {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        return '\"' + VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(name, null) + '/' + pathString + '\"';
    }

    public Map<Integer, List<IExtendedPath>> getResources(ISDK sdk, String toolChainId) {
        HashMap<Integer, List<IExtendedPath>> resources = new HashMap<Integer, List<IExtendedPath>>();
        resources.put(2, Arrays.asList(sdk.getBinaries(toolChainId)));
        resources.put(1, Arrays.asList(sdk.getHeaders(toolChainId)));
        resources.put(4, Arrays.asList(sdk.getLinkerFiles(toolChainId)));
        resources.put(3, Arrays.asList(sdk.getOtherResources(toolChainId)));
        resources.put(0, Arrays.asList(sdk.getSources(toolChainId)));
        return resources;
    }

    public Map<String, Boolean> getBinaryFiles(ISDK sdk, ISDKFilter filter, String toolChainId) {
        return this.getBinaryFilesPathsStrings(((AbstractSDK)sdk).getBinaryFiles(filter, toolChainId));
    }

    public Set<SdkResource> getSdkResources(IConfigurationElement parentElement, IPath sdkRootPath, ResourceSdkKind resourceType, boolean isFolder, PathMatcher matcher) {
        IConfigurationElement[] elements;
        LinkedHashSet<SdkResource> sdkResources = new LinkedHashSet<SdkResource>();
        IConfigurationElement[] iConfigurationElementArray = elements = parentElement.getChildren(SdkResource.getXmlElementName(resourceType));
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IPath sourcePath = sdkRootPath.append(Path.fromOSString((String)this.getPath(element)));
            String langId = element.getAttribute("langId");
            if (isFolder) {
                this.processFolder(element, sourcePath, langId, matcher, sdkResources);
            } else {
                sdkResources.add(SdkResource.createResource(resourceType, this.getExtendedPath(sourcePath, element), langId));
            }
            ++n2;
        }
        return sdkResources;
    }

    public void addSdkResources(Element element, String sdkBasePath, PathMatcher matcher, Set<SdkResource> sdkResources) {
        String path = element.getAttribute("path");
        String langId = element.getAttribute("langId");
        String fullPath = path;
        if (sdkBasePath != null) {
            String string = fullPath = path.startsWith(sdkBasePath) ? path : String.format("%s/%s", sdkBasePath, path).replace('\\', '/');
        }
        if (matcher != null) {
            IPath sourcePath = new Path(sdkBasePath).append(Path.fromOSString((String)path));
            this.processFolder(element, sourcePath, langId, matcher, sdkResources);
        } else {
            sdkResources.add(SdkResource.createResource(this.getResourceType(element), this.getExtendedPath(fullPath, element), langId));
        }
    }

    public SdkResource getSdkResource(Element element, String sdkBasePath) {
        String path = element.getAttribute("path");
        String langId = element.getAttribute("langId");
        String fullPath = path;
        if (sdkBasePath != null) {
            fullPath = path.startsWith(sdkBasePath) ? path : NLS.bind((String)"{0}/{1}", (Object)sdkBasePath, (Object)path).replace('\\', '/');
        }
        return SdkResource.createResource(this.getResourceType(element), this.getExtendedPath(fullPath, element), langId);
    }

    private ResourceSdkKind getResourceType(Element element) {
        return this.getResourceType(element.getNodeName());
    }

    private ResourceSdkKind getResourceType(IConfigurationElement element) {
        return this.getResourceType(element.getName());
    }

    private ResourceSdkKind getResourceType(String xmlElementName) {
        switch (xmlElementName) {
            case "binaryFile": {
                return ResourceSdkKind.BINARY_FILE;
            }
            case "headerFile": {
                return ResourceSdkKind.HEADER_FILE;
            }
            case "headerFolder": {
                return ResourceSdkKind.HEADER_FOLDER;
            }
            case "includeFile": {
                return ResourceSdkKind.INCLUDE_FILE;
            }
            case "linkerFile": {
                return ResourceSdkKind.LINKER_FILE;
            }
            case "resourceFile": {
                return ResourceSdkKind.RESOURCE_FILE;
            }
            case "sourceFile": {
                return ResourceSdkKind.SOURCE_FILE;
            }
            case "sourceFolder": {
                return ResourceSdkKind.SOURCE_FOLDER;
            }
        }
        throw new IllegalArgumentException("Unsupported element");
    }

    private String getPath(IConfigurationElement element) {
        String path = element.getAttribute("path");
        if (path != null) {
            while (path.length() > 1 && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
                path = path.substring(1);
            }
        }
        return path;
    }

    private IExtendedPath getExtendedPath(IPath sourcePath, IConfigurationElement element) {
        return ExtendedPath.fromOSString(sourcePath.toOSString(), Boolean.parseBoolean(element.getAttribute("copy")), element.getAttribute("copyToProjectPath"), element.getAttribute("renameTo"), true, Boolean.parseBoolean(element.getAttribute("toOpen")), false);
    }

    private IExtendedPath getExtendedPath(String sourcePath, Element element) {
        return ExtendedPath.fromOSString(sourcePath, Boolean.parseBoolean(element.getAttribute("copy")), element.getAttribute("copyToProjectPath"), element.getAttribute("renameTo"), true, Boolean.parseBoolean(element.getAttribute("toOpen")), false);
    }

    private void processFolder(IConfigurationElement element, IPath sourcePath, String langId, PathMatcher matcher, Collection<SdkResource> resources) {
        ArrayList<IExtendedPath> sdkPaths = new ArrayList<IExtendedPath>();
        TCHolder.processFolder(sdkPaths, sourcePath, Boolean.parseBoolean(element.getAttribute("copy")), element.getAttribute("copyToProjectPath"), element.getAttribute("renameTo"), true, Boolean.parseBoolean(element.getAttribute("toOpen")), matcher);
        sdkPaths.stream().map(p -> SdkResource.createResource(this.getResourceType(element), p, langId)).forEach(res -> {
            resources.removeIf(r -> this.isResourceOverridenByLangId((SdkResource)r, (SdkResource)res));
            resources.add((SdkResource)res);
        });
    }

    private void processFolder(Element element, IPath sourcePath, String langId, PathMatcher matcher, Collection<SdkResource> resources) {
        ArrayList<IExtendedPath> sdkPaths = new ArrayList<IExtendedPath>();
        TCHolder.processFolder(sdkPaths, sourcePath, Boolean.parseBoolean(element.getAttribute("copy")), element.getAttribute("copyToProjectPath"), element.getAttribute("renameTo"), true, Boolean.parseBoolean(element.getAttribute("toOpen")), matcher);
        sdkPaths.stream().map(p -> SdkResource.createResource(this.getResourceType(element), p, langId)).forEach(res -> {
            resources.removeIf(r -> this.isResourceOverridenByLangId((SdkResource)r, (SdkResource)res));
            resources.add((SdkResource)res);
        });
    }

    private boolean isResourceOverridenByLangId(SdkResource resourceToCheck, SdkResource newResource) {
        return resourceToCheck.getPath().equals(newResource.getPath()) && resourceToCheck.getType().equals((Object)newResource.getType()) && resourceToCheck.getLangId().isEmpty() && !newResource.getLangId().isEmpty();
    }

    private String[] getResourcesPathsStrings(Map<String, Set<IExtendedPath>> resourcesPathsGroupBySdk) {
        LinkedHashSet result = new LinkedHashSet();
        for (Map.Entry<String, Set<IExtendedPath>> e : resourcesPathsGroupBySdk.entrySet()) {
            String sdkId = e.getKey();
            ISDK xsdk = SDKUtils.getSDKbyID(sdkId);
            Set<IExtendedPath> sdkPaths = e.getValue();
            if (sdkPaths == null) continue;
            sdkPaths.stream().filter(path -> !path.isDirectory()).map(path -> this.getResourcePathString((IExtendedPath)path, xsdk)).filter(Objects::nonNull).forEach(result::add);
        }
        return result.toArray(new String[0]);
    }

    private Map<String, Boolean> getBinaryFilesPathsStrings(Map<String, Set<IExtendedPath>> binaryFilesGroupBySdk) {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, Set<IExtendedPath>> e : binaryFilesGroupBySdk.entrySet()) {
            String sdkId = e.getKey();
            ISDK sdk = SDKUtils.getSDKbyID(sdkId);
            Set<IExtendedPath> binaryFileResources = e.getValue();
            if (binaryFileResources == null) continue;
            for (IExtendedPath binaryFilePath : binaryFileResources) {
                String binaryFilePathString = this.getResourcePathString(binaryFilePath, sdk);
                if (binaryFilePathString == null) continue;
                result.put(binaryFilePathString, binaryFilePath.hasPrefix());
            }
        }
        return result;
    }

    private void removeResource(IResource f, ISourcePathProcessor removeProcessor) {
        if (f instanceof IFolder) {
            removeProcessor.folder((IFolder)f);
        } else if (f instanceof IFile) {
            removeProcessor.file((IFile)f, null);
        }
    }

    private void openResource(IResource f, ISourcePathProcessor openProcessor) {
        if (f instanceof IFile) {
            openProcessor.file((IFile)f, null);
        }
    }

    private boolean isCopyToProjectRoot(String copyPath) {
        return copyPath != null && (copyPath.isEmpty() || copyPath.equals(".") || copyPath.equals("/"));
    }

    private boolean isRenamed(String renameTo) {
        return renameTo != null && !renameTo.isEmpty();
    }

    private IFolder getFolder(IPath srcRelPath, String copyPath, ISDK sdk, IProject project, ISDK holderSdk) {
        IFolder folder = null;
        if (copyPath == null) {
            folder = holderSdk != null ? project.getFolder(holderSdk.getTargetFolderName()).getFolder(sdk.getTargetFolderName()) : project.getFolder(sdk.getTargetFolderName());
            int i = 0;
            while (i < srcRelPath.segmentCount() - 1) {
                folder = folder.getFolder(srcRelPath.segment(i));
                ++i;
            }
        } else {
            folder = project.getFolder(copyPath);
        }
        return folder;
    }

    private Set<String> getBinaryFiles(ISDK sdk, String toolChainId) {
        String sdkEnvName = sdk.getEnv().getName();
        IPath rootPath = SDKSupportPlugin.getEclipsePath(sdk);
        return Arrays.stream(sdk.getBinaries(toolChainId)).map(path -> this.generateResourcePathString(path.makeRelativeTo(rootPath), sdkEnvName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String getResourcePathStringBasedOnSdkEnvironment(ISDK sdk, IPath sdkRootRelativePath) {
        IEnvironment environment = sdk.getEnv();
        return environment != null ? this.generateResourcePathString(sdkRootRelativePath, environment.getName()) : null;
    }
}

