/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.freescale.s32ds.cross.sdk.internal.SDKValidator;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKImportUICallbackHandler;
import com.nxp.s32ds.cle.ide.sdk.core.SDKDescriptorParser;
import com.nxp.s32ds.cle.ide.sdk.core.SDKImportStatusHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SDKImportHandler {
    private SDKImportUICallbackHandler ch;

    public List<ISDK> importSDK(String destination, String location) throws SDKLoadException {
        File dir = new File(destination);
        File path = new File(location);
        try {
            if (path.isDirectory()) {
                Files.copy(path.toPath(), dir.toPath(), new CopyOption[0]);
            } else {
                this.unzipContent(path, dir, new String[0]);
            }
            return this.importSDK(dir, 2);
        }
        catch (SDKLoadException sle) {
            throw sle;
        }
        catch (Exception e) {
            throw new SDKLoadException(Messages.AbstractSDK_exception, e.getCause());
        }
    }

    public List<ISDK> importSDK(String dir) throws SDKLoadException {
        try {
            File sdkLocalFolder = new File(dir);
            return this.importSDK(sdkLocalFolder, 3);
        }
        catch (SDKLoadException sle) {
            throw sle;
        }
        catch (Exception e) {
            throw new SDKLoadException(Messages.AbstractSDK_exception, e);
        }
    }

    public void setSDKImportUICallbackHandler(SDKImportUICallbackHandler ch) {
        this.ch = ch;
    }

    private List<ISDK> importSDK(File dir, int origin) throws Exception {
        List<ISDK> importedSDKs = null;
        if (this.ch != null) {
            this.ch.setImportOrigin(origin);
        }
        importedSDKs = this.importFromDir(dir, origin);
        ImportSDK.storeImportSDKs();
        ExternalSDK.storeExternalSDKs();
        return importedSDKs;
    }

    private List<ISDK> importFromDir(File dir, int origin) throws Exception {
        ArrayList<ISDK> importedSDKs = new ArrayList<ISDK>();
        File sdkXmlEntry = this.getSourceXmlFile(dir);
        String sourceXml = null;
        Throwable throwable = null;
        Object var7_9 = null;
        try (FileInputStream fis = new FileInputStream(sdkXmlEntry);){
            sourceXml = SDKUtils.toString(fis);
            if (sourceXml == null || sourceXml.length() == 0) {
                throw new SDKLoadException(Messages.AbstractSDK_exception);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SDKValidator validator = new SDKValidator(null);
        SDKDescriptorParser parser = new SDKDescriptorParser();
        parser.addErrorsHandler(new SDKImportStatusHandler());
        Map<String, SDKHeader> sdkHeaders = parser.loadSDKHeaders(sourceXml);
        for (String sourceHeaderId : sdkHeaders.keySet()) {
            SDKHeader sdkHeader = sdkHeaders.get(sourceHeaderId);
            String errorMsg = null;
            String sdkName = sdkHeader.getName();
            String sdkVersion = sdkHeader.getVersion().toString();
            errorMsg = Messages.SDKManagementWidget_bad_name;
            SDKValidator.Result res = validator.validateName(sdkName);
            if (res == SDKValidator.Result.VALIDATION_OK) {
                errorMsg = Messages.SDKManagementWidget_bad_version;
                res = validator.validateVersion(sdkVersion);
            }
            if (res == SDKValidator.Result.VALIDATION_OK) {
                errorMsg = Messages.SDKManagementWidget_sdk_exists;
                res = validator.validateExists(sdkName, sdkVersion);
            }
            if (res != SDKValidator.Result.VALIDATION_OK) {
                if ((sdkHeader = this.requestRename(sdkHeader, errorMsg)) == null) {
                    this.cleanSDKFolder(dir, origin);
                    continue;
                }
                sdkName = sdkHeader.getName();
                sdkVersion = sdkHeader.getVersion().toString();
            }
            errorMsg = null;
            String selectedLocation = this.requestSourceLocation(sdkHeader, dir);
            if (selectedLocation == null) continue;
            ISDK sdk = parser.loadSDK(sourceXml, sourceHeaderId, null, origin, selectedLocation);
            sdk.setHeader(sdkHeader);
            sdk.setEnv(SDKSupportPlugin.createEnvironment(sdkName, sdkVersion, false, true, selectedLocation, sdkName));
            SDKUtils.add(sdk, true);
            importedSDKs.add(sdk);
        }
        return importedSDKs;
    }

    private void unzipContent(File zipPath, File destinationFolder, String ... skipEntries) throws Exception {
        Throwable throwable = null;
        Object var5_7 = null;
        try (ZipFile zipFile = new ZipFile(zipPath);){
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            List<String> skip = Arrays.asList(skipEntries);
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (skip.contains(entry.getName())) continue;
                byte[] data = new byte[2048];
                File destFile = new File(String.format("%s%s%s", destinationFolder, FileSystems.getDefault().getSeparator(), entry.getName()));
                destFile.getParentFile().mkdirs();
                Throwable throwable2 = null;
                Object var14_18 = null;
                try {
                    BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                    try {
                        try (BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(destFile), 2048);){
                            int count;
                            while ((count = is.read(data, 0, 2048)) != -1) {
                                dest.write(data, 0, count);
                            }
                            dest.flush();
                        }
                        if (is == null) continue;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable2;
                    }
                    is.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private File getSourceXmlFile(File dir) throws SDKLoadException {
        File sdkXmlEntry = new File(dir, "sources.xml");
        if (!sdkXmlEntry.exists() || !sdkXmlEntry.canRead()) {
            throw new SDKLoadException(String.format(Messages.SDKManagementWidget_not_found, "sources.xml", dir));
        }
        return sdkXmlEntry;
    }

    private void cleanSDKFolder(File dir, int origin) {
        if (origin == 2 && dir.exists() && dir.isDirectory()) {
            SDKUtils.deleteFolder(dir);
        }
        dir.delete();
    }

    private SDKHeader requestRename(SDKHeader sdkHeader, String errorMessage) {
        return this.ch != null ? this.ch.requestRename(sdkHeader, errorMessage) : sdkHeader;
    }

    private String requestSourceLocation(SDKHeader sdkHeader, File defaultLocation) {
        return this.ch != null ? this.ch.requestSourceLocation(sdkHeader, defaultLocation) : defaultLocation.toString();
    }
}

