/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ContributedExternalSdk;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.InternalSdk;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.freescale.s32ds.cross.sdk.internal.hook.SDKHookHandler;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKHeaderValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SdkModuleValidator;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class SDKDescriptorParser {
    private List<IValidator> validators;
    private List<RcpStatusHandler> errorsHandlers = new ArrayList<RcpStatusHandler>();
    private MultiStatus errorStatuses;

    public SDKDescriptorParser() {
        this.validators = new ArrayList<IValidator>();
        this.validators.add(new SDKHeaderValidator());
        this.errorStatuses = new MultiStatus(SDKSupportPlugin.getUniqueIdentifier(), 4002, NLS.bind((String)Messages.SDKDescriptionParser_error_load_sdks, null), null);
    }

    public List<ISDK> loadSDKs(String sourceXml, int origin) throws SDKLoadException {
        return this.loadSDKs(sourceXml, null, null, origin);
    }

    public List<ISDK> loadSDKs(String sourceXml, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        if (sourceXml == null || sourceXml.length() == 0) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sourceXml.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception e) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format, e);
        }
        if (!root.getNodeName().equals("sdks")) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        NodeList sdkNodes = root.getElementsByTagName("sdk");
        int i = 0;
        while (i < sdkNodes.getLength()) {
            ISDK sdk = null;
            Element sdkElement = (Element)sdkNodes.item(i);
            try {
                sdk = this.parseSDKElement(sdkElement, project, alterEnvValue, origin);
            }
            catch (SDKLoadException sle) {
                SDKSupportPlugin.error(sle.getMessage(), (Throwable)((Object)sle));
            }
            if (sdk != null) {
                result.add(sdk);
            } else {
                SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKDescriptionParser_error_load_sdk, (Object[])new String[]{sdkElement.getAttribute("name"), sdkElement.getAttribute("version")})));
            }
            ++i;
        }
        return result;
    }

    public List<ISDK> loadSDKs(File sourceXmlFile, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        String sourceXml = this.loadSourceXml(sourceXmlFile);
        return this.loadSDKs(sourceXml, project, alterEnvValue, origin);
    }

    public ISDK loadSDK(String sourceXml, String sdkId, IProject project, int origin, String alterEnvValue) throws SDKLoadException {
        ISDK result = null;
        NodeList sdkNodes = this.getSDKNodesList(sourceXml);
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element element = (Element)sdkNodes.item(i);
            if (element.getAttribute("id").equals(sdkId)) {
                result = this.parseSDKElement(element, project, alterEnvValue, origin);
                break;
            }
            ++i;
        }
        if (result == null) {
            throw new SDKLoadException(Messages.AbstractSDK_exception);
        }
        return result;
    }

    public Map<String, SDKHeader> loadSDKHeaders(String sourceXml) throws SDKLoadException {
        HashMap<String, SDKHeader> result = new HashMap<String, SDKHeader>();
        NodeList sdkNodes = this.getSDKNodesList(sourceXml);
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkNode = (Element)sdkNodes.item(i);
            IStatus status = this.validate(sdkNode);
            if (!status.isOK()) {
                this.addLoadSDKError(status, sdkNode.getAttribute("id"));
            } else {
                result.put(sdkNode.getAttribute("id"), new SDKHeader(false, sdkNode));
            }
            ++i;
        }
        this.handleErrors((IStatus)this.errorStatuses);
        return result;
    }

    public Map<String, SDKHeader> loadSDKHeaders(File sourceXmlFile) throws SDKLoadException {
        return this.loadSDKHeaders(this.loadSourceXml(sourceXmlFile));
    }

    public NodeList getSDKNodesList(String sourceXml) throws SDKLoadException {
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sourceXml.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new SDKLoadException(Messages.AbstractSDK_exception);
        }
        if (!root.getNodeName().equals("sdks")) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        NodeList sdkNodes = root.getElementsByTagName("sdk");
        if (sdkNodes == null || sdkNodes.getLength() == 0) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        return sdkNodes;
    }

    public void addValidator(IValidator validator) {
        this.validators.add(validator);
    }

    public void addErrorsHandler(RcpStatusHandler handler) {
        this.errorsHandlers.add(handler);
    }

    public Set<SdkModule> parseModules(IConfigurationElement sdkElement) {
        if (!"sdk".equals(sdkElement.getName())) {
            return Collections.emptySet();
        }
        LinkedHashSet<SdkModule> refModules = new LinkedHashSet<SdkModule>();
        IConfigurationElement[] modulesElements = sdkElement.getChildren("modules");
        if (modulesElements != null && modulesElements.length == 1) {
            SdkModuleValidator moduleValidator = new SdkModuleValidator();
            IConfigurationElement[] iConfigurationElementArray = modulesElements[0].getChildren("module");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement moduleElement = iConfigurationElementArray[n2];
                IStatus validationStatus = moduleValidator.validate(moduleElement);
                if (validationStatus.isOK()) {
                    refModules.add(new SdkModule(moduleElement));
                } else {
                    SDKSupportPlugin.log(validationStatus);
                }
                ++n2;
            }
        }
        return refModules;
    }

    private ISDK parseSDKElement(Element sdkElement, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        TCHolder rootHolder = this.createToolchainsHolder(sdkElement);
        SDKHeader sdkHeader = this.createSDKHeader(sdkElement, origin, alterEnvValue);
        ISDKHook sdkHook = this.createSdkHook(sdkElement, origin);
        Set<SdkModule> modules = this.parseModules(sdkElement);
        List<TCHolder> toolchainsList = this.parseSDKContent(sdkElement, sdkHeader, rootHolder, alterEnvValue);
        TCHolder[] tcs = !toolchainsList.isEmpty() ? toolchainsList.toArray(new TCHolder[toolchainsList.size()]) : null;
        IFilterOptions filter = this.createFilterOptions(sdkHeader, tcs);
        ISDK sdk = this.createSDK(sdkHeader, rootHolder, tcs, filter, origin, alterEnvValue, project);
        modules.forEach(sdk::addModule);
        SDKHookHandler.INSTANCE.registerSDKHook(sdk, sdkHook);
        return sdk;
    }

    private Set<SdkModule> parseModules(Element sdkElement) {
        LinkedHashSet<SdkModule> modules = new LinkedHashSet<SdkModule>();
        NodeList modulesElements = sdkElement.getElementsByTagName("modules");
        if (modulesElements.getLength() == 1) {
            Element modulesElement = (Element)modulesElements.item(0);
            NodeList moduleElements = modulesElement.getElementsByTagName("module");
            SdkModuleValidator moduleValidator = new SdkModuleValidator();
            int i = 0;
            while (i < moduleElements.getLength()) {
                Element moduleElement = (Element)moduleElements.item(i);
                if (moduleElement.getParentNode().equals(modulesElement)) {
                    IStatus validationStatus = moduleValidator.validate(moduleElement);
                    if (validationStatus.isOK()) {
                        modules.add(new SdkModule(moduleElement));
                    } else {
                        SDKSupportPlugin.log(validationStatus);
                    }
                }
                ++i;
            }
        }
        return modules;
    }

    private SDKHeader createSDKHeader(Element sdkElement, int origin, String alterEnvValue) throws SDKLoadException {
        boolean isCreateEnv = origin != 3 && origin != 2;
        IStatus status = this.validate(sdkElement);
        if (!status.isOK()) {
            throw new SDKLoadException(status.getMessage());
        }
        SDKHeader sdkHeader = new SDKHeader(isCreateEnv, sdkElement);
        if (sdkHeader.getEnv() == null && isCreateEnv) {
            sdkHeader.setEnv(SDKSupportPlugin.createEnvironment(sdkHeader.getName(), sdkHeader.getVersion().toString(), false, true, alterEnvValue == null ? sdkHeader.getBasePath() : alterEnvValue, sdkHeader.getDescription()));
        }
        return sdkHeader;
    }

    private ISDKHook createSdkHook(Element sdkElement, int origin) throws SDKLoadException {
        if (7 != origin) {
            return null;
        }
        String sdkHookClassName = sdkElement.getAttribute("hook");
        if (sdkHookClassName == null || sdkHookClassName.isEmpty()) {
            return null;
        }
        try {
            return (ISDKHook)Class.forName(sdkHookClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SDKLoadException(e.getMessage());
        }
    }

    private TCHolder createToolchainsHolder(Element sdkElement) {
        TCHolder toolchainsHolder = new TCHolder(null);
        this.loadSymbols(sdkElement, toolchainsHolder);
        return toolchainsHolder;
    }

    private TCHolder addDefinedSymbols(TCHolder toolchainsHolder, Element sdkElement, String type) {
        NodeList nl = sdkElement.getElementsByTagName(type);
        int i = 0;
        while (i < nl.getLength()) {
            Element item = (Element)nl.item(i);
            if (item.getParentNode().equals(sdkElement)) {
                toolchainsHolder.addDefinedSymbols(item.getAttribute("value"), type);
            }
            ++i;
        }
        return toolchainsHolder;
    }

    private List<TCHolder> parseSDKContent(Element sdkElement, SDKHeader sdkHeader, TCHolder rootHolder, String alterEnvValue) {
        String path = sdkHeader.getBasePath();
        if ((path == null || path.trim().isEmpty()) && sdkHeader.getEnv() != null) {
            path = sdkHeader.getEnv().getValue();
        }
        ArrayList<TCHolder> toolchainsList = new ArrayList<TCHolder>();
        NodeList children = sdkElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getNodeName().equals("toolchain")) {
                    TCHolder tcHolder = new TCHolder(element, path, alterEnvValue);
                    this.loadSymbols(element, tcHolder);
                    if (!tcHolder.isEmpty()) {
                        toolchainsList.add(tcHolder);
                    }
                } else {
                    rootHolder.process(element, path, alterEnvValue);
                }
            }
            ++i;
        }
        return toolchainsList;
    }

    private void loadSymbols(Element holderElement, TCHolder toolChainHolder) {
        toolChainHolder.addDefinedSymbols(holderElement.getAttribute("symbols"), "commonSymbols");
        this.addDefinedSymbols(toolChainHolder, holderElement, "commonSymbols");
        this.addDefinedSymbols(toolChainHolder, holderElement, "cCompilerSymbols");
        this.addDefinedSymbols(toolChainHolder, holderElement, "cppCompilerSymbols");
        this.addDefinedSymbols(toolChainHolder, holderElement, "assemblerSymbols");
        NodeList symbolsElements = holderElement.getElementsByTagName("symbols");
        int i = 0;
        while (i < symbolsElements.getLength()) {
            Element symbolsElement = (Element)symbolsElements.item(i);
            if (symbolsElement.getParentNode().equals(holderElement)) {
                NodeList symbolElements = symbolsElement.getElementsByTagName("symbol");
                int j = 0;
                while (j < symbolElements.getLength()) {
                    Element symbolElement = (Element)symbolElements.item(j);
                    String symbolName = symbolElement.getAttribute("name");
                    String langId = symbolElement.getAttribute("langId");
                    SdkSymbolTypes type = SdkSymbolTypes.byName(symbolElement.getAttribute("type"));
                    toolChainHolder.addSymbol(symbolName, langId, type);
                    ++j;
                }
            }
            ++i;
        }
    }

    private IFilterOptions createFilterOptions(SDKHeader header, TCHolder[] tcs) {
        String toolchainsIds = tcs != null ? String.join((CharSequence)",", this.getToolchainsIds(tcs)) : null;
        return FilterOptions.createFilterOptions(header.getLangs(), toolchainsIds == null ? header.getObsoleteToolchainIds() : toolchainsIds, header.getCores(), header.getPlatformTarget(), header.getPlatformHost());
    }

    private String[] getToolchainsIds(TCHolder[] tcs) {
        if (tcs == null || tcs.length == 0) {
            return new String[0];
        }
        String[] toolchainsIds = new String[tcs.length];
        int i = 0;
        while (i < tcs.length) {
            toolchainsIds[i] = tcs[i].getTCId();
            ++i;
        }
        return toolchainsIds;
    }

    private ISDK createSDK(SDKHeader sdkHeader, TCHolder rootHolder, TCHolder[] tcs, IFilterOptions filter, int origin, String alterEnvValue, IProject project) {
        switch (origin) {
            case 2: 
            case 3: 
            case 6: {
                return new ImportSDK(sdkHeader, rootHolder, filter, tcs, alterEnvValue);
            }
            case 1: {
                return new GitSDK(sdkHeader, rootHolder, filter, tcs);
            }
            case 4: {
                return new ExternalSDK(sdkHeader, rootHolder, filter);
            }
            case 5: {
                return new ProjectLocalSDK(project, sdkHeader, rootHolder, filter);
            }
            case 7: {
                return new ContributedExternalSdk(sdkHeader, rootHolder, filter, tcs);
            }
            case 8: {
                return new InternalSdk(sdkHeader, rootHolder, filter);
            }
        }
        return null;
    }

    private String loadSourceXml(File sourceXmlFile) throws SDKLoadException {
        String sourceXml = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fis = new FileInputStream(sourceXmlFile);){
                sourceXml = SDKUtils.toString(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new SDKLoadException(Messages.AbstractSDK_exception, ioe);
        }
        return sourceXml;
    }

    private IStatus validate(Object value) {
        for (IValidator validator : this.validators) {
            IStatus status = validator.validate(value);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private void handleErrors(IStatus status) {
        for (RcpStatusHandler errorHandler : this.errorsHandlers) {
            try {
                errorHandler.handleStatus(status, null);
            }
            catch (CoreException ce) {
                SDKSupportPlugin.log((IStatus)new Status(4, SDKSupportPlugin.getUniqueIdentifier(), "Unable to handle error status: " + status, (Throwable)ce));
            }
        }
    }

    private void addLoadSDKError(IStatus error, String sdkId) {
        this.errorStatuses.add((IStatus)new Status(4, error.getPlugin(), NLS.bind((String)"SDK {0}: {1}", (Object)sdkId, (Object)error.getMessage())));
    }
}

