/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class McalArxmlParser {
    public static final String MCAL_HEADER_FILE = "MCAL_HEADER_FILE";
    public static final String MCAL_SOURCE_FILE = "MCAL_SOURCE_FILE";
    public static final String MCAL_RESOURCE_FILE = "MCAL_RESOURCE_FILE";
    public static final String MCAL_CONFIG_HEADER_FILE = "MCAL_CONFIG_HEADER_FILE";
    public static final String MCAL_CONFIG_SOURCE_FILE = "MCAL_CONFIG_SOURCE_FILE";
    private static final String AUTOSAR_ELEMENT = "AUTOSAR";
    private static final String AUTOSAR_ENGINEERING_OBJECT_ELEMENT = "AUTOSAR-ENGINEERING-OBJECT";
    private static final String ARTIFACT_DESCRIPTOR_ELEMENT = "ARTIFACT-DESCRIPTOR";
    private static final String SHORT_LABEL_ELEMENT = "SHORT-LABEL";
    private static final String SHORT_NAME_ELEMENT = "SHORT-NAME";
    private static final String ARXML_FILES_REGEX = "regex:([ \\S]+(\\.arxml)$)";
    private static final PathMatcher ARXML_FILES_MATCHER = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.arxml)$)");
    private static final String HEADER_FILES_REGEX = "regex:([ \\S]+(\\.(h|hpp|hxx|hh))$)";
    private static final PathMatcher HEADERS_MATCHER = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(h|hpp|hxx|hh))$)");
    private static final String SOURCE_FILES_REGEX = "regex:([ \\S]+(\\.(c|cpp|cc|C|cxx))$)";
    private static final PathMatcher SOURCE_MATCHER = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(c|cpp|cc|C|cxx))$)");
    private static final String RESOURCE_FILES_REGEX = "regex:([ \\S]+(?<!(\\.c$|\\.cpp$|\\.cc$|\\.C$|\\.cxx$|\\.h$|\\.hpp$|\\.hxx$|\\.hh$|\\.a$|\\.so$|\\.la$|\\.ld$|\\\\$)))";
    private static final PathMatcher RESOURCES_MATCHER = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(?<!(\\.c$|\\.cpp$|\\.cc$|\\.C$|\\.cxx$|\\.h$|\\.hpp$|\\.hxx$|\\.hh$|\\.a$|\\.so$|\\.la$|\\.ld$|\\\\$)))");
    private static final String ARXML_FILE_SEPARATOR = "::";
    private Path mcalFolderPath;
    private Map<String, List<String>> result;

    public McalArxmlParser(String mcalFolderPath) {
        this.mcalFolderPath = Paths.get(mcalFolderPath, new String[0]);
        this.result = new LinkedHashMap<String, List<String>>();
    }

    public Map<String, List<String>> parse() {
        this.parseMcalFolder(this.mcalFolderPath.toFile());
        return this.result;
    }

    private void parseMcalFolder(File folder) {
        Path folderPath = folder.toPath();
        try {
            Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes ba) throws IOException {
                    if (ARXML_FILES_MATCHER.matches(path)) {
                        McalArxmlParser.this.parseArxmlFile(path.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException ioe) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Unable to parse folder {0}: error occured", (Object)folder), (Throwable)ioe));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseArxmlFile(File arxmlFile) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(arxmlFile));
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    Element root = parser.parse(bis).getDocumentElement();
                    if (!AUTOSAR_ELEMENT.equals(root.getNodeName())) {
                        return;
                    }
                    NodeList childNodes = root.getChildNodes();
                    if (childNodes.getLength() == 0) {
                        return;
                    }
                    String moduleName = null;
                    NodeList autosarEngineeringObjectElements = root.getElementsByTagName(AUTOSAR_ENGINEERING_OBJECT_ELEMENT);
                    int i = 0;
                    while (i < autosarEngineeringObjectElements.getLength()) {
                        block22: {
                            NodeList shortLabelElements;
                            Element autosarEngineeringObjectElement;
                            block21: {
                                autosarEngineeringObjectElement = (Element)autosarEngineeringObjectElements.item(i);
                                if (moduleName != null) break block21;
                                moduleName = this.getModuleName(autosarEngineeringObjectElement);
                                if (moduleName == null) break block22;
                                moduleName = moduleName.replace("_", "_TS_");
                            }
                            if ((shortLabelElements = autosarEngineeringObjectElement.getElementsByTagName(SHORT_LABEL_ELEMENT)).getLength() > 0) {
                                String filePath = ((Element)shortLabelElements.item(0)).getTextContent();
                                if (moduleName != null && !moduleName.isEmpty() && filePath != null && !filePath.isEmpty()) {
                                    this.addMcalFile(moduleName, this.getOsPath(filePath));
                                }
                            }
                        }
                        ++i;
                    }
                    NodeList artifactDescriptorElements = root.getElementsByTagName(ARTIFACT_DESCRIPTOR_ELEMENT);
                    int i2 = 0;
                    while (i2 < artifactDescriptorElements.getLength()) {
                        Element artifactDescriptorElement = (Element)artifactDescriptorElements.item(i2);
                        NodeList shortLabelElements = artifactDescriptorElement.getElementsByTagName(SHORT_LABEL_ELEMENT);
                        if (shortLabelElements.getLength() > 0) {
                            String filePath = ((Element)shortLabelElements.item(0)).getTextContent();
                            if (moduleName != null && !moduleName.isEmpty() && filePath != null && !filePath.isEmpty()) {
                                this.addConfigFile(moduleName, this.getOsPath(filePath));
                            }
                        }
                        ++i2;
                    }
                    return;
                }
                finally {
                    if (bis == null) return;
                    bis.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", "Unable to parse .arxml file"));
        }
    }

    private String getModuleName(Element autosarEngineeringObjectElement) {
        String moduleName = null;
        Element artifactDescriptors = (Element)autosarEngineeringObjectElement.getParentNode();
        Element codeElements = (Element)artifactDescriptors.getParentNode();
        Element codeDescriptors = (Element)codeElements.getParentNode();
        Element bswImplementation = (Element)codeDescriptors.getParentNode();
        Element elements = (Element)bswImplementation.getParentNode();
        Element arPackageElement1 = (Element)elements.getParentNode();
        Element arPackagesElement = (Element)arPackageElement1.getParentNode();
        Element arPackageElement2 = (Element)arPackagesElement.getParentNode();
        NodeList shortNameElements = arPackageElement2.getElementsByTagName(SHORT_NAME_ELEMENT);
        if (shortNameElements != null && shortNameElements.getLength() > 0) {
            moduleName = shortNameElements.item(0).getTextContent();
        }
        return moduleName;
    }

    private void addMcalFile(String moduleName, String mcalFilePath) {
        Path path = Paths.get(moduleName, this.getOsPath(mcalFilePath));
        if (HEADERS_MATCHER.matches(path)) {
            this.result.computeIfAbsent(MCAL_HEADER_FILE, s -> new ArrayList()).add(path.toString());
        } else if (SOURCE_MATCHER.matches(path)) {
            this.result.computeIfAbsent(MCAL_SOURCE_FILE, s -> new ArrayList()).add(path.toString());
        } else if (RESOURCES_MATCHER.matches(path)) {
            this.result.computeIfAbsent(MCAL_RESOURCE_FILE, s -> new ArrayList()).add(path.toString());
        }
    }

    private void addConfigFile(String moduleName, String configFilePath) {
        Path path = Paths.get(moduleName, this.getOsPath(configFilePath));
        if (HEADERS_MATCHER.matches(path)) {
            this.result.computeIfAbsent(MCAL_CONFIG_HEADER_FILE, s -> new ArrayList()).add(path.toString());
        } else if (SOURCE_MATCHER.matches(path)) {
            this.result.computeIfAbsent(MCAL_CONFIG_SOURCE_FILE, s -> new ArrayList()).add(path.toString());
        }
    }

    private String getOsPath(String arxmlPath) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(arxmlPath.split(ARXML_FILE_SEPARATOR)).forEach(segment -> {
            StringBuilder stringBuilder2 = sb.append((String)segment).append(File.separator);
        });
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

