/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.nxp.s32ds.cle.ide.sdk.core.SDKDescriptorParser;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class InternalSdkHandler {
    private static final String INTERNAL_SDKS_PREF_KEY = "com.nxp.s32ds.cle.runtime.sdk.internal.sdks";

    public static void loadInternalPersistedSDKs() {
        String internalSdks = Platform.getPreferencesService().getString(SDKSupportPlugin.getUniqueIdentifier(), INTERNAL_SDKS_PREF_KEY, "", null);
        if (internalSdks == null || internalSdks.isEmpty()) {
            return;
        }
        try {
            new SDKDescriptorParser().loadSDKs(internalSdks, 8).stream().filter(Objects::nonNull).forEach(sdk -> {
                IStatus iStatus = SDKUtils.addVerbose(sdk, true, false);
            });
        }
        catch (SDKLoadException sle) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", "Unable to load Internal SDKs", (Throwable)((Object)sle)));
        }
    }

    public static void updatePersistedInternalSdks() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.put(INTERNAL_SDKS_PREF_KEY, AbstractSDK.getSDKsString(SDKUtils.filter(sdk -> ISDK.TYPE.INTERNAL == sdk.getType())));
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
    }
}

