/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ContributedExternalSdk;
import com.freescale.s32ds.cross.sdk.internal.Environment;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.InternalSdk;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbol;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportMcalSdkHandler {
    private static final String SDK_DESCRIPTOR_ROOT_ELEMENT = "sdks";
    private static final String SDK_ELEMENT = "sdk";
    private static final String SDK_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final String SDK_ELEMENT_VERSION_ATTRIBUTE = "version";
    private static final String SDK_ELEMENT_BASE_PATH_ATTRIBUTE = "basePath";
    private static final String SDK_ELEMENT_CORES_ATTRIBUTE = "cores";
    private static final String SDK_ELEMENT_TOOLCHAINS_ATTRIBUTE = "toolchains";
    private static final String SDK_ELEMENT_TARGET_FOLDER_NAME_ATTRIBUTE = "targetFolderName";
    private static final String SDK_ELEMENT_TARGET_PROJECT_TEMPLATE_ATTRIBUTE = "targetProjectTemplate";
    private static final String ENV_ELEMENT = "env";
    private static final String ENV_ELEMENT_NAME_ATTRIBUTE = "name";
    private static final String ENV_ELEMENT_VALUE_ATTRIBUTE = "value";
    private static final String ENV_ELEMENT_IS_SYSTEM_ATTRIBUTE = "isSystem";
    private static final String HEADER_FILE_ELEMENT = "headerFile";
    private static final String SOURCE_FILE_ELEMENT = "sourceFile";
    private static final String RESOURCE_FILE_ELEMENT = "resourceFile";
    private static final String COPY_ATTRIBUTE = "copy";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String MCAL_CONFIG_INCLUDE_DIR = "include";
    private static final String MCAL_CONFIG_SOURCES_DIR = "src";
    private static final String SDK_CONFIG_FILES_SUBDIR = "config";
    private static final String MCAL_CONFIGURATOR_SUFFIX = "_config.xml";
    private static final String MCAL_GENERATED_TAG = "mcalgen";
    private static final String MCAL_CONFIG_MODULE_NAME = "CONFIG";
    private static final String CHARSET_NAME = "UTF-8";
    private static Map<String, List<String>> config2McalModule = new HashMap<String, List<String>>();

    public static IStatus performImportMcalSdkByConfiguration(ISDK mcalSdk, String mcalConfigPath, String sdkName, String sdkVersion) {
        String mcalSdkBasePath = mcalSdk.getHeader().getBasePath();
        String mcalConfiguratorPath = Paths.get(mcalSdkBasePath, String.valueOf(mcalSdk.getName()) + MCAL_CONFIGURATOR_SUFFIX).toString();
        String mcalConfiguratorXml = ImportMcalSdkHandler.loadXml(mcalConfiguratorPath);
        if (mcalConfiguratorXml == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = McalConfiguratorParser.initConfig2McalModuleMap(mcalConfiguratorXml, mcalConfiguratorPath);
        if (!status.isOK()) {
            ImportMcalSdkHandler.reportError(status.getMessage());
            return Status.CANCEL_STATUS;
        }
        String mcalConfigSdkName = String.valueOf(mcalSdk.getName()) + "_CONFIG";
        ISDK mcalConfigSdk = ImportMcalSdkHandler.createMcalConfigSdk(mcalConfigPath, mcalConfigSdkName, mcalSdk.getVersion());
        if (mcalConfigSdk == null) {
            return Status.CANCEL_STATUS;
        }
        ISDK mcalGeneratedSdk = ImportMcalSdkHandler.createMcalSdkByConfigurator(mcalSdk, mcalConfigSdk);
        if (mcalGeneratedSdk == null) {
            return Status.CANCEL_STATUS;
        }
        ISDK mcalImportSdk = ImportMcalSdkHandler.createImportMcalSdk(sdkName, sdkVersion, mcalSdkBasePath, mcalSdk, mcalGeneratedSdk, mcalConfigSdk);
        if (mcalImportSdk == null) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static String createMcalDescriptorByConfiguration(String mcalDescriptorPath, String mcalConfigPath, String sdkPath, String sdkName, String sdkVersion) {
        if (!ImportMcalSdkHandler.checkMcalConfigDirectory(mcalConfigPath).isOK()) {
            return null;
        }
        String mcalDescriptorXml = ImportMcalSdkHandler.loadXml(mcalDescriptorPath);
        if (mcalDescriptorXml == null) {
            return null;
        }
        Path mcalFolderPath = Paths.get(mcalDescriptorPath, new String[0]).getParent();
        String mcalConfiguratorPath = mcalFolderPath.resolve(mcalFolderPath.getFileName() + MCAL_CONFIGURATOR_SUFFIX).toString();
        String mcalConfiguratorXml = ImportMcalSdkHandler.loadXml(mcalConfiguratorPath);
        if (mcalConfiguratorXml == null) {
            return null;
        }
        IStatus status = McalConfiguratorParser.initConfig2McalModuleMap(mcalConfiguratorXml, mcalConfiguratorPath);
        if (!status.isOK()) {
            ImportMcalSdkHandler.reportError(status.getMessage());
            return null;
        }
        Element mcalSdkElement = ImportMcalSdkHandler.getMcalSdkElement(mcalDescriptorXml, mcalDescriptorPath);
        if (mcalSdkElement == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootElement = document.createElement(SDK_DESCRIPTOR_ROOT_ELEMENT);
            document.appendChild(rootElement);
            Element sdkElement = ImportMcalSdkHandler.createSdkElement(sdkName, sdkVersion, sdkPath, mcalSdkElement, document);
            String mcalBasePath = mcalSdkElement.getAttribute(SDK_ELEMENT_BASE_PATH_ATTRIBUTE);
            Element envElement = ImportMcalSdkHandler.createEnvElement(sdkName, sdkVersion, sdkPath, document);
            sdkElement.appendChild(envElement);
            Element symbolsElement = ImportMcalSdkHandler.createSymbolsElement(mcalSdkElement, document);
            if (symbolsElement != null) {
                sdkElement.appendChild(symbolsElement);
            }
            ImportMcalSdkHandler.createFileElements(sdkPath, mcalBasePath, mcalConfigPath, mcalSdkElement, sdkElement, document);
            rootElement.appendChild(sdkElement);
            return ImportMcalSdkHandler.createMcalDescriptorXml(document);
        }
        catch (Exception e) {
            ImportMcalSdkHandler.reportError(Messages.ImportMcalSdkHandler_create_mcal_descriptor_error, e);
            return null;
        }
    }

    public static IStatus checkMcalConfigDirectory(String mcalConfigPath) {
        if (mcalConfigPath == null || mcalConfigPath.isEmpty()) {
            Status errorStatus = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_config_path_not_valid, (Object)mcalConfigPath));
            ImportMcalSdkHandler.reportError((IStatus)errorStatus);
            return errorStatus;
        }
        File mcalConfigDir = new File(mcalConfigPath);
        if (!mcalConfigDir.exists() || !mcalConfigDir.isDirectory()) {
            Status errorStatus = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_config_path_incorrect, (Object)mcalConfigPath));
            ImportMcalSdkHandler.reportError((IStatus)errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkMcalDescriptorBasePath(String basePath) {
        File file = new File(SDKSupportPlugin.performStringSubstitution(basePath, null));
        if (!file.exists()) {
            return ValidationStatus.error((String)Messages.SDKDialog_path_not_exists_error_text);
        }
        if (!file.isDirectory()) {
            return ValidationStatus.error((String)Messages.SDKDialog_path_is_not_dir_error_text);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkMcalConfigDirectoryStructure(String mcalConfigPath) {
        if (Paths.get(mcalConfigPath, new String[0]).getFileName() == null) {
            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_config_path_incorrect, (Object)mcalConfigPath));
        }
        File mcalConfigHeadersDir = Paths.get(mcalConfigPath, MCAL_CONFIG_INCLUDE_DIR).toFile();
        if (!mcalConfigHeadersDir.exists() || !mcalConfigHeadersDir.isDirectory()) {
            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_config_path_incorrect, (Object)mcalConfigHeadersDir));
        }
        File mcalConfigSourcesDir = Paths.get(mcalConfigPath, MCAL_CONFIG_SOURCES_DIR).toFile();
        if (!mcalConfigSourcesDir.exists() || !mcalConfigSourcesDir.isDirectory()) {
            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_config_path_incorrect, (Object)mcalConfigSourcesDir));
        }
        return Status.OK_STATUS;
    }

    private static ISDK createMcalSdkByConfigurator(ISDK mcalSdk, ISDK mcalConfigSdk) {
        SDKHeader.SdkHeaderParameters params = new SDKHeader.SdkHeaderParameters();
        String sdkName = String.valueOf(mcalSdk.getName()) + "_GEN";
        params.setName(ImportMcalSdkHandler.getGeneratedSdkName(sdkName));
        params.setVersion(mcalSdk.getVersion());
        String sdkId = SDKHeader.makeId(params.getName(), params.getVersion());
        ISDK mcalGeneratedSdk = SDKUtils.getSDKbyID(sdkId);
        if (mcalGeneratedSdk != null) {
            return mcalGeneratedSdk;
        }
        String mcalSdkBasePath = mcalSdk.getHeader().getBasePath();
        params.setSdkPath(mcalSdkBasePath);
        params.setInternal(false);
        Environment environment = new Environment(sdkId, false);
        environment.setValue(mcalSdkBasePath, "", true);
        params.setEnvironment(environment);
        HashSet<String> tags = new HashSet<String>();
        tags.add(MCAL_GENERATED_TAG);
        params.setTags(tags);
        params.setTargetFolderName(mcalSdk.getName());
        SDKHeader header = new SDKHeader(params);
        TCHolder tcHolder = new TCHolder(null);
        List<String> modules = ImportMcalSdkHandler.getModulesByConfigurator(mcalConfigSdk);
        tcHolder.setPaths(ImportMcalSdkHandler.getPathsByConfigurator(mcalSdk, 2, modules), 2);
        tcHolder.setPaths(ImportMcalSdkHandler.getPathsByConfigurator(mcalSdk, 1, modules), 1);
        tcHolder.setPaths(ImportMcalSdkHandler.getPathsByConfigurator(mcalSdk, 4, modules), 4);
        tcHolder.setPaths(ImportMcalSdkHandler.getPathsByConfigurator(mcalSdk, 3, modules), 3);
        tcHolder.setPaths(ImportMcalSdkHandler.getPathsByConfigurator(mcalSdk, 0, modules), 0);
        SdkSymbolsHolder symbolsHolder = tcHolder.getSymbolsHolder();
        mcalSdk.getDefinedSymbols().stream().forEach(s -> symbolsHolder.addSymbol((SdkSymbol)s, SdkSymbolTypes.DEFINED));
        mcalSdk.getUndefinedSymbols().stream().forEach(s -> symbolsHolder.addSymbol((SdkSymbol)s, SdkSymbolTypes.UNDEFINED));
        mcalGeneratedSdk = new InternalSdk(header, tcHolder, FilterOptions.EMPTY_FILTER);
        SDKUtils.add(mcalGeneratedSdk, false);
        return mcalGeneratedSdk;
    }

    private static List<IExtendedPath> getPathsByConfigurator(ISDK mcalSdk, int resourceType, List<String> modules) {
        List<IExtendedPath> mcalSdkPaths = null;
        switch (resourceType) {
            case 2: {
                mcalSdkPaths = mcalSdk.getRoot().getBinaries();
                break;
            }
            case 1: {
                mcalSdkPaths = mcalSdk.getRoot().getHeaderPaths();
                break;
            }
            case 4: {
                mcalSdkPaths = mcalSdk.getRoot().getLinkerFiles();
                break;
            }
            case 3: {
                mcalSdkPaths = mcalSdk.getRoot().getUntypedResources();
                break;
            }
            case 0: {
                mcalSdkPaths = mcalSdk.getRoot().getSources();
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        if (mcalSdkPaths == null) {
            return Collections.emptyList();
        }
        ArrayList<IExtendedPath> result = new ArrayList<IExtendedPath>();
        for (String module : modules) {
            mcalSdkPaths.stream().filter(path -> path.toOSString().contains(module)).forEach(result::add);
        }
        return result;
    }

    private static List<String> getModulesByConfigurator(ISDK mcalConfigSdk) {
        ArrayList<String> result = new ArrayList<String>();
        mcalConfigSdk.getRoot().getHeaderPaths().forEach(p -> {
            boolean bl = result.addAll(config2McalModule.getOrDefault(p.lastSegment(), Collections.emptyList()));
        });
        return result;
    }

    private static ISDK createMcalConfigSdk(String mcalConfigPath, String sdkName, String sdkVersion) {
        IStatus status = ImportMcalSdkHandler.checkMcalConfigDirectory(mcalConfigPath);
        if (!status.isOK()) {
            return null;
        }
        SDKHeader.SdkHeaderParameters params = new SDKHeader.SdkHeaderParameters();
        params.setName(ImportMcalSdkHandler.getGeneratedSdkName(sdkName));
        params.setVersion(sdkVersion);
        String sdkId = SDKHeader.makeId(params.getName(), params.getVersion());
        ISDK mcalConfigSdk = SDKUtils.getSDKbyID(sdkId);
        if (mcalConfigSdk != null) {
            return mcalConfigSdk;
        }
        params.setSdkPath(mcalConfigPath);
        params.setInternal(false);
        Environment environment = new Environment(sdkId, false);
        environment.setValue(mcalConfigPath, "", true);
        params.setEnvironment(environment);
        HashSet<String> tags = new HashSet<String>();
        tags.add(MCAL_GENERATED_TAG);
        params.setTags(tags);
        params.setTargetFolderName(MCAL_CONFIG_MODULE_NAME);
        SDKHeader header = new SDKHeader(params);
        TCHolder tcHolder = new TCHolder(null);
        Path configPath = Paths.get(mcalConfigPath, new String[0]);
        final ArrayList<IExtendedPath> configHeaders = new ArrayList<IExtendedPath>();
        final ArrayList<IExtendedPath> configSources = new ArrayList<IExtendedPath>();
        try {
            Files.walkFileTree(configPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes ba) throws IOException {
                    if (SDKSupportPlugin.headersMatcher.matches(path)) {
                        configHeaders.add(ExtendedPath.fromOSString(path.toString(), false));
                    } else if (SDKSupportPlugin.sourcesMatcher.matches(path)) {
                        configSources.add(ExtendedPath.fromOSString(path.toString(), false));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException ioe) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Unable to parse folder {0}: error occured", (Object)configPath), (Throwable)ioe));
        }
        tcHolder.setPaths(configHeaders, 1);
        tcHolder.setPaths(configSources, 0);
        mcalConfigSdk = new InternalSdk(header, tcHolder, FilterOptions.EMPTY_FILTER);
        SDKUtils.add(mcalConfigSdk, false);
        return mcalConfigSdk;
    }

    private static String getGeneratedSdkName(String sdkName) {
        String sdkNumName;
        List<ISDK> mcalConfigSdks = SDKUtils.filter(sdk -> sdk.getName().startsWith(sdkName));
        if (!mcalConfigSdks.isEmpty()) {
            mcalConfigSdks.sort((sdk1, sdk2) -> sdk1.getName().compareTo(sdk2.getName()));
            String name = mcalConfigSdks.get(mcalConfigSdks.size() - 1).getName();
            sdkNumName = String.valueOf(sdkName) + "_" + (Integer.parseInt(name.substring(name.lastIndexOf(95) + 1)) + 1);
        } else {
            sdkNumName = String.valueOf(sdkName) + "_0";
        }
        return sdkNumName;
    }

    private static ISDK createImportMcalSdk(String sdkName, String sdkVersion, String sdkBasePath, ISDK mcalBaseSdk, ISDK mcalGeneratedSdk, ISDK mcalConfigSdk) {
        SDKHeader.SdkHeaderParameters params = new SDKHeader.SdkHeaderParameters();
        params.setName(sdkName);
        params.setVersion(sdkVersion);
        String sdkId = SDKHeader.makeId(params.getName(), params.getVersion());
        if (SDKUtils.exists(sdkId)) {
            return null;
        }
        Path importMcalSdkPath = Paths.get(sdkBasePath, new String[0]).resolve(sdkName);
        File importMcalSdkDir = importMcalSdkPath.toFile();
        if (!importMcalSdkDir.exists() || !importMcalSdkDir.isDirectory()) {
            importMcalSdkDir.mkdirs();
        }
        String importMcalSdkBasePath = importMcalSdkPath.toString();
        params.setSdkPath(importMcalSdkBasePath);
        params.setInternal(false);
        Environment environment = new Environment(sdkId, false);
        environment.setValue(importMcalSdkBasePath, "", true);
        params.setEnvironment(environment);
        SDKHeader header = new SDKHeader(params);
        TCHolder tcHolder = new TCHolder(null);
        ContributedExternalSdk importMcalSdk = new ContributedExternalSdk(header, tcHolder, FilterOptions.EMPTY_FILTER, new TCHolder[0]);
        SdkModule mcalSdkModule = new SdkModule(mcalBaseSdk.getId(), mcalBaseSdk.getName(), mcalGeneratedSdk.getDescription(), mcalGeneratedSdk.getId(), false);
        importMcalSdk.addModule(mcalSdkModule);
        SdkModule mcalConfigSdkModule = new SdkModule(MCAL_CONFIG_MODULE_NAME, MCAL_CONFIG_MODULE_NAME, mcalConfigSdk.getDescription(), mcalConfigSdk.getId(), false);
        importMcalSdk.addModule(mcalConfigSdkModule);
        SDKUtils.add(importMcalSdk, false);
        return importMcalSdk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element getMcalSdkElement(String mcalDescriptorXml, String mcalDescriptorPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(mcalDescriptorXml.getBytes(CHARSET_NAME));
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    Element mcalRootElement = parser.parse(stream).getDocumentElement();
                    if (!SDK_DESCRIPTOR_ROOT_ELEMENT.equals(mcalRootElement.getTagName())) {
                        ImportMcalSdkHandler.reportError(NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_invalid_structure, (Object)mcalDescriptorPath));
                        return null;
                    }
                    NodeList mcalSdkElements = mcalRootElement.getElementsByTagName(SDK_ELEMENT);
                    int count = mcalSdkElements.getLength();
                    if (count == 0) {
                        ImportMcalSdkHandler.reportError(NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_missed_sdk_node, (Object)mcalDescriptorPath));
                        return null;
                    }
                    return (Element)mcalSdkElements.item(0);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (stream == null) return null;
                    stream.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ImportMcalSdkHandler.reportError(NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_parse_error, (Object)mcalDescriptorPath), e);
            return null;
        }
    }

    private static Element createSdkElement(String sdkName, String sdkVersion, String sdkPath, Element mcalSdkElement, Document document) {
        Element sdkElement = document.createElement(SDK_ELEMENT);
        sdkElement.setAttribute("name", sdkName);
        sdkElement.setAttribute(SDK_ELEMENT_VERSION_ATTRIBUTE, sdkVersion);
        sdkElement.setAttribute(SDK_ELEMENT_BASE_PATH_ATTRIBUTE, sdkPath);
        ImportMcalSdkHandler.copyAttribute(mcalSdkElement, sdkElement, SDK_ELEMENT_CORES_ATTRIBUTE);
        ImportMcalSdkHandler.copyAttribute(mcalSdkElement, sdkElement, SDK_ELEMENT_TOOLCHAINS_ATTRIBUTE);
        ImportMcalSdkHandler.copyAttribute(mcalSdkElement, sdkElement, SDK_ELEMENT_TARGET_FOLDER_NAME_ATTRIBUTE);
        ImportMcalSdkHandler.copyAttribute(mcalSdkElement, sdkElement, SDK_ELEMENT_TARGET_PROJECT_TEMPLATE_ATTRIBUTE);
        return sdkElement;
    }

    private static Element createEnvElement(String sdkName, String sdkVersion, String sdkPath, Document document) {
        Element envElement = document.createElement(ENV_ELEMENT);
        envElement.setAttribute("name", ImportMcalSdkHandler.createEnvName(sdkName, sdkVersion));
        envElement.setAttribute(ENV_ELEMENT_VALUE_ATTRIBUTE, sdkPath);
        envElement.setAttribute(ENV_ELEMENT_IS_SYSTEM_ATTRIBUTE, Boolean.FALSE.toString());
        return envElement;
    }

    private static String createEnvName(String sdkName, String sdkVersion) {
        return NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_sdk_id_mask, (Object)sdkName.toUpperCase(), (Object)sdkVersion);
    }

    private static Element createSymbolsElement(Element mcalSdkElement, Document document) {
        NodeList symbolsNodes = mcalSdkElement.getElementsByTagName("symbols");
        if (symbolsNodes.getLength() == 0) {
            return null;
        }
        Element symbolsElement = (Element)symbolsNodes.item(0);
        NodeList symbolNodes = symbolsElement.getElementsByTagName("symbol");
        if (symbolNodes.getLength() == 0) {
            return null;
        }
        Element sdkSymbolsElement = document.createElement("symbols");
        int i = 0;
        while (i < symbolNodes.getLength()) {
            Element mcalSymbolElement = (Element)symbolNodes.item(i);
            Element sdkSymbolElement = document.createElement("symbol");
            ImportMcalSdkHandler.copyAttribute(mcalSymbolElement, sdkSymbolElement, "name");
            ImportMcalSdkHandler.copyAttribute(mcalSymbolElement, sdkSymbolElement, "langId");
            ImportMcalSdkHandler.copyAttribute(mcalSymbolElement, sdkSymbolElement, "type");
            sdkSymbolsElement.appendChild(sdkSymbolElement);
            ++i;
        }
        return sdkSymbolsElement;
    }

    private static void createFileElements(String sdkPath, String mcalPath, String mcalConfigPath, Element sdkElementSource, Element sdkElementTarget, Document document) {
        IStatus status = ImportMcalSdkHandler.checkMcalConfigDirectory(mcalConfigPath);
        if (status.isOK()) {
            File mcalConfigHeadersDir = Paths.get(mcalConfigPath, MCAL_CONFIG_INCLUDE_DIR).toFile();
            Set<Path> configHeaderFiles = ImportMcalSdkHandler.copyMcalConfigFiles(mcalConfigHeadersDir, sdkPath);
            ImportMcalSdkHandler.createFileElements(HEADER_FILE_ELEMENT, configHeaderFiles, sdkPath, sdkElementTarget, document);
            ImportMcalSdkHandler.handleMcalFiles(mcalConfigHeadersDir, mcalPath, sdkPath, sdkElementSource, sdkElementTarget, document);
            File mcalConfigSourceDir = Paths.get(mcalConfigPath, MCAL_CONFIG_SOURCES_DIR).toFile();
            Set<Path> configSourceFiles = ImportMcalSdkHandler.copyMcalConfigFiles(mcalConfigSourceDir, sdkPath);
            ImportMcalSdkHandler.createFileElements(SOURCE_FILE_ELEMENT, configSourceFiles, sdkPath, sdkElementTarget, document);
        } else {
            ImportMcalSdkHandler.reportError(status);
        }
    }

    private static void handleMcalFiles(File mcalConfigIncludeDir, String mcalPath, String sdkPath, Element sdkElementSource, Element sdkElementTarget, Document document) {
        Arrays.stream(mcalConfigIncludeDir.listFiles()).flatMap(file -> config2McalModule.getOrDefault(file.getName(), Collections.emptyList()).stream()).forEach(mod -> ImportMcalSdkHandler.copyMcalFiles(mcalPath, sdkPath, mod, sdkElementSource, sdkElementTarget, document));
        config2McalModule.getOrDefault("", Collections.emptyList()).stream().forEach(mod -> ImportMcalSdkHandler.copyMcalFiles(mcalPath, sdkPath, mod, sdkElementSource, sdkElementTarget, document));
    }

    private static void copyMcalFiles(String mcalPath, String sdkPath, String module, Element sdkElementSource, Element sdkElementTarget, Document document) {
        Set<Path> headerFilesPaths = ImportMcalSdkHandler.copyMcalFiles(mcalPath, sdkPath, HEADER_FILE_ELEMENT, sdkElementSource, module);
        ImportMcalSdkHandler.createFileElements(HEADER_FILE_ELEMENT, headerFilesPaths, sdkPath, sdkElementTarget, document);
        Set<Path> sourceFilesPaths = ImportMcalSdkHandler.copyMcalFiles(mcalPath, sdkPath, SOURCE_FILE_ELEMENT, sdkElementSource, module);
        ImportMcalSdkHandler.createFileElements(SOURCE_FILE_ELEMENT, sourceFilesPaths, sdkPath, sdkElementTarget, document);
        Set<Path> resourceFilesPaths = ImportMcalSdkHandler.copyMcalFiles(mcalPath, sdkPath, RESOURCE_FILE_ELEMENT, sdkElementSource, module);
        ImportMcalSdkHandler.createFileElements(RESOURCE_FILE_ELEMENT, resourceFilesPaths, sdkPath, sdkElementTarget, document);
    }

    private static Set<Path> copyMcalConfigFiles(File mcalConfigFolder, String sdkBasePath) {
        String mcalConfigSubfolder = mcalConfigFolder.getName();
        if (mcalConfigSubfolder == null || mcalConfigSubfolder.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Path> configFilesPaths = new LinkedHashSet<Path>();
        String targetRelativePath = SDK_CONFIG_FILES_SUBDIR + File.separator + mcalConfigSubfolder;
        String targetFolderName = String.valueOf(sdkBasePath) + File.separator + targetRelativePath;
        Path targetFolderPath = Paths.get(targetFolderName, new String[0]);
        try {
            if (!targetFolderPath.toFile().exists()) {
                Files.createDirectories(targetFolderPath, new FileAttribute[0]);
            }
            File[] fileArray = mcalConfigFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File configFile = fileArray[n2];
                Path targetFilePath = Paths.get(targetFolderName, configFile.getName());
                if (!targetFilePath.toFile().exists()) {
                    Files.copy(Paths.get(configFile.getAbsolutePath(), new String[0]), targetFilePath, new CopyOption[0]);
                }
                configFilesPaths.add(targetFilePath);
                ++n2;
            }
        }
        catch (IOException ioe) {
            ImportMcalSdkHandler.reportError("Fail to copy MCAL config file: skip", ioe);
        }
        return configFilesPaths;
    }

    private static Set<Path> copyMcalFiles(String mcalPath, String sdkPath, String elementName, Element sdkElementSource, String module) {
        LinkedHashSet<Path> mcalFilesPaths = new LinkedHashSet<Path>();
        NodeList mcalFileElements = sdkElementSource.getElementsByTagName(elementName);
        int i = 0;
        while (i < mcalFileElements.getLength()) {
            Element mcalFileElement = (Element)mcalFileElements.item(i);
            String mcalFilePath = mcalFileElement.getAttribute(PATH_ATTRIBUTE);
            if (mcalFilePath.contains(module)) {
                Path targetFolderPath = Paths.get(sdkPath, Paths.get(mcalFilePath, new String[0]).getParent().toString());
                try {
                    Files.createDirectories(targetFolderPath, new FileAttribute[0]);
                    Path targetFilePath = Paths.get(String.valueOf(sdkPath) + File.separator + mcalFilePath, new String[0]);
                    if (!targetFilePath.toFile().exists()) {
                        Files.copy(Paths.get(mcalPath, mcalFilePath), targetFilePath, new CopyOption[0]);
                        mcalFilesPaths.add(targetFilePath);
                    }
                }
                catch (IOException ioe) {
                    ImportMcalSdkHandler.reportError("Fail to copy MCAL file: skip", ioe);
                }
            }
            ++i;
        }
        return mcalFilesPaths;
    }

    private static void createFileElements(String elementName, Set<Path> filesPaths, String sdkPath, Element sdkElement, Document document) {
        filesPaths.forEach(path -> ImportMcalSdkHandler.createFileElement(elementName, Paths.get(sdkPath, new String[0]).relativize((Path)path).toString(), sdkElement, document));
    }

    private static String createMcalDescriptorXml(Document document) throws TransformerException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(baos));
        return baos.toString(CHARSET_NAME);
    }

    private static void createFileElement(String elementName, String path, Element sdkElement, Document document) {
        Element fileElement = document.createElement(elementName);
        fileElement.setAttribute(COPY_ATTRIBUTE, "false");
        fileElement.setAttribute(PATH_ATTRIBUTE, path);
        sdkElement.appendChild(fileElement);
    }

    private static void copyAttribute(Element sourceElement, Element targetElement, String attributeName) {
        targetElement.setAttribute(attributeName, sourceElement.getAttribute(attributeName));
    }

    private static String loadXml(String path) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = Files.newBufferedReader(Paths.get(path, new String[0]));){
                StringBuilder sb = new StringBuilder();
                br.lines().forEach(sb::append);
                return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            ImportMcalSdkHandler.reportError(NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_read_error, (Object)path), ioe);
            return null;
        }
    }

    private static void reportError(String message) {
        ImportMcalSdkHandler.reportError(message, null);
    }

    private static void reportError(String message, Throwable e) {
        SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", message, e));
    }

    private static void reportError(IStatus errorStatus) {
        SDKSupportPlugin.log(errorStatus);
    }

    private static class McalConfiguratorParser {
        private static final String MCAL_CONFIG_ROOT_ELEMENT = "mcal_config";
        private static final String MCAL_CONFIG_CONFIG_ELEMENT = "config";
        private static final String MCAL_CONFIG_CONFIG_ELEMENT_NAME_ATTRIBUTE = "name";
        private static final String MCAL_CONFIG_CONFIG_ELEMENT_MODULE_ATTRIBUTE = "module";

        private McalConfiguratorParser() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static IStatus initConfig2McalModuleMap(String mcalConfiguratorXml, String mcalConfiguratorPath) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    Status status;
                    ByteArrayInputStream stream = new ByteArrayInputStream(mcalConfiguratorXml.getBytes(ImportMcalSdkHandler.CHARSET_NAME));
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        parser.setErrorHandler(new DefaultHandler());
                        Element mcalConfiguratorRootElement = parser.parse(stream).getDocumentElement();
                        if (!MCAL_CONFIG_ROOT_ELEMENT.equals(mcalConfiguratorRootElement.getTagName())) {
                            status = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_invalid_structure, (Object)mcalConfiguratorXml));
                            return status;
                        }
                        NodeList configElements = mcalConfiguratorRootElement.getElementsByTagName("config");
                        int count = configElements.getLength();
                        if (count == 0) {
                            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_missed_sdk_node, (Object)mcalConfiguratorXml));
                        }
                        int i = 0;
                        while (true) {
                            if (i >= configElements.getLength()) {
                                return Status.OK_STATUS;
                            }
                            Element configElement = (Element)configElements.item(i);
                            String configName = configElement.getAttribute("name");
                            String moduleName = configElement.getAttribute(MCAL_CONFIG_CONFIG_ELEMENT_MODULE_ATTRIBUTE);
                            config2McalModule.computeIfAbsent(configName, s -> new ArrayList()).add(moduleName);
                            ++i;
                        }
                    }
                    finally {
                        if (stream == null) return status;
                        stream.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ImportMcalSdkHandler_mcal_descriptor_parse_error, (Object)mcalConfiguratorPath, (Object)e));
            }
        }
    }
}

