/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.ContributedExternalSdk;
import com.freescale.s32ds.cross.sdk.internal.ContributedSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.nxp.s32ds.cle.ide.sdk.core.SDKDescriptorParser;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class ContributedSdkHandler {
    private static final String CONTRIBUTED_EXTERNAL_SDKS_PREF_KEY = "com.nxp.s32ds.cle.runtime.sdk.contributed.sdks";
    private static final String SDKS_ELEMENT = "sdks";
    private static final String SDK_ELEMENT = "sdk";
    private static final String SDK_ID_ATTRIBUTE = "id";
    private static final String SDK_DESCRIPTOR_PATH_ATTRIBUTE = "descriptorPath";
    private static final String EXTERNAL_SDK_DESCRIPTORS_DIR = "S32DS_EXTERNAL_SDK_DESCRIPTORS_DIR";

    public static void loadContributedSdks() {
        ContributedSdkHandler.loadContributedInternalSdks();
        ContributedSdkHandler.loadContributedExternalSdks();
    }

    public static void loadContributedInternalSdks() {
        ContributedSDK.loadContributedSDKs();
    }

    public static void loadContributedExternalSdks() {
        ContributedSdkHandler.loadPersistedContributedExternalSdks();
        ContributedSdkHandler.loadFromDescriptorsDirectory();
    }

    public static Map<IStatus, List<ISDK>> loadFromDescriptorFile(String sdkDescriptorFilePath, boolean isPersistToPrefs) {
        LinkedHashMap<IStatus, List<ISDK>> result = new LinkedHashMap();
        String resolvedPathToSdkManifest = null;
        try {
            resolvedPathToSdkManifest = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkDescriptorFilePath, true);
            result = ContributedSdkHandler.loadSdks(resolvedPathToSdkManifest, isPersistToPrefs);
        }
        catch (CoreException ce) {
            result.put((IStatus)ContributedSdkHandler.reportSdkLoadingError(sdkDescriptorFilePath, (Exception)((Object)ce)), Collections.emptyList());
        }
        return result;
    }

    public static Map<IStatus, List<String>> loadFromDescriptorFile(String sdkDescriptorFilePath) {
        LinkedHashMap<IStatus, List<String>> result = new LinkedHashMap<IStatus, List<String>>();
        Map<IStatus, List<ISDK>> status2SdksMap = ContributedSdkHandler.loadFromDescriptorFile(sdkDescriptorFilePath, true);
        for (Map.Entry<IStatus, List<ISDK>> entry : status2SdksMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().stream().map(IModelSDK::getId).collect(Collectors.toList()));
        }
        return result;
    }

    public static Map<IStatus, List<ISDK>> loadFromDescriptorsXml(String sdkDescriptorXml) throws SDKLoadException {
        LinkedHashMap<IStatus, List<ISDK>> result = new LinkedHashMap<IStatus, List<ISDK>>();
        List<ISDK> loadedSdks = new SDKDescriptorParser().loadSDKs(sdkDescriptorXml, 7);
        if (loadedSdks.isEmpty()) {
            throw new SDKLoadException("Error: no sdk loaded.");
        }
        List aggregatedSdks = loadedSdks.stream().filter(sdk -> !sdk.getModules().getRefModules().isEmpty()).collect(Collectors.toList());
        loadedSdks.removeAll(aggregatedSdks);
        for (ISDK aggregatedSdk : aggregatedSdks) {
            Set<SdkModule> refModules = aggregatedSdk.getModules().getRefModules();
            for (SdkModule refModule : refModules) {
                ISDK refSdk = loadedSdks.stream().filter(loadedSdk -> loadedSdk.getId().equals(refModule.getSdkId())).findFirst().orElse(null);
                if (refSdk == null) continue;
                ContributedSdkHandler.registerSdk(refSdk, false, result);
                loadedSdks.remove(refSdk);
            }
            ContributedSdkHandler.registerSdk(aggregatedSdk, true, result);
        }
        loadedSdks.forEach(loadedSdk -> ContributedSdkHandler.registerSdk(loadedSdk, true, result));
        return result;
    }

    public static void updatePersistedContributedExternalSdks() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.put(CONTRIBUTED_EXTERNAL_SDKS_PREF_KEY, ContributedSdkHandler.getSdkDescriptorsXml());
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
    }

    private static void loadPersistedContributedExternalSdks() {
        String sdkDescriptorsXml = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier()).get(CONTRIBUTED_EXTERNAL_SDKS_PREF_KEY, "");
        if (sdkDescriptorsXml != null && !sdkDescriptorsXml.isEmpty()) {
            try {
                ContributedSdkHandler.loadFromDescriptorsXml(sdkDescriptorsXml);
            }
            catch (Exception e) {
                SDKSupportPlugin.error(e);
            }
        }
    }

    private static Map<IStatus, List<ISDK>> loadSdks(String resolvedPath, boolean isPersistToPrefs) {
        Map<IStatus, List<ISDK>> result = new LinkedHashMap<IStatus, List<ISDK>>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = Files.newBufferedReader(Paths.get(resolvedPath, new String[0]));){
                StringBuilder sb = new StringBuilder();
                br.lines().forEach(sb::append);
                result = ContributedSdkHandler.loadFromDescriptorsXml(sb.toString());
                if (isPersistToPrefs) {
                    ContributedSdkHandler.updatePersistedContributedExternalSdks();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            result.put((IStatus)ContributedSdkHandler.reportSdkLoadingError(resolvedPath, e), Collections.emptyList());
        }
        return result;
    }

    private static void loadFromDescriptorsDirectory() {
        IStringVariableManager svm = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable vv = svm.getValueVariable(EXTERNAL_SDK_DESCRIPTORS_DIR);
        if (vv == null) {
            return;
        }
        String sdkDescriptorsDirectoryName = vv.getValue();
        if (sdkDescriptorsDirectoryName == null || sdkDescriptorsDirectoryName.isEmpty()) {
            return;
        }
        Path sdkDescriptorsDirectoryPath = Paths.get(sdkDescriptorsDirectoryName, new String[0]);
        File sdkDescriptorsDirectoryFile = sdkDescriptorsDirectoryPath.toFile();
        if (!sdkDescriptorsDirectoryFile.exists() || !sdkDescriptorsDirectoryFile.isDirectory()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<Path> fileList = Files.list(sdkDescriptorsDirectoryPath);){
                fileList.map(Path::toFile).filter(File::isFile).map(File::getAbsolutePath).forEach(path -> {
                    Map<IStatus, List<ISDK>> map = ContributedSdkHandler.loadFromDescriptorFile(path, false);
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            SDKSupportPlugin.error(e);
        }
    }

    private static String getSdkDescriptorsXml() {
        return AbstractSDK.getSDKsString(SDKUtils.filter(ContributedExternalSdk.getSdkFilter()));
    }

    private static String convertSdkDescriptorPathsToXml(Map<String, String> sdkDescriptorPaths) {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootElement = document.createElement(SDKS_ELEMENT);
            document.appendChild(rootElement);
            for (Map.Entry<String, String> entry : sdkDescriptorPaths.entrySet()) {
                Element sdkElement = document.createElement(SDK_ELEMENT);
                sdkElement.setAttribute(SDK_ID_ATTRIBUTE, entry.getKey());
                sdkElement.setAttribute(SDK_DESCRIPTOR_PATH_ATTRIBUTE, entry.getValue());
                rootElement.appendChild(sdkElement);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return s.toString("UTF8");
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            SDKSupportPlugin.error(Messages.AbstractSDK_exception_store, e);
            return "";
        }
    }

    private static Map<String, String> parseSdkDescriptorPathsXml(String sourceXml) throws SDKLoadException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (sourceXml == null || sourceXml.length() == 0) {
            return result;
        }
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sourceXml.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception e) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format, e);
        }
        if (!root.getNodeName().equals(SDKS_ELEMENT)) {
            throw new SDKLoadException(Messages.AbstractSDK_bad_format);
        }
        NodeList sdkNodes = root.getElementsByTagName(SDK_ELEMENT);
        int i = 0;
        while (i < sdkNodes.getLength()) {
            Element sdkElement = (Element)sdkNodes.item(i);
            String id = sdkElement.getAttribute(SDK_ID_ATTRIBUTE);
            String descriptorPath = sdkElement.getAttribute(SDK_DESCRIPTOR_PATH_ATTRIBUTE);
            result.put(id, descriptorPath);
            ++i;
        }
        return result;
    }

    private static void registerSdk(ISDK sdk, boolean isRewrite, Map<IStatus, List<ISDK>> result) {
        if (sdk == null) {
            return;
        }
        IStatus addStatus = SDKUtils.addVerbose(sdk, isRewrite, false);
        if (!addStatus.isOK()) {
            SDKSupportPlugin.log(addStatus);
        }
        result.computeIfAbsent(addStatus, s -> new ArrayList()).add(sdk);
    }

    private static Status reportSdkLoadingError(String sdkDescriptorFilePath, Exception e) {
        Status status = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ContributedExternalSdk_load_sdk_error, (Object)sdkDescriptorFilePath), (Throwable)e);
        SDKSupportPlugin.log((IStatus)status);
        return status;
    }
}

