/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CClassDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CEnumeratorDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CFunctionDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CMacroDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CMethodDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CTemplateClassDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.CTemplateFunctionDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.IDragSourceProcessor;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.SelectConstructorDialog;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.ui.PlatformUI;

public abstract class ADragSourceProcessor
implements IDragSourceProcessor {
    private static final String FUNCTION_RETURN_TYPE_PATTERN = "%s = ";
    protected static final String CLASS_INSTANCE_VARIABLE_PATTERN = "my%s%s";
    protected ICElement cel;

    @Override
    public abstract String getFormattedInvocation();

    protected String getNamespacePrefix(ICElement st) {
        String namespacePrefix = "";
        if (st.getParent() instanceof INamespace) {
            namespacePrefix = String.valueOf(st.getParent().getElementName()) + "::";
        }
        return namespacePrefix;
    }

    protected String getReturnType(IFunctionDeclaration fd) {
        String retType = fd.getReturnType();
        String returnExpression = !"void".equals(retType) ? String.format(FUNCTION_RETURN_TYPE_PATTERN, retType) : "";
        return returnExpression;
    }

    protected String getTemplateParameterTypes(ITemplate t) {
        StringBuilder sb = new StringBuilder();
        String[] pTypes = t.getTemplateParameterTypes();
        int i = 0;
        while (i < pTypes.length) {
            if (i > 0) {
                sb.append(',').append(' ');
            }
            this.appendParameter(sb, pTypes[i]);
            ++i;
        }
        return sb.toString();
    }

    protected String getParameters() {
        return this.getParameters(this.cel);
    }

    protected String getParameters(ICElement element) {
        boolean isFunctionalMacro;
        StringBuilder sb = new StringBuilder();
        boolean isFunction = element instanceof IFunctionDeclaration;
        boolean bl = isFunctionalMacro = element instanceof IMacro && ((IMacro)element).isFunctionStyle();
        if (isFunction || isFunctionalMacro) {
            sb.append('(');
            String[] pTypes = null;
            if (isFunction || isFunctionalMacro) {
                pTypes = ((IFunctionDeclaration)element).getParameterTypes();
                int paramsLength = pTypes.length;
                int i = 0;
                while (i < paramsLength) {
                    if (i > 0) {
                        sb.append(',').append(' ');
                    }
                    this.appendParameter(sb, pTypes[i]);
                    ++i;
                }
                sb.append(')');
            }
        }
        return sb.toString();
    }

    protected String getConstructorParams(IMethodDeclaration constructor) {
        String params = constructor != null && constructor.getNumberOfParameters() > 0 ? this.getParameters((ICElement)constructor) : "";
        return params;
    }

    protected IMethodDeclaration getConstructor(IStructure cclass) {
        IMethodDeclaration result = null;
        try {
            ArrayList<IMethodDeclaration> constructors = new ArrayList<IMethodDeclaration>();
            ICElement[] iCElementArray = cclass.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodDeclaration md;
                ICElement el = iCElementArray[n2];
                if (el instanceof IMethodDeclaration && (md = (IMethodDeclaration)el).isConstructor()) {
                    constructors.add(md);
                }
                ++n2;
            }
            if (!constructors.isEmpty()) {
                if (constructors.size() > 1) {
                    SelectConstructorDialog scd = new SelectConstructorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), constructors);
                    if (scd.open() == 0) {
                        result = scd.getResult();
                    }
                } else {
                    result = (IMethodDeclaration)constructors.get(0);
                }
            }
        }
        catch (CModelException e) {
            SDKSupportPlugin.error(e);
        }
        return result;
    }

    public static IDragSourceProcessor getDragSourceProcessor(ICElement cel) {
        switch (cel.getElementType()) {
            case 79: {
                return new CMacroDragSourceProcessor(cel);
            }
            case 64: 
            case 65: {
                return new CClassDragSourceProcessor(cel);
            }
            case 82: 
            case 83: {
                return new CTemplateClassDragSourceProcessor(cel);
            }
            case 70: 
            case 71: {
                return new CMethodDragSourceProcessor(cel);
            }
            case 73: 
            case 74: {
                return new CFunctionDragSourceProcessor(cel);
            }
            case 88: 
            case 89: {
                return new CTemplateFunctionDragSourceProcessor(cel);
            }
            case 81: {
                return new CEnumeratorDragSourceProcessor(cel);
            }
        }
        throw new UnsupportedOperationException();
    }

    private StringBuilder appendParameter(StringBuilder sb, String pType) {
        return "void".equals(pType) ? sb : sb.append(pType);
    }
}

