/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors.ADragSourceProcessor;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IWorkbenchPartSite;

public class SDKExplorerDragSourceListener
extends ADragSourceListener {
    private static final String DERIVATIVE = "derivative.h";
    private static final String INCLUDE = "#include \"";
    private static final String SDK = "\t// SDK";
    private static final String LF = "\r\n";
    private ICElement element;
    private String saved_data = null;

    public SDKExplorerDragSourceListener(AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite workbenchPartSite) {
        super(abstractTreeViewer, workbenchPartSite);
    }

    protected boolean isProcessDataDragAndDrop(Object data) {
        return data instanceof ISourceManipulation;
    }

    protected void performDragSetData(DragSourceEvent event, Object data) {
        try {
            ICElement ce = (ICElement)data;
            if (ce instanceof ITranslationUnit) {
                this.saved_data = ((ITranslationUnit)ce).getLocation().lastSegment();
                event.data = "\u0000";
                if (OSFamily.LINUX.isCurrent()) {
                    event.doit = false;
                }
            } else {
                String invocationString = ADragSourceProcessor.getDragSourceProcessor(ce).getFormattedInvocation();
                Object object = event.data = invocationString != null ? invocationString : " ";
                if (79 == ce.getElementType()) {
                    this.saved_data = ((IMacro)ce).getParent().getPath().lastSegment();
                }
            }
            this.updateIndex(ce.getParent());
            this.element = ce;
        }
        catch (CoreException ce) {
            SDKSupportPlugin.error(ce);
        }
    }

    protected void performDragFinished(DragSourceEvent event) {
        try {
            ITranslationUnit tu = ((ISourceReference)this.element).getTranslationUnit();
            IWorkingCopy tuToEdit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
            IInclude[] includes = tuToEdit.getIncludes();
            IInclude first = includes.length > 0 ? includes[0] : null;
            String tuPath = tu.getLocation().lastSegment();
            boolean contains = Stream.of(includes).anyMatch(inc -> inc.getIncludeName().equals(tuPath));
            IInclude derivative = tuToEdit.getInclude(DERIVATIVE);
            boolean isReCreateDerivative = false;
            if (derivative != null) {
                derivative.delete(true, null);
                tuToEdit.save(null, true);
                tuToEdit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
                isReCreateDerivative = true;
            }
            if (!contains) {
                ICElement before = first != null && !first.equals(derivative) ? first : tuToEdit.getChildren()[0];
                ISourceRange sourceRange = ((ISourceReference)before).getSourceRange();
                String contents = tuToEdit.getBuffer().getContents();
                int startPos = sourceRange.getStartPos();
                boolean isCreateStandardInclude = false;
                if (startPos == 0) {
                    isCreateStandardInclude = true;
                } else {
                    int type = Character.getType(contents.codePointAt(startPos - 1));
                    if (type == 13 || type == 15) {
                        isCreateStandardInclude = true;
                    }
                }
                String includeName = tu.getLocation().lastSegment();
                if (isCreateStandardInclude) {
                    IInclude newInclude = tuToEdit.createInclude(includeName, false, before, null);
                    if (isReCreateDerivative) {
                        tuToEdit.createInclude(DERIVATIVE, false, (ICElement)newInclude, null);
                    }
                } else {
                    String include = INCLUDE + includeName + '\"';
                    int i = startPos;
                    while (i >= 0) {
                        int type = Character.getType(contents.codePointAt(i));
                        if (type == 13 || type == 15 || i == 0) {
                            StringBuilder sb = new StringBuilder(contents.substring(0, i));
                            if (i > 0) {
                                sb.append(LF);
                            }
                            sb.append(include).append(SDK).append(LF).append(contents.substring(i));
                            tuToEdit.getBuffer().setContents(sb.toString());
                            tuToEdit.save(null, true);
                            tuToEdit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
                            break;
                        }
                        --i;
                    }
                    if (isReCreateDerivative) {
                        tuToEdit.createInclude(DERIVATIVE, false, (ICElement)tuToEdit.getInclude(includeName), null);
                    }
                }
                this.updateIndex((ICElement)tuToEdit);
            }
        }
        catch (CoreException e) {
            SDKSupportPlugin.error(e);
        }
    }

    protected void updateIndex(ICElement element) throws CoreException {
        IIndexManager indexManager = CCorePlugin.getIndexManager();
        indexManager.update(new ICElement[]{element}, 41);
    }

    private String getName(String full) {
        int n = (full = full.replace('\\', '/').trim()).lastIndexOf(47);
        return n < 0 ? full : full.substring(n + 1);
    }
}

