/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal.property;

import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.AbstractSmartFilter;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.SDKLatestVersionFilter;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKSelectDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKTableViewerHolder;
import com.freescale.s32ds.cross.sdk.ui.internal.property.ASDKPropertyPage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SDKWizardPropertyPage
extends ASDKPropertyPage {
    private static final String HELP_CONTEXT_WIZARD_ID = "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_WIZARD_context";
    private Set<ISDK> checkedSdkList = new LinkedHashSet<ISDK>();
    private SDKSelectDialog holderDialog;
    private ISDKFilterInfo info;

    public SDKWizardPropertyPage(ISDKFilterInfo info, SDKSelectDialog holderDialog) {
        this.info = info;
        this.holderDialog = holderDialog;
    }

    @Override
    public void saveSDKVersionFilterPreference() {
        this.saveSDKVersionFilterGlobalPreference();
    }

    public void setSelected(Object[] selection) {
        if (selection == null || selection.length == 0) {
            return;
        }
        Stream.of(selection).filter(s -> s instanceof ISDK).forEach(s -> {
            boolean bl = this.checkedSdkList.add((ISDK)s);
        });
        this.updateCheckedItems();
    }

    public List<ISDK> getSelectedToAttach() {
        return new ArrayList<ISDK>(this.checkedSdkList);
    }

    public void cancelSelectedToAttach() {
        this.checkedSdkList.clear();
    }

    public void setFilterInfo(ISDKFilterInfo info) {
        this.info = info;
    }

    public void setHolderDialog(SDKSelectDialog holderDialog) {
        this.holderDialog = holderDialog;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        CheckboxTableViewer ctv = SDKTableViewerHolder.newCheckList(parent);
        ctv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (!(element instanceof ISDK)) {
                    return;
                }
                if (event.getChecked()) {
                    SDKWizardPropertyPage.this.checkedSdkList.add((ISDK)element);
                } else if (SDKWizardPropertyPage.this.checkedSdkList.contains(element)) {
                    SDKWizardPropertyPage.this.checkedSdkList.remove(element);
                }
            }
        });
        return ctv;
    }

    @Override
    protected void createExtraButtons(Composite parent) {
    }

    @Override
    protected void updateExtraButtonsState() {
    }

    @Override
    protected List<ISDK> getSDKs() {
        AbstractSmartFilter abstractSmartFiler = new AbstractSmartFilter(){

            @Override
            public boolean accept(ISDK sdk) {
                return !(sdk instanceof IProjectLocalSDK);
            }

            @Override
            public IFilterOptions options() {
                return FilterOptions.createFilter(SDKWizardPropertyPage.this.info);
            }
        };
        if (this.isLatestSDKVersionsOnly) {
            return this.getFilteredSdks(new SDKLatestVersionFilter(abstractSmartFiler));
        }
        return this.getFilteredSdks(abstractSmartFiler);
    }

    @Override
    protected void createFilterArea(Composite parent) {
        this.createVersionFilterCheckbox(parent);
    }

    @Override
    protected void loadSDKVersionFilterPreference() {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
        this.isLatestSDKVersionsOnly = prefs.getBoolean("FILTER_SDKs_SHOW_LATEST_VERSIONS", false);
    }

    @Override
    public void updateWidgetState() {
        super.updateWidgetState();
        this.updateCheckedItems();
    }

    @Override
    protected void createAddButton(Composite groupComponent) {
    }

    @Override
    protected void createRemoveButton(Composite groupComponent) {
    }

    @Override
    protected Composite createContents(Composite parent) {
        Composite page = super.createContents(parent);
        this.setHelpContextId(page);
        return page;
    }

    @Override
    protected void setHelpContextId(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_WIZARD_ID);
    }

    @Override
    protected void updateEnabledState() {
        Button b;
        super.updateEnabledState();
        if (this.holderDialog != null && (b = this.holderDialog.getOK()) != null) {
            b.setEnabled(this.checksAreOk());
        }
    }

    private boolean checksAreOk() {
        this.holderDialog.setMessage("");
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked() && ti.getData() instanceof ISDK && ((ISDK)ti.getData()).getStatus() == ISDK.STATUS.HEAD) {
                this.holderDialog.setMessage(NLS.bind((String)Messages.SDKManagementWidget_need_load_sources, null));
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void updateCheckedItems() {
        Stream.of(this.viewer.getTable().getItems()).forEach(i -> i.setChecked(i.getData() instanceof ISDK && this.checkedSdkList.contains(i.getData())));
    }
}

