/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal.property;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.sdk.internal.SDKLatestVersionFilter;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import com.freescale.s32ds.cross.sdk.internal.attach.SDKAttachStatusesHolder;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKAttachConfigurationsDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKTableViewerHolder;
import com.freescale.s32ds.cross.sdk.ui.internal.property.ASDKPropertyPage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class SDKProjectPropertyPage
extends ASDKPropertyPage {
    private static final String HELP_CONTEXT_PROJECT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_PROJECT_context";
    private IProject project;
    private Button attachButton;
    private Button makeGlobalButton;
    private Button showAllCheckbox;
    private boolean showAllForProject;

    public SDKProjectPropertyPage(IProject project) {
        this.project = project;
        this.loadSDKVersionFilterPreference();
    }

    @Override
    public void saveSDKVersionFilterPreference() {
        try {
            IEclipsePreferences prefs = new ProjectScope(this.getProject()).getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.putBoolean("FILTER_SDKs_SHOW_LATEST_VERSIONS", this.isLatestSDKVersionsOnly);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", bse.getMessage()));
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        SDKAttachStatusesHolder.INSTANCE.loadAvailableSDKsAttachStates(this.project);
        this.detachUnavailableSDKsFromProject(SDKAttach.getUnavailableSDKs(this.project), this.project);
        TableViewer tv = SDKTableViewerHolder.newSelList(parent, this.getProject(), SDKAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates());
        return tv;
    }

    @Override
    protected void setHelpContextId(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_PROJECT_ID);
    }

    @Override
    protected void updateExtraButtonsState() {
        ISDK sdkFromSel = this.getFirstSelected();
        this.makeGlobalButton.setEnabled(this.isSelectedSingle() && sdkFromSel instanceof IProjectLocalSDK && sdkFromSel.isAvailable());
        boolean isAttachable = SDKAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates().isEmpty() || !this.canAttachSel() ? false : !this.getSelectedAttachable().isEmpty();
        this.attachButton.setEnabled(isAttachable);
        this.updateExportButtonState();
        this.updateShowAllFilterCheckbox();
    }

    @Override
    protected List<ISDK> getSDKs() {
        AvailableSDKFilter baseFiler;
        AvailableSDKFilter availableSDKFilter = baseFiler = this.showAllForProject ? new AvailableSDKFilter(this.project){

            @Override
            public IFilterOptions options() {
                return null;
            }
        } : new AvailableSDKFilter(this.project);
        if (this.isLatestSDKVersionsOnly) {
            return this.getFilteredSdks(new SDKLatestVersionFilter(baseFiler));
        }
        return this.getFilteredSdks(baseFiler);
    }

    @Override
    protected void loadSDKVersionFilterPreference() {
        if (this.getProject() != null) {
            IEclipsePreferences prefs = new ProjectScope(this.getProject()).getNode(SDKSupportPlugin.getUniqueIdentifier());
            this.isLatestSDKVersionsOnly = prefs.getBoolean("FILTER_SDKs_SHOW_LATEST_VERSIONS", false);
        }
    }

    @Override
    protected IProject getProject() {
        return this.project;
    }

    @Override
    protected void createExtraButtons(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createAttachDetachButton(parent);
        this.createMakeGlobalButton(parent);
        this.createImportExportButtons(parent);
    }

    @Override
    protected void createFilterArea(Composite parent) {
        Composite filtersGroup = new Composite(parent, 0);
        filtersGroup.setLayout((Layout)new GridLayout(2, true));
        this.createVersionFilterCheckbox(filtersGroup);
        this.createShowAllFilterCheckbox(filtersGroup);
    }

    @Override
    protected IFilterOptions getFilterOptions() {
        return AvailableSDKFilter.options(this.getProject());
    }

    @Override
    protected ISDK performCreateSDK() {
        ISDK sdk = super.performCreateSDK();
        if (sdk != null) {
            ProjectLocalSDK.storeProjectLocalSDK(this.project);
            SDKAttach.reAttachSDK(sdk, this.project);
            SDKAttachStatusesHolder.INSTANCE.addSdkAttachStates(sdk, this.project);
        }
        this.updateWidgetState();
        return sdk;
    }

    @Override
    protected ISDK performViewEditSDK() {
        ISDK sdk = super.performViewEditSDK();
        if (sdk != null) {
            ProjectLocalSDK.storeProjectLocalSDK(this.project);
            SDKAttachStatusesHolder.INSTANCE.addSdkAttachStates(sdk, this.project);
        }
        this.updateWidgetState();
        return sdk;
    }

    @Override
    protected List<ISDK> performRemoveSDK() {
        List<ISDK> removedSDKs = super.performRemoveSDK();
        if (!removedSDKs.isEmpty()) {
            ProjectLocalSDK.storeProjectLocalSDK(this.project);
            SDKAttachStatusesHolder.INSTANCE.removeSDKAttachStates(removedSDKs, this.project);
        }
        this.updateWidgetState();
        return removedSDKs;
    }

    @Override
    protected List<ISDK> performImportSDK() {
        List<ISDK> importedSDKs = super.performImportSDK();
        if (importedSDKs != null) {
            importedSDKs.stream().forEach(sdk -> SDKAttachStatusesHolder.INSTANCE.addSdkAttachStates((ISDK)sdk, this.project));
        }
        this.updateWidgetState();
        return importedSDKs;
    }

    private void performMakeGlobal() {
        SDKUtils.convert(this.getFirstSelected(), ISDK.TYPE.EXTERNAL, new Object[0]);
        ExternalSDK.storeExternalSDKs();
        ProjectLocalSDK.storeProjectLocalSDK(this.project);
        this.updateWidgetState();
    }

    private void createAttachDetachButton(final Composite parent) {
        this.attachButton = new Button(parent, 8);
        this.attachButton.setText(Messages.SDKManagementWidget_attach_sdk_button_text);
        this.attachButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectPropertyPage.this.performAttachSelection(parent);
            }
        });
        this.attachButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.attachButton);
    }

    private void createMakeGlobalButton(Composite parent) {
        this.makeGlobalButton = new Button(parent, 8);
        this.makeGlobalButton.setText(NLS.bind((String)Messages.SDKManagementWidget_make_global_sdk_button_text, null));
        this.makeGlobalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKProjectPropertyPage.this.performMakeGlobal();
            }
        });
        this.makeGlobalButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.makeGlobalButton);
    }

    private List<ISDK> getSelectedAttachable() {
        ArrayList<ISDK> sdks = new ArrayList<ISDK>();
        block0: for (ISDK sdk : this.getAllSelected()) {
            for (IStatus status : SDKAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdk.getId())) {
                if (status == null || !status.isOK()) continue;
                sdks.add(sdk);
                continue block0;
            }
        }
        return sdks;
    }

    private void createShowAllFilterCheckbox(Composite parent) {
        this.showAllCheckbox = new Button(parent, 32);
        this.showAllCheckbox.setText(NLS.bind((String)Messages.SDKManagementWidget_show_all_sdks, null));
        this.showAllCheckbox.setSelection(false);
        this.showAllCheckbox.setVisible(false);
        this.showAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                SDKProjectPropertyPage.this.showAllForProject = b.getSelection();
                SDKProjectPropertyPage.this.updateWidgetState();
            }
        });
    }

    private void updateShowAllFilterCheckbox() {
        if (this.showAllCheckbox == null) {
            return;
        }
        boolean isShowAllFilterEnabled = this.showAllForProject;
        this.showAllForProject = false;
        int originalSize = this.getSDKs().size();
        this.showAllForProject = true;
        int negateSize = this.getSDKs().size();
        this.showAllForProject = isShowAllFilterEnabled;
        this.showAllCheckbox.setVisible(originalSize != negateSize);
    }

    private boolean canAttachSel() {
        TableItem[] items = this.viewer.getTable().getSelection();
        if (items != null && items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                ISDK sdk = (ISDK)item.getData();
                List<IStatus> statuses = SDKAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates().get(sdk.getId());
                if (statuses != null) {
                    for (IStatus status : statuses) {
                        if (!status.isOK()) continue;
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void performAttachSelection(Composite parent) {
        Map<String, List<IStatus>> sdksAttachStates = SDKAttachStatusesHolder.INSTANCE.getActualSDKsAttachStatesCopy();
        LinkedHashMap<String, List<IStatus>> selectedSDKsAttachStates = new LinkedHashMap<String, List<IStatus>>();
        for (ISDK sdk : this.getAllSelected()) {
            String sdkId = sdk.getId();
            selectedSDKsAttachStates.put(sdkId, sdksAttachStates.get(sdkId));
        }
        this.reCheckSDKsAvailablity(selectedSDKsAttachStates);
        SDKAttachConfigurationsDialog cnfDialog = new SDKAttachConfigurationsDialog(parent.getShell(), this.getSelectedAttachable(), this.project, selectedSDKsAttachStates);
        if (cnfDialog.open() == 0) {
            this.reCheckSDKsAvailablity(selectedSDKsAttachStates);
            Map<String, List<IStatus>> toAttach = selectedSDKsAttachStates.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).stream().anyMatch(state -> state.isOK())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            SDKAttach.collectChangedSDKsAttachStates(toAttach);
        }
        this.updateWidgetState();
    }

    private void reCheckSDKsAvailablity(Map<String, List<IStatus>> selectedSDKsAttachStates) {
        for (String sdkId : selectedSDKsAttachStates.keySet()) {
            List<IStatus> actualStates = SDKAttachStatusesHolder.INSTANCE.getSDKAttachStates(SDKUtils.getSDKbyID(sdkId), this.project);
            if (actualStates.isEmpty() || !ISDKAttachStatuses.ERROR_SDK_LOCATION.equals(actualStates.get(0))) continue;
            selectedSDKsAttachStates.put(sdkId, actualStates);
            SDKAttachStatusesHolder.INSTANCE.addSDKAttachStates(sdkId, actualStates);
        }
    }

    private void detachUnavailableSDKsFromProject(List<ISDK> sdks, IProject project) {
        sdks.stream().filter(sdk -> SDKAttach.isAttached(sdk, project)).forEach(sdk -> {
            Shell shell = EclipseUtils.getShell();
            shell.getDisplay().syncExec(() -> {
                if (MessageDialog.openConfirm((Shell)shell, (String)Messages.SDKManagementWidget_detach_unavailable_sdk_confirmation_title, (String)String.format(Messages.SDKManagementWidget_detach_unavailable_sdk_confirmation_message, sdk.getBriefInfo(), project.getName()))) {
                    SDKAttach.detachFrom(sdk, project);
                }
            });
        });
    }
}

