/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal.property;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.GlobalSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.SDKLatestVersionFilter;
import com.freescale.s32ds.cross.sdk.ui.internal.ImportMcalSdkDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKShowDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKTableViewerHolder;
import com.freescale.s32ds.cross.sdk.ui.internal.property.ASDKPropertyPage;
import com.nxp.s32ds.cle.ide.sdk.core.ContributedSdkHandler;
import com.nxp.s32ds.cle.ide.sdk.core.ImportMcalSdkHandler;
import com.nxp.s32ds.cle.ide.sdk.core.InternalSdkHandler;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SDKGlobalPropertyPage
extends ASDKPropertyPage {
    private Button showAttachedButton;

    public SDKGlobalPropertyPage() {
        this.loadSDKVersionFilterPreference();
    }

    @Override
    protected List<ISDK> getSDKs() {
        if (this.isLatestSDKVersionsOnly) {
            return this.getFilteredSdks(new SDKLatestVersionFilter(true));
        }
        return this.getFilteredSdks(new GlobalSDKFilter());
    }

    @Override
    protected void loadSDKVersionFilterPreference() {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
        this.isLatestSDKVersionsOnly = prefs.getBoolean("FILTER_SDKs_SHOW_LATEST_VERSIONS", false);
    }

    @Override
    public void saveSDKVersionFilterPreference() {
        this.saveSDKVersionFilterGlobalPreference();
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        return SDKTableViewerHolder.newList(parent);
    }

    @Override
    protected void createExtraButtons(Composite parent) {
        this.createImportExportButtons(parent);
        this.createLoadButton(parent);
        this.createShowButton(parent);
        this.createImportMcalButton(parent);
    }

    @Override
    protected void createFilterArea(Composite parent) {
        this.createVersionFilterCheckbox(parent);
    }

    @Override
    protected void updateExtraButtonsState() {
        this.updateExportButtonState();
    }

    private void createLoadButton(Composite parent) {
        Button loadExternalButton = new Button(parent, 8);
        loadExternalButton.setText(Messages.SDKGlobalPropertyPage_load_sdk_button_text);
        loadExternalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Map<String, List<IStatus>> loadingStatuses = new LinkedHashMap<String, List<IStatus>>();

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SDKGlobalPropertyPage.this.getShell(), 0x10001002);
                dialog.setText(Messages.SDKGlobalPropertyPage_load_sdk_dialog_title);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                dialog.open();
                String[] selectedDescriptors = dialog.getFileNames();
                if (selectedDescriptors != null && selectedDescriptors.length > 0) {
                    String folderPath = dialog.getFilterPath();
                    Arrays.stream(selectedDescriptors).forEach(descriptorFileName -> this.loadExternalSdks(folderPath, (String)descriptorFileName));
                    this.handleLoadingErrors();
                    this.loadingStatuses.clear();
                    SDKGlobalPropertyPage.this.updateWidgetState();
                }
            }

            private void loadExternalSdks(String folderPath, String descriptorFileName) {
                String descriptorFile = Paths.get(folderPath, descriptorFileName).toString();
                Map<IStatus, List<ISDK>> result = ContributedSdkHandler.loadFromDescriptorFile(descriptorFile, true);
                Set errors = result.keySet().stream().filter(st -> !st.isOK()).collect(Collectors.toSet());
                if (!errors.isEmpty()) {
                    this.loadingStatuses.computeIfAbsent(Paths.get(descriptorFile, new String[0]).getFileName().toString(), s -> new ArrayList()).addAll(errors);
                }
            }

            private void handleLoadingErrors() {
                if (this.loadingStatuses.isEmpty()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, List<IStatus>> e : this.loadingStatuses.entrySet()) {
                    sb.append(NLS.bind((String)"\nFile {0}:\n", (Object)e.getKey()));
                    e.getValue().stream().forEach(s -> {
                        StringBuilder stringBuilder2 = sb.append(NLS.bind((String)" - {0}\n", (Object)s.getMessage()));
                    });
                }
                Shell shell = EclipseUtils.getShell();
                shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.SDKGlobalPropertyPage_load_sdk_error_title, (String)NLS.bind((String)Messages.SDKGlobalPropertyPage_load_sdk_error_message, (Object)sb.toString())));
            }
        });
        loadExternalButton.setFont(parent.getFont());
        this.setButtonLayoutData(loadExternalButton);
    }

    private void createShowButton(final Composite parent) {
        this.showAttachedButton = new Button(parent, 8);
        this.showAttachedButton.setText(NLS.bind((String)Messages.SDKManagementWidget_show_attached_button_text, null));
        this.showAttachedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new SDKShowDialog(parent.getShell(), SDKGlobalPropertyPage.this.getFirstSelected()).open();
            }
        });
        this.showAttachedButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.showAttachedButton);
    }

    private void createImportMcalButton(Composite parent) {
        Button loadExternalButton = new Button(parent, 8);
        loadExternalButton.setText(Messages.ImportMcalSdkDialog_title);
        loadExternalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKGlobalPropertyPage.this.performImportMcalSdk();
            }
        });
        loadExternalButton.setFont(parent.getFont());
        this.setButtonLayoutData(loadExternalButton);
    }

    private void performImportMcalSdk() {
        ImportMcalSdkDialog dialog = new ImportMcalSdkDialog(this.getShell(), SDKUtils.filter(sdk -> sdk.isTaggedBy("mcal") && ImportMcalSdkHandler.checkMcalDescriptorBasePath(sdk.getHeader().getBasePath()).isOK()));
        if (dialog.open() == 0) {
            IStatus importStatus = ImportMcalSdkHandler.performImportMcalSdkByConfiguration(dialog.getMcalSdk(), dialog.getMcalConfigurationPath(), dialog.getSdkName(), dialog.getSdkVersion());
            if (importStatus.isOK()) {
                ContributedSdkHandler.updatePersistedContributedExternalSdks();
                InternalSdkHandler.updatePersistedInternalSdks();
                this.updateWidgetState();
            } else {
                Shell shell = EclipseUtils.getShell();
                shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.SDKGlobalPropertyPage_import_mcal_sdk_message_title, (String)Messages.SDKGlobalPropertyPage_import_mcal_sdk_error_message));
            }
        }
    }
}

