/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal.property;

import com.freescale.s32ds.cross.sdk.IContributedSDK;
import com.freescale.s32ds.cross.sdk.IExternalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKEditDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKExportDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKImportDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKTableViewerHolder;
import com.freescale.s32ds.cross.sdk.ui.internal.SdkInfoDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKImportUICallbackHandler;
import com.nxp.s32ds.cle.ide.sdk.core.ContributedSdkHandler;
import com.nxp.s32ds.cle.ide.sdk.core.InternalSdkHandler;
import com.nxp.s32ds.cle.ide.sdk.core.SDKExportHandler;
import com.nxp.s32ds.cle.ide.sdk.core.SDKImportHandler;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ASDKPropertyPage
extends DialogPage {
    private static final String GIT_ERROR_TITLE = Messages.SDKManagementWidget_cannot_clone_sdk;
    private static final String GIT_EMPTY_REP = Messages.SDKManagementWidget_git_path_not_set;
    private static final String GIT_LOCAL_BAD = Messages.SDKManagementWidget_git_path_not_valid;
    private static final String GIT_LOAD_KEY = "GIT_LOAD_KEY";
    private static final String HELP_CONTEXT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_context";
    protected static final String FILTER_SDKS_PREF_KEY = "FILTER_SDKs_SHOW_LATEST_VERSIONS";
    protected TableViewer viewer;
    protected boolean isLatestSDKVersionsOnly = false;
    private Button editButton;
    private Button removeButton;
    private Button exportButton;
    private Button gitImportButton;
    private Button showLatestVersionsCheckbox;
    private int lastSelection = -1;
    private Shell shell;

    protected ASDKPropertyPage() {
        this.loadSDKVersionFilterPreference();
    }

    public void createControl(Composite parent) {
        Composite control = this.createContents(parent);
        this.setControl((Control)control);
    }

    protected Composite createContents(Composite parent) {
        this.shell = parent.getShell();
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        pageComponent.setLayoutData((Object)new GridData(4, 4, true, false));
        pageComponent.setFont(font);
        Composite tableComposite = new Composite(pageComponent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 600;
        data.heightHint = 300;
        tableComposite.setLayoutData((Object)data);
        this.viewer = this.createTableViewer(tableComposite);
        Table t = this.viewer.getTable();
        t.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ASDKPropertyPage.this.updateEnabledState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (ASDKPropertyPage.this.editButton != null && ASDKPropertyPage.this.editButton.isEnabled()) {
                    ASDKPropertyPage.this.editButton.notifyListeners(13, null);
                }
            }
        });
        t.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    if (ASDKPropertyPage.this.removeButton != null && ASDKPropertyPage.this.removeButton.isEnabled()) {
                        ASDKPropertyPage.this.removeButton.notifyListeners(13, null);
                    }
                } else if (e.keyCode == 32) {
                    if (ASDKPropertyPage.this.editButton != null && ASDKPropertyPage.this.editButton.isEnabled()) {
                        ASDKPropertyPage.this.editButton.notifyListeners(13, null);
                    }
                } else if (e.keyCode == 105 && (e.stateMask & 0x40000) != 0) {
                    ASDKPropertyPage.this.showSdksInfo();
                }
            }
        });
        t.setFont(font);
        this.setupMenu(t);
        this.createButtonGroup(pageComponent);
        if (this.viewer.getTable().getItemCount() > 0) {
            this.viewer.getTable().setSelection(0);
            this.viewer.getTable().setFocus();
            this.updateEnabledState();
        }
        this.setHelpContextId(parent);
        this.updateViewerInput();
        return pageComponent;
    }

    protected void setHelpContextId(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_ID);
    }

    public abstract void saveSDKVersionFilterPreference();

    protected abstract List<ISDK> getSDKs();

    protected abstract void loadSDKVersionFilterPreference();

    protected abstract TableViewer createTableViewer(Composite var1);

    protected abstract void createExtraButtons(Composite var1);

    protected abstract void createFilterArea(Composite var1);

    protected IFilterOptions getFilterOptions() {
        return null;
    }

    protected abstract void updateExtraButtonsState();

    protected IProject getProject() {
        return null;
    }

    protected void createVersionFilterCheckbox(Composite parent) {
        this.showLatestVersionsCheckbox = new Button(parent, 32);
        this.showLatestVersionsCheckbox.setText(NLS.bind((String)Messages.SDKManagementWidget_show_latest_sdk_versions_only, null));
        this.showLatestVersionsCheckbox.setSelection(this.isLatestSDKVersionsOnly);
        this.showLatestVersionsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASDKPropertyPage.this.performFilteringByLatestVersion();
            }
        });
    }

    protected void performFilteringByLatestVersion() {
        this.isLatestSDKVersionsOnly = this.showLatestVersionsCheckbox.getSelection();
        this.updateWidgetState();
    }

    protected void saveSDKVersionFilterGlobalPreference() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.putBoolean(FILTER_SDKS_PREF_KEY, this.isLatestSDKVersionsOnly);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", bse.getMessage()));
        }
    }

    protected void updateExportButtonState() {
        ISDK sdkFromSel = this.getFirstSelected();
        this.exportButton.setEnabled(this.isSelectedSingle() && sdkFromSel instanceof IExternalSDK && sdkFromSel.isAvailable());
    }

    protected void createButtonGroup(Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(groupComponent);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(parent.getFont());
        this.createAddButton(groupComponent);
        this.createViewEditButton(groupComponent);
        this.createRemoveButton(groupComponent);
        this.createGitImportButton(groupComponent);
        this.createExtraButtons(groupComponent);
        this.createFilterArea(parent);
        this.updateEnabledState();
    }

    protected void createAddButton(Composite groupComponent) {
        Button addButton = new Button(groupComponent, 8);
        addButton.setText(NLS.bind((String)Messages.SDKManagementWidget_add_sdk_button_text, null));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASDKPropertyPage.this.performCreateSDK();
            }
        });
        addButton.setFont(groupComponent.getParent().getFont());
        this.setButtonLayoutData(addButton);
    }

    protected void createViewEditButton(Composite groupComponent) {
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(NLS.bind((String)Messages.SDKManagementWidget_edit_sdk_button_text, null));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASDKPropertyPage.this.performViewEditSDK();
            }
        });
        this.editButton.setFont(groupComponent.getParent().getFont());
        this.setButtonLayoutData(this.editButton);
    }

    protected void createRemoveButton(Composite groupComponent) {
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(Messages.SDKManagementWidget_remove_sdk_button_text);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASDKPropertyPage.this.performRemoveSDK();
            }
        });
        this.removeButton.setFont(groupComponent.getParent().getFont());
        this.setButtonLayoutData(this.removeButton);
    }

    protected void createGitImportButton(Composite groupComponent) {
        this.gitImportButton = (Button)new AtomicReference<Button>(new Button(groupComponent, 8), groupComponent){
            {
                ((Button)this.get()).setText(Messages.SDKManagementWidget_Clone_from_git);
                ((Button)this.get()).setFont(composite.getParent().getFont());
                ((Button)this.get()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ASDKPropertyPage.this.loadGitData(ASDKPropertyPage.this.shell);
                    }
                });
                ASDKPropertyPage.this.setButtonLayoutData((Button)this.get());
            }
        }.get();
    }

    protected void createImportExportButtons(Composite parent) {
        Font font = parent.getFont();
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button importButton = new Button(parent, 8);
        importButton.setText(Messages.SDKManagementWidget_import_sdk_button_text);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ASDKPropertyPage.this.performImportSDK();
            }
        });
        importButton.setFont(font);
        this.setButtonLayoutData(importButton);
        this.exportButton = new Button(parent, 8);
        this.exportButton.setText(Messages.SDKManagementWidget_export_sdk_button_text);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ASDKPropertyPage.this.performExportSDK();
            }
        });
        this.exportButton.setFont(font);
        this.setButtonLayoutData(this.exportButton);
    }

    public void updateWidgetState() {
        Runnable update = () -> {
            Object[] saved = this.saveSelection();
            this.updateViewerInput();
            this.restoreSelection(saved);
            this.updateEnabledState();
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(update);
        } else {
            update.run();
        }
    }

    protected void updateEnabledState() {
        ISDK sdk = this.getFirstSelected();
        boolean itemSelected = this.isSelectedSingle() && sdk != null;
        this.editButton.setEnabled(itemSelected);
        if (this.removeButton != null) {
            this.removeButton.setEnabled(!this.getSDKsForDelete().isEmpty());
        }
        this.gitImportButton.setEnabled(itemSelected && sdk instanceof GitSDK);
        this.updateExtraButtonsState();
    }

    protected boolean isSelectedSingle() {
        return this.getAllSelected().size() == 1;
    }

    private Object[] saveSelection() {
        this.lastSelection = this.viewer.getTable().getSelectionIndex();
        return Arrays.asList(this.viewer.getTable().getSelection()).stream().map(ti -> String.valueOf(ti.getText(0)) + ti.getText(1)).toArray();
    }

    private void restoreSelection(Object[] saved) {
        if (saved != null && saved.length > 0) {
            ArrayList<TableItem> sel = new ArrayList<TableItem>();
            TableItem[] tis = this.viewer.getTable().getItems();
            Object[] objectArray = saved;
            int n = saved.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                TableItem[] tableItemArray = tis;
                int n3 = tis.length;
                int n4 = 0;
                while (n4 < n3) {
                    TableItem ti = tableItemArray[n4];
                    if ((String.valueOf(ti.getText(0)) + ti.getText(1)).equals(s)) {
                        sel.add(ti);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (sel.size() > 0) {
                this.viewer.getTable().setSelection(sel.toArray(new TableItem[sel.size()]));
            } else {
                int max = this.viewer.getTable().getItemCount() - 1;
                this.viewer.getTable().setSelection(this.lastSelection != -1 && max >= this.lastSelection ? this.lastSelection : max);
            }
            this.viewer.getTable().setFocus();
        }
    }

    private void setupMenu(Table t) {
        Menu m = new Menu((Control)t);
        MenuItem mi = new MenuItem(m, 8);
        mi.setText(Messages.SDKManagementWidget_reset);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASDKPropertyPage.this.resetTable();
            }
        });
        t.setMenu(m);
    }

    private void resetTable() {
        if (this.viewer != null) {
            Table table = this.viewer.getTable();
            int size = table.getColumnCount();
            int[] order = new int[size];
            int i = 0;
            while (i < size) {
                order[i] = i;
                ++i;
            }
            table.setColumnOrder(order);
            i = 0;
            while (i < size) {
                int len = SDKTableViewerHolder.COLUMN_SIZES[0];
                int last = SDKTableViewerHolder.COLUMN_SIZES.length - 1;
                if (i < last - 1) {
                    len = SDKTableViewerHolder.COLUMN_SIZES[i + 1];
                } else if (i == size - 1) {
                    len = SDKTableViewerHolder.COLUMN_SIZES[last];
                }
                this.viewer.getTable().getColumn(i).setWidth(len);
                ++i;
            }
            this.viewer.getTable().redraw();
        }
    }

    private TCHolder fillRoot(String id, SDKEditDialog d) {
        TCHolder root = new TCHolder(id != null && !id.isEmpty() ? id : null);
        root.addPaths(Arrays.asList(d.getSourcePaths()[0]), 0);
        root.addPaths(Arrays.asList(d.getHeaderPaths()[0]), 1);
        root.addPaths(Arrays.asList(d.getBinaryPaths()[0]), 2);
        root.addPaths(Arrays.asList(d.getOtherPaths()[0]), 3);
        root.addPaths(Arrays.asList(d.getLDPaths()[0]), 4);
        root.setIncludeFiles(d.getIncludedFiles().get(root.getTCId()));
        root.setSymbolsHolder(d.getSymbolHolders().get(root.getTCId()));
        return root;
    }

    private void showSdksInfo() {
        ISDK selectedSdk = this.getFirstSelected();
        if (selectedSdk != null) {
            new SdkInfoDialog(this.shell, selectedSdk).open();
        }
    }

    protected ISDK performCreateSDK() {
        IEnvironment originalEnv;
        IFilterOptions fo = this.getFilterOptions();
        SDKEditDialog dialog = new SDKEditDialog(this.shell, 1, fo, this.getProject());
        TCHolder rootToolChainHolder = fo != null ? new TCHolder(fo.getToolChainID()) : new TCHolder(null);
        String toolChainId = rootToolChainHolder.getTCId();
        dialog.setRootToolchainHolder(rootToolChainHolder);
        dialog.setToolChainHolders(new TCHolder[0]);
        HashMap<String, SdkSymbolsHolder> symbols = new HashMap<String, SdkSymbolsHolder>();
        symbols.put(toolChainId, new SdkSymbolsHolder(toolChainId));
        dialog.setSymbolHolders(symbols);
        if (dialog.open() == 1) {
            this.updateWidgetState();
            return null;
        }
        IFilterOptions newFilterOptions = dialog.getFilter();
        if (newFilterOptions == null) {
            newFilterOptions = FilterOptions.EMPTY_FILTER;
        }
        if (!(originalEnv = dialog.getSDKEnv()).isSystem()) {
            originalEnv.setValue(dialog.getSDKPath(), null, true);
        }
        SDKHeader header = this.createSdkHeader(dialog.getSdkHeaderParameters(), newFilterOptions, originalEnv);
        String tcId = newFilterOptions.getToolChainID();
        TCHolder root = this.fillRoot(tcId, dialog);
        ExternalSDK sdk = this.getProject() == null ? new ExternalSDK(header, root, newFilterOptions) : new ProjectLocalSDK(this.getProject(), header, root, newFilterOptions);
        SDKUtils.add(sdk, false);
        ExternalSDK.storeExternalSDKs();
        this.updateWidgetState();
        return sdk;
    }

    protected ISDK performViewEditSDK() {
        ISDK sdk = this.getFirstSelected();
        boolean isContributed = sdk instanceof IContributedSDK;
        boolean isAttached = !SDKAttach.getAttached(sdk).isEmpty();
        IEnvironment originalEnv = sdk.getEnv();
        int viewEditMode = isContributed || isAttached ? 3 : 2;
        SDKEditDialog dialog = new SDKEditDialog(this.shell, viewEditMode, sdk.getFilterOptions(), this.getProject());
        SDKHeader.SdkHeaderParameters parameters = sdk.getHeader().getSdkHeaderParameters();
        parameters.setEnvironment(originalEnv);
        dialog.setSdkHeaderParameters(parameters);
        dialog.setSourcePaths(sdk.getAll(0));
        dialog.setHeaderPaths(sdk.getAll(1));
        dialog.setBinaryPaths(sdk.getAll(2));
        dialog.setOtherPaths(sdk.getAll(3));
        dialog.setIncludedFiles(sdk.getIncludeFiles());
        dialog.setLDPaths(sdk.getAll(4));
        dialog.setSymbolHolders(sdk.getSymbols(null));
        dialog.setToolChainHolders(sdk.getToolchains());
        dialog.setHeads(sdk.getToolChainAliases(), sdk.getToolChainIDs());
        dialog.setRootToolchainHolder(sdk.getRoot());
        dialog.setModulesHolder(sdk.getModules());
        if (sdk instanceof GitSDK) {
            dialog.setGitPath(((GitSDK)sdk).getGitPath());
        }
        if (dialog.open() == 1) {
            this.updateWidgetState();
            return null;
        }
        IEnvironment newEnv = dialog.getSDKEnv();
        String maybeNewPath = dialog.getSDKPath();
        originalEnv.removeValue();
        if (!newEnv.isSystem()) {
            newEnv.setValue(maybeNewPath, null, true);
        }
        if (!isContributed) {
            IExternalSDK extSDK = (IExternalSDK)sdk;
            IFilterOptions fo = dialog.getFilter();
            String tcId = fo.getToolChainID();
            extSDK.setHeader(this.createSdkHeader(dialog.getSdkHeaderParameters(), fo, dialog.getSDKEnv()));
            extSDK.setPaths(this.fillRoot(tcId, dialog));
            extSDK.setFilterOptions(dialog.getFilter());
        }
        ExternalSDK.storeExternalSDKs();
        this.updateWidgetState();
        return viewEditMode == 2 ? sdk : null;
    }

    protected List<ISDK> performRemoveSDK() {
        List<ISDK> sdks = this.getSDKsForDelete();
        if (!sdks.isEmpty()) {
            StringBuilder names = new StringBuilder();
            for (ISDK sdk : sdks) {
                names.append('\n').append(NLS.bind((String)"{0} v {1} ({2})", (Object[])new String[]{sdk.getName(), sdk.getVersion(), sdk.getStatusText()}));
            }
            if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.SDKManagementWidget_remove_sdk_confirmation_title, (String)String.format(Messages.SDKManagementWidget_remove_sdk_confirmation_text, String.valueOf(names.toString()) + '\n'))) {
                for (ISDK sdk : sdks) {
                    SDKUtils.remove(sdk);
                }
                ImportSDK.storeImportSDKs();
                ExternalSDK.storeExternalSDKs();
                ContributedSdkHandler.updatePersistedContributedExternalSdks();
                InternalSdkHandler.updatePersistedInternalSdks();
                this.updateWidgetState();
            } else {
                sdks.clear();
            }
        }
        return sdks;
    }

    protected List<ISDK> performImportSDK() {
        SDKImportDialog dialog = new SDKImportDialog(this.shell);
        if (dialog.open() != 0) {
            return null;
        }
        List<ISDK> importedSDKs = null;
        SDKImportHandler h = new SDKImportHandler();
        h.setSDKImportUICallbackHandler(new SDKImportUICallbackHandler(this.shell));
        try {
            importedSDKs = dialog.mode() == 0 ? h.importSDK(dialog.destination(), dialog.location()) : h.importSDK(dialog.source());
            this.updateWidgetState();
        }
        catch (SDKLoadException sle) {
            SDKSupportPlugin.log(sle.getStatus());
        }
        return importedSDKs;
    }

    private void performExportSDK() {
        IExternalSDK sdk = (IExternalSDK)this.getFirstSelected();
        SDKExportDialog dialog = new SDKExportDialog(this.shell, sdk);
        if (dialog.open() == 0) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                String location = dialog.location();
                boolean isExportDescriptorOnly = !dialog.withContent();
                ps.run(false, false, pm -> new SDKExportHandler().exportSDK(location, sdk, isExportDescriptorOnly, pm));
            }
            catch (InterruptedException | InvocationTargetException e) {
                SDKSupportPlugin.error(e);
            }
        }
        this.updateWidgetState();
    }

    protected ISDK getFirstSelected() {
        return this.getAllSelected().stream().findFirst().orElse(null);
    }

    protected List<ISDK> getAllSelected() {
        return Stream.of(this.viewer.getTable().getSelection()).filter(i -> i.getData() instanceof ISDK).collect(Collectors.mapping(i -> (ISDK)i.getData(), Collectors.toList()));
    }

    private List<ISDK> getSDKsForDelete() {
        return this.getAllSelected().stream().filter(sdk -> sdk instanceof IExternalSDK || sdk instanceof ImportSDK || ISDK.TYPE.CONTRIBUTED_EXTERNAL == sdk.getType()).collect(Collectors.toList());
    }

    private void loadGitData(Shell shell) {
        ISDK xz = this.getFirstSelected();
        if (!(xz instanceof GitSDK)) {
            return;
        }
        GitSDK sdk = (GitSDK)xz;
        if (sdk.getGitPath() == null || sdk.getGitPath().isEmpty()) {
            Status st = new Status(8, "com.freescale.s32ds.cross.sdk.support", GIT_EMPTY_REP);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)GIT_ERROR_TITLE, null, (IStatus)st);
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(shell);
        String p = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support").get(GIT_LOAD_KEY, "");
        dialog.setFilterPath(p);
        dialog.setMessage(String.format(Messages.SDKManagementWidget_remote_url, sdk.getGitPath()));
        dialog.setText(Messages.SDKManagementWidget_select_dest_folder);
        String dir = dialog.open();
        if (dir == null || dir.isEmpty() || !new File(dir).isDirectory()) {
            Status st = new Status(8, "com.freescale.s32ds.cross.sdk.support", GIT_LOCAL_BAD);
            ErrorDialog.openError((Shell)shell, (String)GIT_ERROR_TITLE, (String)GIT_LOCAL_BAD, (IStatus)st);
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        prefs.put(GIT_LOAD_KEY, dir);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, false, monitor -> {
                try {
                    GitSDK.importFromGit(sdk, new File(dir), monitor, shell);
                    this.updateWidgetState();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            });
        }
        catch (Exception ex) {
            Status st = new Status(4, "com.freescale.s32ds.cross.sdk.support", ex.getMessage(), (Throwable)ex);
            SDKSupportPlugin.log((IStatus)st);
            ErrorDialog.openError((Shell)shell, (String)GIT_ERROR_TITLE, (String)ex.getMessage(), (IStatus)st);
        }
    }

    protected void updateViewerInput() {
        List<ISDK> sdks = this.getSDKs();
        this.viewer.setInput(sdks);
        this.viewer.setItemCount(sdks.size());
    }

    private SDKHeader createSdkHeader(SDKHeader.SdkHeaderParameters parameters, IFilterOptions filterOptions, IEnvironment environment) {
        parameters.setLangs(filterOptions.getLang().toString());
        parameters.setCores(String.join((CharSequence)",", filterOptions.getCores()));
        parameters.setEnvironment(environment);
        return new SDKHeader(parameters);
    }

    protected List<ISDK> getFilteredSdks(ISDKFilter filter) {
        List<ISDK> filteredSdks = SDKUtils.filter(filter);
        return filteredSdks.stream().filter(sdk -> ISDK.TYPE.INTERNAL != sdk.getType()).collect(Collectors.toList());
    }
}

